/*
 * Decompiled with CFR 0.152.
 */
package play.runsupport;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import play.core.BuildLink;
import play.dev.filewatch.FileWatchService;
import play.dev.filewatch.FileWatcher;
import play.runsupport.CompileResult;
import play.runsupport.DevServerRunner;
import play.runsupport.GeneratedSourceMapping;
import play.runsupport.Source;
import play.runsupport.classloader.DelegatedResourcesClassLoader;

class DevServerReloader
implements BuildLink,
Closeable {
    private final File projectPath;
    private static final AccessControlContext accessControlContext = AccessController.getContext();
    private final Object reloadLock;
    private final Supplier<CompileResult> compile;
    private final Supplier<Boolean> triggerReload;
    private final ClassLoader baseClassLoader;
    private final Map<String, String> devSettings;
    private final Map<String, ? extends GeneratedSourceMapping> generatedSourceHandlers;
    private volatile URLClassLoader currentApplicationClassLoader;
    private volatile boolean forceReloadNextTime = false;
    private volatile boolean changed = false;
    private volatile Map<String, Source> currentSourceMap;
    private volatile long lastModified = 0L;
    private final FileWatcher watcher;
    private final AtomicInteger classLoaderVersion = new AtomicInteger(0);

    DevServerReloader(File file, ClassLoader classLoader, Supplier<CompileResult> supplier, Map<String, String> map, Supplier<Boolean> supplier2, List<File> list, FileWatchService fileWatchService, Map<String, ? extends GeneratedSourceMapping> map2, Object object) {
        this.projectPath = file;
        this.baseClassLoader = classLoader;
        this.compile = supplier;
        this.devSettings = map;
        this.generatedSourceHandlers = map2;
        this.triggerReload = supplier2;
        this.watcher = !list.isEmpty() && fileWatchService != null ? fileWatchService.watch(list, () -> {
            this.changed = true;
        }) : null;
        this.reloadLock = object;
    }

    private static <T> T withReloaderContextClassLoader(Supplier<T> supplier) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        return (T)AccessController.doPrivileged(() -> {
            try {
                thread.setContextClassLoader(DevServerReloader.class.getClassLoader());
                Object t = supplier.get();
                return t;
            }
            finally {
                thread.setContextClassLoader(classLoader);
            }
        }, accessControlContext);
    }

    public File projectPath() {
        return this.projectPath;
    }

    private Object reload(boolean bl) {
        CompileResult compileResult = this.compile.get();
        if (compileResult instanceof CompileResult.CompileFailure) {
            CompileResult.CompileFailure compileFailure = (CompileResult.CompileFailure)compileResult;
            this.forceReloadNextTime = true;
            return compileFailure.getException();
        }
        if (compileResult instanceof CompileResult.CompileSuccess) {
            CompileResult.CompileSuccess compileSuccess = (CompileResult.CompileSuccess)compileResult;
            List<File> list = compileSuccess.getClasspath();
            this.currentSourceMap = compileSuccess.getSources();
            long l = list.stream().filter(File::exists).flatMap(DevServerReloader::listRecursively).mapToLong(File::lastModified).max().orElse(0L);
            boolean bl2 = l > this.lastModified;
            this.lastModified = l;
            if (bl2 || bl || this.currentApplicationClassLoader == null) {
                this.currentApplicationClassLoader = new DelegatedResourcesClassLoader("ReloadableClassLoader(v" + this.classLoaderVersion.incrementAndGet() + ")", DevServerRunner.urls(list), this.baseClassLoader);
                return this.currentApplicationClassLoader;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object reload() {
        Object object = this.reloadLock;
        synchronized (object) {
            if (this.changed || this.triggerReload != null && this.triggerReload.get().booleanValue() || this.forceReloadNextTime || this.currentSourceMap == null || this.currentApplicationClassLoader == null) {
                boolean bl = this.forceReloadNextTime;
                this.changed = false;
                this.forceReloadNextTime = false;
                return DevServerReloader.withReloaderContextClassLoader(() -> this.reload(bl));
            }
            return null;
        }
    }

    private static Stream<File> listRecursively(File file) {
        try {
            return Files.walk(file.toPath(), new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0]) || !path.equals(file.toPath())).map(Path::toFile);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Map<String, String> settings() {
        return this.devSettings;
    }

    public void forceReload() {
        this.forceReloadNextTime = true;
    }

    public Object[] findSource(String string, Integer n) {
        String string2 = string.split("\\$")[0];
        if (this.currentSourceMap == null || !this.currentSourceMap.containsKey(string2)) {
            return null;
        }
        Source source = this.currentSourceMap.get(string2);
        if (source.getOriginal() == null) {
            return new Object[]{source.getFile(), n};
        }
        if (n != null) {
            File file = source.getOriginal();
            String string3 = Arrays.stream(file.getName().split("\\.")).skip(1L).collect(Collectors.joining("."));
            if (this.generatedSourceHandlers.containsKey(string3)) {
                return new Object[]{file, this.generatedSourceHandlers.get(string3).getOriginalLine(source.getFile(), n)};
            }
            return new Object[]{file, n};
        }
        return new Object[]{source.getOriginal(), null};
    }

    @Override
    public void close() {
        this.currentApplicationClassLoader = null;
        this.currentSourceMap = null;
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }

    public URLClassLoader getClassLoader() {
        return this.currentApplicationClassLoader;
    }
}

