/*
 * Decompiled with CFR 0.152.
 */
package play.runsupport;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import play.core.Build;
import play.core.BuildLink;
import play.core.server.ReloadableServer;
import play.dev.filewatch.FileWatchService;
import play.runsupport.CompileResult;
import play.runsupport.DevServer;
import play.runsupport.DevServerReloader;
import play.runsupport.DevServerSettings;
import play.runsupport.GeneratedSourceMapping;
import play.runsupport.RunHook;
import play.runsupport.RunHooksRunner;
import play.runsupport.ServerStartException;
import play.runsupport.classloader.DelegatingClassLoader;
import play.runsupport.classloader.NamedURLClassLoader;

public final class DevServerRunner {
    private DevServerReloader reloader;

    private ReloadableServer getReloadableServer(ClassLoader classLoader, String string, DevServerSettings devServerSettings) throws ReflectiveOperationException {
        ReloadableServer reloadableServer;
        Integer n = devServerSettings.getHttpPort();
        Integer n2 = devServerSettings.getHttpsPort();
        String string2 = devServerSettings.getHttpAddress();
        Class<?> clazz = classLoader.loadClass(string);
        if (devServerSettings.isHttpPortDefined() && devServerSettings.isHttpsPortDefined()) {
            Method method = clazz.getMethod("mainDevHttpAndHttpsMode", BuildLink.class, Integer.TYPE, Integer.TYPE, String.class);
            reloadableServer = (ReloadableServer)method.invoke(null, this.reloader, n, n2, string2);
        } else if (devServerSettings.isHttpPortDefined()) {
            Method method = clazz.getMethod("mainDevHttpMode", BuildLink.class, Integer.TYPE, String.class);
            reloadableServer = (ReloadableServer)method.invoke(null, this.reloader, n, string2);
        } else {
            Method method = clazz.getMethod("mainDevOnlyHttpsMode", BuildLink.class, Integer.TYPE, String.class);
            reloadableServer = (ReloadableServer)method.invoke(null, this.reloader, n2, string2);
        }
        return reloadableServer;
    }

    private DevServer run(final List<? extends RunHook> list, List<String> list2, ClassLoader classLoader, List<File> list3, Supplier<CompileResult> supplier, Function<ClassLoader, ClassLoader> function, Supplier<Boolean> supplier2, List<File> list4, FileWatchService fileWatchService, Map<String, ? extends GeneratedSourceMapping> map, int n, String string, File file, Map<String, String> map2, List<String> list5, String string2, Object object) {
        if (this.reloader != null) {
            throw new IllegalStateException("Cannot run a dev server because another one is already running!");
        }
        final DevServerSettings devServerSettings = DevServerSettings.parse(list2, list5, map2, n, string);
        if (!devServerSettings.isAnyPortDefined()) {
            throw new IllegalArgumentException("You have to specify https.port when http.port is disabled");
        }
        devServerSettings.getMergedProperties().forEach(System::setProperty);
        System.out.println();
        ClassLoader classLoader2 = this.getClass().getClassLoader();
        try {
            RunHooksRunner.run(list, RunHook::beforeStarted);
            DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader(classLoader, Build.sharedClasses, classLoader2, () -> this.reloader.getClassLoader());
            NamedURLClassLoader namedURLClassLoader = new NamedURLClassLoader("DependencyClassLoader", DevServerRunner.urls(list3), delegatingClassLoader);
            ClassLoader classLoader3 = function.apply(namedURLClassLoader);
            this.reloader = new DevServerReloader(file, classLoader3, supplier, map2, supplier2, list4, fileWatchService, map, object);
            final ReloadableServer reloadableServer = this.getReloadableServer(namedURLClassLoader, string2, devServerSettings);
            RunHooksRunner.run(list, RunHook::afterStarted);
            return new DevServer(){

                @Override
                public BuildLink buildLink() {
                    return DevServerRunner.this.reloader;
                }

                @Override
                public void reload() {
                    reloadableServer.reload();
                }

                @Override
                public void close() {
                    reloadableServer.stop();
                    DevServerRunner.this.reloader.close();
                    RunHooksRunner.run(list, RunHook::afterStopped);
                    devServerSettings.getMergedProperties().forEach((string, string2) -> System.clearProperty(string));
                    DevServerRunner.this.reloader = null;
                }
            };
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            list.forEach(runHook -> {
                try {
                    runHook.onError();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.reloader = null;
            for (throwable2 = throwable; throwable2.getCause() != null && throwable2.getCause() != throwable2; throwable2 = throwable2.getCause()) {
            }
            if (throwable2.getClass().getName().equals("play.core.server.ServerListenException")) {
                throw new ServerStartException(throwable);
            }
            throw new RuntimeException(throwable);
        }
    }

    public static URL[] urls(List<File> list) {
        return (URL[])list.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }).toArray(URL[]::new);
    }

    public static DevServer startDevMode(List<? extends RunHook> list, List<String> list2, ClassLoader classLoader, List<File> list3, Supplier<CompileResult> supplier, Function<ClassLoader, ClassLoader> function, Supplier<Boolean> supplier2, List<File> list4, FileWatchService fileWatchService, Map<String, ? extends GeneratedSourceMapping> map, int n, String string, File file, Map<String, String> map2, List<String> list5, String string2, Object object) {
        return DevServerRunner.getInstance().run(list, list2, classLoader, list3, supplier, function, supplier2, list4, fileWatchService, map, n, string, file, map2, list5, string2, object);
    }

    private DevServerRunner() {
    }

    public static DevServerRunner getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        public static final DevServerRunner INSTANCE = new DevServerRunner();

        private Holder() {
        }
    }
}

