/*
 * Decompiled with CFR 0.152.
 */
package play.runsupport;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DevServerSettings {
    public static final String PORT_DISABLED = "disabled";
    private static final Pattern SYSTEM_PROPERTY = Pattern.compile("-D([^=]+)=(.*)");
    private final LinkedHashMap<String, String> javaOptionProperties;
    private final LinkedHashMap<String, String> argsProperties;
    private final Integer httpPort;
    private final Integer httpsPort;
    private final String httpAddress;

    private DevServerSettings(LinkedHashMap<String, String> linkedHashMap, LinkedHashMap<String, String> linkedHashMap2, Integer n, Integer n2, String string) {
        this.javaOptionProperties = linkedHashMap;
        this.argsProperties = linkedHashMap2;
        this.httpPort = n;
        this.httpsPort = n2;
        this.httpAddress = string;
    }

    public String getHttpPortOrDisabled() {
        return this.httpPort != null ? this.httpPort.toString() : PORT_DISABLED;
    }

    public boolean isAnyPortDefined() {
        return this.isHttpPortDefined() || this.isHttpsPortDefined();
    }

    public boolean isHttpPortDefined() {
        return this.httpPort != null;
    }

    public boolean isHttpsPortDefined() {
        return this.httpsPort != null;
    }

    public LinkedHashMap<String, String> getJavaOptionProperties() {
        return this.javaOptionProperties;
    }

    public LinkedHashMap<String, String> getArgsProperties() {
        return this.argsProperties;
    }

    public LinkedHashMap<String, String> getMergedProperties() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.putAll(this.javaOptionProperties);
        linkedHashMap.putAll(this.argsProperties);
        linkedHashMap.put("play.server.http.address", this.httpAddress);
        linkedHashMap.put("play.server.http.port", this.getHttpPortOrDisabled());
        if (this.isHttpsPortDefined()) {
            linkedHashMap.put("play.server.https.port", this.httpsPort.toString());
        }
        return linkedHashMap;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public Integer getHttpsPort() {
        return this.httpsPort;
    }

    public String getHttpAddress() {
        return this.httpAddress;
    }

    public static DevServerSettings parse(List<String> list, List<String> list2, Map<String, String> map, int n, String string2) {
        LinkedHashMap<String, String> linkedHashMap = DevServerSettings.extractProperties(list2);
        Optional<String> optional = list2.stream().filter(string -> !string.startsWith("-D")).findFirst();
        Function<String, Optional> function = string -> Optional.ofNullable((String)linkedHashMap.get(string)).or(() -> Optional.ofNullable(System.getProperty(string)));
        String string3 = function.apply("play.server.http.port").or(() -> (Optional)function.apply("http.port")).or(() -> optional).or(() -> Optional.ofNullable((String)map.get("play.server.http.port"))).or(() -> Optional.ofNullable(System.getenv("PLAY_HTTP_PORT"))).orElse(null);
        Integer n2 = DevServerSettings.parsePort(string3, n);
        String string4 = function.apply("play.server.https.port").or(() -> (Optional)function.apply("https.port")).or(() -> Optional.ofNullable((String)map.get("play.server.https.port"))).or(() -> Optional.ofNullable(System.getenv("PLAY_HTTPS_PORT"))).orElse(null);
        Integer n3 = DevServerSettings.parsePort(string4, null);
        String string5 = function.apply("play.server.http.address").or(() -> (Optional)function.apply("http.address")).or(() -> Optional.ofNullable((String)map.get("play.server.http.address"))).or(() -> Optional.ofNullable(System.getenv("PLAY_HTTP_ADDRESS"))).orElse(string2);
        return new DevServerSettings(DevServerSettings.extractProperties(list), linkedHashMap, n2, n3, string5);
    }

    private static Integer parsePort(String string, Integer n) {
        if (string == null) {
            return n;
        }
        if (string.equalsIgnoreCase(PORT_DISABLED)) {
            return null;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid port argument: " + string);
        }
    }

    private static LinkedHashMap<String, String> extractProperties(List<String> list) {
        return list.stream().map(SYSTEM_PROPERTY::matcher).filter(Matcher::matches).collect(Collectors.toMap(matcher -> matcher.group(1), matcher -> matcher.group(2), (string, string2) -> string2, LinkedHashMap::new));
    }
}

