/*
 * Decompiled with CFR 0.152.
 */
package play.runsupport.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import play.runsupport.classloader.ApplicationClassLoaderProvider;

public class DelegatingClassLoader
extends ClassLoader {
    private List<String> sharedClasses;
    private ClassLoader buildLoader;
    private ApplicationClassLoaderProvider applicationClassLoaderProvider;

    public DelegatingClassLoader(ClassLoader classLoader, List<String> list, ClassLoader classLoader2, ApplicationClassLoaderProvider applicationClassLoaderProvider) {
        super(classLoader);
        this.sharedClasses = list;
        this.buildLoader = classLoader2;
        this.applicationClassLoaderProvider = applicationClassLoaderProvider;
    }

    @Override
    public Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (this.sharedClasses.contains(string)) {
            return this.buildLoader.loadClass(string);
        }
        return super.loadClass(string, bl);
    }

    @Override
    public URL getResource(String string) {
        URLClassLoader uRLClassLoader = this.applicationClassLoaderProvider.get();
        URL uRL = null;
        if (uRLClassLoader != null) {
            uRL = uRLClassLoader.findResource(string);
        }
        return uRL != null ? uRL : super.getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        URLClassLoader uRLClassLoader = this.applicationClassLoaderProvider.get();
        Enumeration<URL> enumeration = uRLClassLoader != null ? uRLClassLoader.findResources(string) : new Vector().elements();
        Enumeration<URL> enumeration2 = super.getResources(string);
        return this.combineResources(enumeration, enumeration2);
    }

    private Enumeration<URL> combineResources(Enumeration<URL> enumeration, Enumeration<URL> enumeration2) {
        HashSet<URL> hashSet = new HashSet<URL>();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            hashSet.add(enumeration2.nextElement());
        }
        return new Vector(hashSet).elements();
    }

    public String toString() {
        return "DelegatingClassLoader, using parent: " + String.valueOf(this.getParent());
    }
}

