/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Materializer$;
import play.api.Application;
import play.api.ApplicationLoader;
import play.api.ApplicationLoader$;
import play.api.ApplicationStoppedReason$;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Environment$;
import play.api.LoggerConfigurator;
import play.api.LoggerConfigurator$;
import play.api.Mode;
import play.api.Play$;
import play.api.PlayException;
import play.api.UnexpectedException$;
import play.api.UsefulException;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.DefaultApplicationLifecycle;
import play.core.ApplicationProvider;
import play.core.BuildLink;
import play.core.SourceMapper;
import play.core.server.DevServerStart;
import play.core.server.DevServerStart$;
import play.core.server.RealServerProcess;
import play.core.server.ReloadableServer;
import play.core.server.Server;
import play.core.server.ServerConfig;
import play.core.server.ServerConfig$;
import play.core.server.ServerProvider;
import play.core.server.ServerProvider$;
import play.core.server.ServerProvider$Context$;
import play.utils.Colors$;
import play.utils.Threads$;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

@InternalApi
public final class DevServerStart {
    private final Function1<Configuration, ActorSystem> mkServerActorSystem;
    private final Map<String, Object> additionalSettings;

    public static ReloadableServer mainDevHttpAndHttpsMode(BuildLink buildLink, int n, int n2, String string) {
        return DevServerStart$.MODULE$.mainDevHttpAndHttpsMode(buildLink, n, n2, string);
    }

    public static ReloadableServer mainDevHttpMode(BuildLink buildLink, int n, String string) {
        return DevServerStart$.MODULE$.mainDevHttpMode(buildLink, n, string);
    }

    public static ReloadableServer mainDevOnlyHttpsMode(BuildLink buildLink, int n, String string) {
        return DevServerStart$.MODULE$.mainDevOnlyHttpsMode(buildLink, n, string);
    }

    public DevServerStart(Function1<Configuration, ActorSystem> mkServerActorSystem, Map<String, Object> additionalSettings) {
        this.mkServerActorSystem = mkServerActorSystem;
        this.additionalSettings = additionalSettings;
    }

    public ReloadableServer mainDev(BuildLink buildLink, String httpAddress, int httpPort, int httpsPort) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return (ReloadableServer)Threads$.MODULE$.withContextClassLoader(classLoader, () -> this.mainDev$$anonfun$1(buildLink, classLoader, httpPort, httpsPort, httpAddress));
    }

    private static final /* synthetic */ Integer sourceOf$$anonfun$1(int _$1) {
        return BoxesRunTime.boxToInteger((int)_$1);
    }

    public static /* bridge */ /* synthetic */ Integer play$core$server$DevServerStart$DevServerApplicationProvider$1$$anon$1$$_$sourceOf$$anonfun$adapted$1(Object _$1) {
        return DevServerStart.sourceOf$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1));
    }

    public static final /* synthetic */ Option play$core$server$DevServerStart$DevServerApplicationProvider$1$$anon$1$$_$sourceOf$$anonfun$2(Object[] x$1) {
        Object object;
        Object[] objectArray = x$1;
        if (objectArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)objectArray), 2) == 0) {
            Object object2 = Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            Object object3 = Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            if (object2 instanceof File) {
                File file;
                File file2 = file = (File)object2;
                if (object3 == null) {
                    return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)file2, (Object)None$.MODULE$));
                }
                File file3 = file;
                if (object3 instanceof Integer) {
                    Integer line = (Integer)object3;
                    return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)file3, (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(line)))));
                }
            }
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ void play$core$server$DevServerStart$DevServerApplicationProvider$1$$_$reload$$anonfun$1(Application app) {
        Play$.MODULE$.stop(app);
    }

    private static final Done$ mainDev$$anonfun$1$$anonfun$1$$anonfun$2() {
        return Done$.MODULE$;
    }

    private final Server mainDev$$anonfun$1(BuildLink buildLink$1, ClassLoader classLoader$1, int httpPort$1, int httpsPort$1, String httpAddress$1) {
        Server server;
        try {
            Boolean bl;
            RealServerProcess process = new RealServerProcess((Seq<String>)((Seq)package$.MODULE$.Seq().empty()));
            File path = buildLink$1.projectPath();
            Map dirAndDevSettings = (Map)((MapOps)ServerConfig$.MODULE$.rootDirConfig(path).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(buildLink$1.settings()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).$plus$plus(this.additionalSettings);
            String string = System.getProperty("play.debug.classpath");
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                System.out.println("\n---- Current ClassLoader ----\n");
                System.out.println(this.getClass().getClassLoader());
                System.out.println("\n---- The where is Scala? test ----\n");
                System.out.println(this.getClass().getClassLoader().getResource("scala/Predef$.class"));
            }
            long startupWarningThreshold = 1000L;
            long before = System.currentTimeMillis();
            InetAddress address = InetAddress.getLocalHost();
            long after = System.currentTimeMillis();
            if (after - before > startupWarningThreshold) {
                Predef$.MODULE$.println((Object)Colors$.MODULE$.red("WARNING: Retrieving local host name " + address + " took more than " + startupWarningThreshold + "ms, this can create problems at startup"));
                Predef$.MODULE$.println((Object)Colors$.MODULE$.red("If you are using macOS, see https://stackoverflow.com/a/39698914/810109 for a potential solution"));
            }
            try {
                bl = BoxesRunTime.boxToBoolean((boolean)new File(path, "logs/application.log").delete());
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable throwable3 = (Throwable)option.get();
                bl = BoxedUnit.UNIT;
            }
            Option option = LoggerConfigurator$.MODULE$.apply(classLoader$1);
            if (option instanceof Some) {
                LoggerConfigurator loggerConfigurator = (LoggerConfigurator)((Some)option).value();
                loggerConfigurator.init(path, (Mode)Mode.Dev$.MODULE$);
            } else if (None$.MODULE$.equals(option)) {
                Predef$.MODULE$.println((Object)"No play.logger.configurator found: logging must be configured entirely by the application.");
            } else {
                throw new MatchError((Object)option);
            }
            Predef$.MODULE$.println((Object)Colors$.MODULE$.magenta("--- (Running the application, auto-reloading is enabled) ---"));
            Predef$.MODULE$.println();
            public class Play_core_server_DevServerStart$DevServerApplicationProvider$1
            implements ApplicationProvider {
                public final BuildLink play$core$server$DevServerStart$DevServerApplicationProvider$1$$buildLink$2;
                private final File path$1;
                private final Map dirAndDevSettings$1;
                private Try lastState;
                private Option lastLifecycle;
                private final AtomicBoolean isShutdown;

                public Play_core_server_DevServerStart$DevServerApplicationProvider$1(BuildLink buildLink$3, File path$2, Map dirAndDevSettings$2) {
                    this.play$core$server$DevServerStart$DevServerApplicationProvider$1$$buildLink$2 = buildLink$3;
                    this.path$1 = path$2;
                    this.dirAndDevSettings$1 = dirAndDevSettings$2;
                    this.lastState = Failure$.MODULE$.apply((Throwable)new PlayException("Not initialized", "?"));
                    this.lastLifecycle = None$.MODULE$;
                    this.isShutdown = new AtomicBoolean(false);
                }

                public Try lastState() {
                    return this.lastState;
                }

                public void lastState_$eq(Try x$1) {
                    this.lastState = x$1;
                }

                public Option lastLifecycle() {
                    return this.lastLifecycle;
                }

                public void lastLifecycle_$eq(Option x$1) {
                    this.lastLifecycle = x$1;
                }

                public AtomicBoolean isShutdown() {
                    return this.isShutdown;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Try get() {
                    if (this.isShutdown().get()) {
                        return this.lastState();
                    }
                    Play_core_server_DevServerStart$DevServerApplicationProvider$1 var1_1 = this;
                    synchronized (var1_1) {
                        Object object = this.play$core$server$DevServerStart$DevServerApplicationProvider$1$$buildLink$2.reload();
                        if (object instanceof ClassLoader) {
                            ClassLoader cl = (ClassLoader)object;
                            v0 = this.reload(cl);
                            return v0;
                        } else if (object == null) {
                            v0 = this.lastState();
                            return v0;
                        } else {
                            if (!(object instanceof Throwable)) throw new MatchError(object);
                            Throwable throwable = (Throwable)object;
                            Option option = NonFatal$.MODULE$.unapply(throwable);
                            if (!option.isEmpty()) {
                                Throwable throwable2;
                                Throwable t = throwable2 = (Throwable)option.get();
                                v0 = Failure$.MODULE$.apply(t);
                                return v0;
                            } else {
                                Throwable t = throwable;
                                throw t;
                            }
                        }
                    }
                }

                public Try reload(ClassLoader projectClassloader) {
                    Try try_;
                    SourceMapper sourceMapper = new SourceMapper(this){
                        private final /* synthetic */ Play_core_server_DevServerStart$DevServerApplicationProvider$1 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public Option sourceOf(String className, Option line) {
                            return Option$.MODULE$.apply((Object)this.$outer.play$core$server$DevServerStart$DevServerApplicationProvider$1$$buildLink$2.findSource(className, (Integer)line.map(DevServerStart::play$core$server$DevServerStart$DevServerApplicationProvider$1$$anon$1$$_$sourceOf$$anonfun$adapted$1).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))).flatMap(DevServerStart::play$core$server$DevServerStart$DevServerApplicationProvider$1$$anon$1$$_$sourceOf$$anonfun$2);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$server$DevServerStart$DevServerApplicationProvider$1$$anon$1$$_$sourceOf$$anonfun$adapted$1(java.lang.Object ), play$core$server$DevServerStart$DevServerApplicationProvider$1$$anon$1$$_$sourceOf$$anonfun$2(java.lang.Object[] )}, serializedLambda);
                        }
                    };
                    try {
                        if (this.lastState().isSuccess()) {
                            Predef$.MODULE$.println();
                            Predef$.MODULE$.println((Object)Colors$.MODULE$.magenta("--- (RELOAD) ---"));
                            Predef$.MODULE$.println();
                        }
                        this.lastState().foreach((Function1)((JProcedure1 & Serializable)DevServerStart::play$core$server$DevServerStart$DevServerApplicationProvider$1$$_$reload$$anonfun$1));
                        Environment environment = Environment$.MODULE$.apply(this.path$1, projectClassloader, (Mode)Mode.Dev$.MODULE$);
                        DefaultApplicationLifecycle lifecycle = new DefaultApplicationLifecycle();
                        this.lastLifecycle_$eq((Option)Some$.MODULE$.apply((Object)lifecycle));
                        Application newApplication = (Application)Threads$.MODULE$.withContextClassLoader(projectClassloader, () -> this.$anonfun$1(environment, lifecycle, sourceMapper));
                        newApplication.coordinatedShutdown().addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "force-reload", (Function0 & Serializable)() -> {
                            if (!newApplication.coordinatedShutdown().shutdownReason().contains((Object)ApplicationStoppedReason$.MODULE$)) {
                                this.play$core$server$DevServerStart$DevServerApplicationProvider$1$$buildLink$2.forceReload();
                            }
                            return Future$.MODULE$.successful((Object)Done$.MODULE$);
                        });
                        Play$.MODULE$.start(newApplication);
                        this.lastState_$eq((Try)Success$.MODULE$.apply((Object)newApplication));
                        this.isShutdown().set(false);
                        try_ = this.lastState();
                    }
                    catch (PlayException e) {
                        this.lastState_$eq((Try)Failure$.MODULE$.apply((Throwable)e));
                        this.logExceptionAndGetResult(this.path$1, e, this.logExceptionAndGetResult$default$3());
                        try_ = this.lastState();
                    }
                    catch (LinkageError e) {
                        Some some = Some$.MODULE$.apply((Object)e);
                        Option option = UnexpectedException$.MODULE$.$lessinit$greater$default$1();
                        this.lastState_$eq((Try)Failure$.MODULE$.apply((Throwable)UnexpectedException$.MODULE$.apply(option, (Option)some)));
                        this.logExceptionAndGetResult(this.path$1, e, this.logExceptionAndGetResult$default$3());
                        try_ = this.lastState();
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option.get();
                            UsefulException useful = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException((Option)Some$.MODULE$.apply((Object)sourceMapper), false, e);
                            String string = e.getClass().getName();
                            String string2 = "com.google.inject.CreationException";
                            String hint = !(string != null ? !string.equals(string2) : string2 != null) ? "Hint: Maybe you forgot to enable your service Module class via `play.modules.enabled`? (check in your project's application.conf)" : "";
                            this.lastState_$eq((Try)Failure$.MODULE$.apply((Throwable)useful));
                            this.logExceptionAndGetResult(this.path$1, (Throwable)useful, hint);
                            try_ = this.lastState();
                        }
                        throw throwable;
                    }
                    return try_;
                }

                private void logExceptionAndGetResult(File path, Throwable e, String hint) {
                    e.printStackTrace();
                    Predef$.MODULE$.println();
                    Predef$.MODULE$.println((Object)Colors$.MODULE$.red("Stacktrace caused by project " + path.getName() + " (filesystem path to project is " + path.getAbsolutePath() + ").\n" + hint));
                }

                private String logExceptionAndGetResult$default$3() {
                    return "";
                }

                private final Application $anonfun$1(Environment environment$1, DefaultApplicationLifecycle lifecycle$1, SourceMapper sourceMapper$1) {
                    ApplicationLoader.Context context = ApplicationLoader.Context$.MODULE$.create(environment$1, this.dirAndDevSettings$1, (ApplicationLifecycle)lifecycle$1, (Option)Some$.MODULE$.apply((Object)ApplicationLoader.DevContext$.MODULE$.apply(sourceMapper$1, this.play$core$server$DevServerStart$DevServerApplicationProvider$1$$buildLink$2)));
                    ApplicationLoader loader = ApplicationLoader$.MODULE$.apply(context);
                    return loader.load(context);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$server$DevServerStart$DevServerApplicationProvider$1$$_$reload$$anonfun$1(play.api.Application ), $anonfun$1(play.api.Environment play.api.inject.DefaultApplicationLifecycle play.core.SourceMapper ), reload$$anonfun$2(play.api.Application )}, serializedLambda);
                }
            }
            Play_core_server_DevServerStart$DevServerApplicationProvider$1 appProvider = new Play_core_server_DevServerStart$DevServerApplicationProvider$1(buildLink$1, path, dirAndDevSettings);
            ServerConfig serverConfig = ServerConfig$.MODULE$.apply(path, (Option<Object>)(httpPort$1 >= 0 ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)httpPort$1)) : None$.MODULE$), (Option<Object>)(httpsPort$1 >= 0 ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)httpsPort$1)) : None$.MODULE$), httpAddress$1, (Mode)Mode.Dev$.MODULE$, process.properties(), Configuration$.MODULE$.load(classLoader$1, System.getProperties(), dirAndDevSettings, true));
            ActorSystem actorSystem = (ActorSystem)this.mkServerActorSystem.apply((Object)serverConfig.configuration());
            CoordinatedShutdown serverCs = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(actorSystem);
            serverCs.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceStop(), "shutdown-application-dev-mode", (Function0 & Serializable)() -> {
                ExecutionContextExecutor ctx = actorSystem.dispatcher();
                appProvider.lastState().foreach((Function1)(JProcedure1 & Serializable)app -> Play$.MODULE$.stop(app));
                appProvider.isShutdown().set(true);
                return Future$.MODULE$.apply(DevServerStart::mainDev$$anonfun$1$$anonfun$1$$anonfun$2, (ExecutionContext)ctx);
            });
            ServerProvider.Context serverContext = ServerProvider$Context$.MODULE$.apply(serverConfig, appProvider, actorSystem, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)actorSystem), (Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT));
            ServerProvider serverProvider = ServerProvider$.MODULE$.fromConfiguration(classLoader$1, serverConfig.configuration());
            server = serverProvider.createServer(serverContext);
        }
        catch (ExceptionInInitializerError e) {
            throw e.getCause();
        }
        return server;
    }
}

