/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.slick;

import com.typesafe.config.Config;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.MarkerContext$;
import play.api.PlayException;
import play.api.db.slick.DbName;
import play.api.db.slick.DbName$;
import play.api.db.slick.DefaultSlickApi$DatabaseConfigFactory$;
import play.api.db.slick.SlickApi;
import play.api.inject.ApplicationLifecycle;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import slick.basic.BasicProfile;
import slick.basic.DatabaseConfig;
import slick.basic.DatabaseConfig$;

public final class DefaultSlickApi
implements SlickApi {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DefaultSlickApi.class.getDeclaredField("allDbConfigs$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DefaultSlickApi.class.getDeclaredField("dbconfigFactoryByName$lzy1"));
    private final Configuration configuration;
    private final ApplicationLifecycle lifecycle;
    private final ExecutionContext executionContext;
    private volatile Object dbconfigFactoryByName$lzy1;
    private volatile Object allDbConfigs$lzy1;

    @Inject
    public DefaultSlickApi(Environment environment, Configuration configuration, ApplicationLifecycle lifecycle, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.lifecycle = lifecycle;
        this.executionContext = executionContext;
    }

    private Map<String, DatabaseConfigFactory> dbconfigFactoryByName() {
        Object object = this.dbconfigFactoryByName$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.dbconfigFactoryByName$lzyINIT1();
    }

    private Object dbconfigFactoryByName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dbconfigFactoryByName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        map = ((Map)this.configs$1().withFilter((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Config config = (Config)tuple2._2();
                                return true;
                            }
                            return false;
                        }).map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                String name = (String)tuple2._1();
                                Config config = (Config)tuple2._2();
                                return Tuple2$.MODULE$.apply((Object)new DbName(DbName$.MODULE$.apply(name)), (Object)new DatabaseConfigFactory(name, config, this.lifecycle, this.executionContext));
                            }
                            throw new MatchError((Object)tuple2);
                        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dbconfigFactoryByName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private List<Tuple2<String, DatabaseConfig<BasicProfile>>> allDbConfigs() {
        Object object = this.allDbConfigs$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.allDbConfigs$lzyINIT1();
    }

    private Object allDbConfigs$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.allDbConfigs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = this.dbconfigFactoryByName().map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                String name = tuple2._1() == null ? null : ((DbName)tuple2._1()).value();
                                DatabaseConfigFactory factory = (DatabaseConfigFactory)tuple2._2();
                                return Tuple2$.MODULE$.apply((Object)new DbName(name), factory.get());
                            }
                            throw new MatchError((Object)tuple2);
                        }).toList();
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.allDbConfigs$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public <P extends BasicProfile> Seq<Tuple2<String, DatabaseConfig<P>>> dbConfigs() {
        return this.allDbConfigs();
    }

    @Override
    public <P extends BasicProfile> DatabaseConfig<P> dbConfig(String name) {
        DatabaseConfigFactory factory = (DatabaseConfigFactory)this.dbconfigFactoryByName().getOrElse((Object)new DbName(name), () -> DefaultSlickApi.$anonfun$1(name));
        DatabaseConfig<BasicProfile> dbConf = factory.get();
        return dbConf;
    }

    private final Map configs$1() {
        String slickDbKey;
        Config config = this.configuration.underlying();
        if (config.hasPath(slickDbKey = config.getString("play.slick.db.config"))) {
            Configuration playConfig = Configuration$.MODULE$.apply(config);
            return (Map)playConfig.get(slickDbKey, ConfigLoader$.MODULE$.mapLoader(ConfigLoader$.MODULE$.configLoader()));
        }
        return Predef$.MODULE$.Map().empty();
    }

    private static final DatabaseConfigFactory $anonfun$1(String name$1) {
        throw new PlayException("No database configuration found for ", name$1);
    }

    public static class DatabaseConfigFactory {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DatabaseConfigFactory.class.getDeclaredField("get$lzy1"));
        private final String name;
        private final Config config;
        private final ApplicationLifecycle lifecycle;
        private final ExecutionContext executionContext;
        private volatile Object get$lzy1;

        public DatabaseConfigFactory(String name, Config config, ApplicationLifecycle lifecycle, ExecutionContext executionContext) {
            this.name = name;
            this.config = config;
            this.lifecycle = lifecycle;
            this.executionContext = executionContext;
        }

        public DatabaseConfig<BasicProfile> get() throws PlayException {
            Object object = this.get$lzy1;
            if (object instanceof DatabaseConfig) {
                return (DatabaseConfig)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (DatabaseConfig)this.get$lzyINIT1();
        }

        private Object get$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        DatabaseConfig<BasicProfile> databaseConfig = null;
                        DatabaseConfig<BasicProfile> databaseConfig2 = null;
                        try {
                            DatabaseConfig<BasicProfile> dbConf = this.create();
                            DefaultSlickApi$DatabaseConfigFactory$.play$api$db$slick$DefaultSlickApi$DatabaseConfigFactory$$$logger.debug(this::get$lzyINIT1$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
                            this.registerDatabaseShutdownHook(dbConf);
                            databaseConfig2 = dbConf;
                            databaseConfig = databaseConfig2 == null ? LazyVals.NullValue$.MODULE$ : databaseConfig2;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, databaseConfig)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, databaseConfig);
                                waiting.countDown();
                            }
                        }
                        return databaseConfig2;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        private DatabaseConfig<BasicProfile> create() throws PlayException {
            DatabaseConfig databaseConfig;
            try {
                databaseConfig = DatabaseConfig$.MODULE$.forConfig("", this.config, DatabaseConfig$.MODULE$.forConfig$default$3(), ClassTag$.MODULE$.apply(BasicProfile.class));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    DefaultSlickApi$DatabaseConfigFactory$.play$api$db$slick$DefaultSlickApi$DatabaseConfigFactory$$$logger.error(this::create$$anonfun$1, () -> this.create$$anonfun$2(t), MarkerContext$.MODULE$.NoMarker());
                    throw Configuration$.MODULE$.apply(this.config).reportError(this.name, new StringBuilder(29).append("Cannot connect to database [").append(this.name).append("]").toString(), (Option)Some$.MODULE$.apply((Object)t));
                }
                throw throwable;
            }
            return databaseConfig;
        }

        private void registerDatabaseShutdownHook(DatabaseConfig<?> dbConf) {
            this.lifecycle.addStopHook((Function0 & Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable)() -> {
                this.registerDatabaseShutdownHook$$anonfun$1$$anonfun$1(dbConf);
                return BoxedUnit.UNIT;
            }, this.executionContext));
        }

        private final String get$lzyINIT1$$anonfun$1() {
            return new StringBuilder(39).append("Created Slick database config for key ").append(this.name).append(".").toString();
        }

        private final String create$$anonfun$1() {
            return new StringBuilder(48).append("Failed to create Slick database config for key ").append(this.name).append(".").toString();
        }

        private final Throwable create$$anonfun$2(Throwable t$1) {
            return t$1;
        }

        private final void registerDatabaseShutdownHook$$anonfun$1$$anonfun$1$$anonfun$1(DatabaseConfig dbConf$3) {
            dbConf$3.db().close();
        }

        private final String registerDatabaseShutdownHook$$anonfun$1$$anonfun$1$$anonfun$2() {
            return new StringBuilder(34).append("Database ").append(this.name).append(" was successfully closed.").toString();
        }

        private final String registerDatabaseShutdownHook$$anonfun$1$$anonfun$1$$anonfun$3() {
            return new StringBuilder(39).append("Error occurred while closing database ").append(this.name).append(".").toString();
        }

        private final Throwable registerDatabaseShutdownHook$$anonfun$1$$anonfun$1$$anonfun$4(Throwable t$2) {
            return t$2;
        }

        private final void registerDatabaseShutdownHook$$anonfun$1$$anonfun$1(DatabaseConfig dbConf$2) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.registerDatabaseShutdownHook$$anonfun$1$$anonfun$1$$anonfun$1(dbConf$2);
                return BoxedUnit.UNIT;
            });
            if (try_ instanceof Success) {
                DefaultSlickApi$DatabaseConfigFactory$.play$api$db$slick$DefaultSlickApi$DatabaseConfigFactory$$$logger.debug(this::registerDatabaseShutdownHook$$anonfun$1$$anonfun$1$$anonfun$2, MarkerContext$.MODULE$.NoMarker());
                return;
            }
            if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                DefaultSlickApi$DatabaseConfigFactory$.play$api$db$slick$DefaultSlickApi$DatabaseConfigFactory$$$logger.warn(this::registerDatabaseShutdownHook$$anonfun$1$$anonfun$1$$anonfun$3, () -> this.registerDatabaseShutdownHook$$anonfun$1$$anonfun$1$$anonfun$4(t), MarkerContext$.MODULE$.NoMarker());
                return;
            }
            throw new MatchError((Object)try_);
        }
    }
}

