/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.PlayException;
import play.api.UnexpectedException;
import play.api.UnexpectedException$;
import play.api.UsefulException;
import play.api.http.HttpErrorHandlerExceptions$;
import play.core.SourceMapper;
import play.utils.PlayIO$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Map;
import scala.io.Codec$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class HttpErrorHandlerExceptions$ {
    public static final HttpErrorHandlerExceptions$ MODULE$ = new HttpErrorHandlerExceptions$();
    private static Map<String, PartialFunction<Throwable, Throwable>> handlers;
    private static final Logger logger;
    private static volatile boolean bitmap$0;

    static {
        logger = Logger$.MODULE$.apply(MODULE$.getClass());
    }

    private Logger logger() {
        return logger;
    }

    private Map<String, PartialFunction<Throwable, Throwable>> handlers$lzycompute() {
        HttpErrorHandlerExceptions$ httpErrorHandlerExceptions$ = this;
        synchronized (httpErrorHandlerExceptions$) {
            if (!bitmap$0) {
                handlers = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Collections.synchronizedMap(new LinkedHashMap())).asScala();
                bitmap$0 = true;
            }
        }
        return handlers;
    }

    public Map<String, PartialFunction<Throwable, Throwable>> handlers() {
        if (!bitmap$0) {
            return this.handlers$lzycompute();
        }
        return handlers;
    }

    public Option<PartialFunction<Throwable, Throwable>> registerHandler(String name, PartialFunction<Throwable, Throwable> handler) {
        this.logger().info((Function0<String>)(Function0 & Serializable)() -> "Registering exception handler: " + name, MarkerContext$.MODULE$.NoMarker());
        return this.handlers().put((Object)name, handler);
    }

    public UsefulException throwableToUsefulException(Option<SourceMapper> sourceMapper, boolean isProd, Throwable throwable) {
        Throwable throwable2;
        while (true) {
            if ((throwable2 = throwable) instanceof UsefulException) {
                UsefulException usefulException = (UsefulException)throwable2;
                return usefulException;
            }
            if (!(throwable2 instanceof ExecutionException)) break;
            ExecutionException executionException = (ExecutionException)throwable2;
            throwable = executionException.getCause();
        }
        if (isProd) {
            Some x$1 = new Some((Object)throwable2);
            Option<String> x$2 = UnexpectedException$.MODULE$.apply$default$1();
            return new UnexpectedException(x$2, (Option<Throwable>)x$1);
        }
        Throwable throwable3 = (Throwable)this.handlers().foldLeft((Object)throwable2, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Throwable e = (Throwable)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    PartialFunction handler = (PartialFunction)tuple22._2();
                    return (Throwable)handler.applyOrElse((Object)e, (Function1 & Serializable)x -> (Throwable)Predef$.MODULE$.identity(x));
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (throwable3 instanceof UsefulException) {
            UsefulException usefulException = (UsefulException)throwable3;
            return usefulException;
        }
        return this.convertToPlayException(sourceMapper, throwable3);
    }

    private UsefulException convertToPlayException(Option<SourceMapper> sourceMapper, Throwable throwable) {
        String desc = "[" + throwable.getClass().getSimpleName() + ": " + throwable.getMessage() + "]";
        return (UsefulException)sourceMapper.flatMap((Function1 & Serializable)x$2 -> x$2.sourceFor(throwable)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                File file = (File)tuple2._1();
                Option lineOpt = (Option)tuple2._2();
                return new PlayException.ExceptionSource(desc, throwable, lineOpt, file){
                    private final Option lineOpt$1;
                    private final File file$1;

                    public Integer line() {
                        return (Integer)this.lineOpt$1.map((Function1 & Serializable)x$3 -> anon.1.$anonfun$line$1(BoxesRunTime.unboxToInt((Object)x$3))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    }

                    public Integer position() {
                        return null;
                    }

                    public String input() {
                        return PlayIO$.MODULE$.readFileAsString(this.file$1.toPath(), Codec$.MODULE$.fallbackSystemCodec());
                    }

                    public String sourceName() {
                        return this.file$1.getAbsolutePath();
                    }

                    public static final /* synthetic */ Integer $anonfun$line$1(int x$3) {
                        return BoxesRunTime.boxToInteger((int)x$3);
                    }
                    {
                        this.lineOpt$1 = lineOpt$1;
                        this.file$1 = file$1;
                        super("Execution exception", desc$1, throwable$1);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$line$1$adapted(java.lang.Object )}, serializedLambda);
                    }
                };
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse((Function0 & Serializable)() -> new PlayException("Execution exception", desc, throwable));
    }

    private HttpErrorHandlerExceptions$() {
    }
}

