/*
 * Decompiled with CFR 0.152.
 */
package play.http;

import java.util.LinkedHashMap;
import java.util.concurrent.CompletionStage;
import play.api.http.MediaRange;
import play.http.HttpErrorHandler;
import play.libs.Scala;
import play.mvc.Http;
import play.mvc.Result;

public class PreferredMediaTypeHttpErrorHandler
implements HttpErrorHandler {
    private LinkedHashMap<String, HttpErrorHandler> errorHandlerMap;

    public PreferredMediaTypeHttpErrorHandler(LinkedHashMap<String, HttpErrorHandler> linkedHashMap) {
        if (linkedHashMap.isEmpty()) {
            throw new IllegalArgumentException("Map must not be empty!");
        }
        this.errorHandlerMap = new LinkedHashMap<String, HttpErrorHandler>(linkedHashMap);
    }

    protected HttpErrorHandler preferred(Http.RequestHeader requestHeader) {
        String string = Scala.orNull(MediaRange.preferred(Scala.toSeq(requestHeader.acceptedTypes()), Scala.toSeq(this.errorHandlerMap.keySet().toArray(new String[0]))));
        if (string == null) {
            return this.errorHandlerMap.values().iterator().next();
        }
        return this.errorHandlerMap.get(string);
    }

    @Override
    public CompletionStage<Result> onClientError(Http.RequestHeader requestHeader, int n, String string) {
        return this.preferred(requestHeader).onClientError(requestHeader, n, string);
    }

    @Override
    public CompletionStage<Result> onServerError(Http.RequestHeader requestHeader, Throwable throwable) {
        return this.preferred(requestHeader).onServerError(requestHeader, throwable);
    }
}

