/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.Serializable;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.ContentTypeOf$;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.HttpErrorConfig;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.mvc.Codec$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.api.routing.Router;
import play.core.SourceMapper;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import views.html.defaultpages.badRequest$;
import views.html.defaultpages.devError$;
import views.html.defaultpages.devNotFound$;
import views.html.defaultpages.error$;
import views.html.defaultpages.notFound$;
import views.html.defaultpages.unauthorized$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001B\u000f\u001f\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!Aa\b\u0001B\u0001J\u0003%q\bC\u0003J\u0001\u0011\u0005!\nC\u0004P\u0001\t\u0007I\u0011\u0002)\t\rU\u0003\u0001\u0015!\u0003R\u0011\u0015I\u0005\u0001\"\u0001W\u0011\u0015I\u0005\u0001\"\u0001d\u0011\u001d9\b\u00011A\u0005\naD\u0011\"a\u0003\u0001\u0001\u0004%I!!\u0004\t\u000f\u0005e\u0001\u0001)Q\u0005s\"9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003/\u0002A\u0011CA-\u0011\u001d\ty\u0006\u0001C\t\u0003CBq!a\u001a\u0001\t#\tI\u0007C\u0004\u0002p\u0001!\t\"!\u001d\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|!9\u0011Q\u0013\u0001\u0005\u0012\u0005]\u0005bBAO\u0001\u0011E\u0011q\u0014\u0005\b\u0003[\u0003A\u0011CAX\u0011\u001d\t)\f\u0001C\t\u0003o;q!!2\u001f\u0011\u0003\t9M\u0002\u0004\u001e=!\u0005\u0011\u0011\u001a\u0005\u0007\u0013b!\t!a3\t\u0013\u00055\u0007$%A\u0005\u0002\u0005=\u0007\"CAs1E\u0005I\u0011AAt\u0011%\tY\u000fGI\u0001\n\u0003\tiOA\fEK\u001a\fW\u000f\u001c;IiR\u0004XI\u001d:pe\"\u000bg\u000e\u001a7fe*\u0011q\u0004I\u0001\u0005QR$\bO\u0003\u0002\"E\u0005\u0019\u0011\r]5\u000b\u0003\r\nA\u0001\u001d7bs\u000e\u00011c\u0001\u0001'YA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\u0004\"!\f\u0018\u000e\u0003yI!a\f\u0010\u0003!!#H\u000f]#se>\u0014\b*\u00198eY\u0016\u0014\u0018AB2p]\u001aLw\r\u0005\u0002.e%\u00111G\b\u0002\u0010\u0011R$\b/\u0012:s_J\u001cuN\u001c4jO\u0006a1o\\;sG\u0016l\u0015\r\u001d9feB\u0019qE\u000e\u001d\n\u0005]B#AB(qi&|g\u000e\u0005\u0002:y5\t!H\u0003\u0002<E\u0005!1m\u001c:f\u0013\ti$H\u0001\u0007T_V\u00148-Z'baB,'/\u0001\u0004s_V$XM\u001d\t\u0004O\u0001\u0013\u0015BA!)\u0005!a$-\u001f8b[\u0016t\u0004cA\u00147\u0007B\u0011AiR\u0007\u0002\u000b*\u0011a\tI\u0001\be>,H/\u001b8h\u0013\tAUI\u0001\u0004S_V$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t-cUJ\u0014\t\u0003[\u0001Aq\u0001\r\u0003\u0011\u0002\u0003\u0007\u0011\u0007C\u00045\tA\u0005\t\u0019A\u001b\t\u000fy\"\u0001\u0013\"a\u0001\u007f\u00051An\\4hKJ,\u0012!\u0015\t\u0003%Nk\u0011\u0001I\u0005\u0003)\u0002\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000f\t\u000b\u0006\u0017^c\u0016M\u0019\u0005\u00061\u001e\u0001\r!W\u0001\fK:4\u0018N]8o[\u0016tG\u000f\u0005\u0002S5&\u00111\f\t\u0002\f\u000b:4\u0018N]8o[\u0016tG\u000fC\u0003^\u000f\u0001\u0007a,A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003%~K!\u0001\u0019\u0011\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015!t\u00011\u00016\u0011\u0019qt\u0001\"a\u0001\u007fQ)1\nZ3gU\")\u0001\f\u0003a\u00013\")Q\f\u0003a\u0001=\")A\u0007\u0003a\u0001OB\u0011!\u000b[\u0005\u0003S\u0002\u0012Ac\u00149uS>t\u0017\r\\*pkJ\u001cW-T1qa\u0016\u0014\b\"\u0002 \t\u0001\u0004Y\u0007c\u00017r\u00076\tQN\u0003\u0002o_\u00061\u0011N\u001c6fGRT\u0011\u0001]\u0001\bU\u0006\\\u0017M\u001d;b\u0013\t\u0011XN\u0001\u0005Qe>4\u0018\u000eZ3sQ\tAA\u000f\u0005\u0002mk&\u0011a/\u001c\u0002\u0007\u0013:TWm\u0019;\u0002\u0015Ad\u0017-_#eSR|'/F\u0001z!\r9cG\u001f\t\u0004w\u0006\u0015ab\u0001?\u0002\u0002A\u0011Q\u0010K\u0007\u0002}*\u0011q\u0010J\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r\u0001&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\tIA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007A\u0013A\u00049mCf,E-\u001b;pe~#S-\u001d\u000b\u0005\u0003\u001f\t)\u0002E\u0002(\u0003#I1!a\u0005)\u0005\u0011)f.\u001b;\t\u0011\u0005]!\"!AA\u0002e\f1\u0001\u001f\u00132\u0003-\u0001H.Y=FI&$xN\u001d\u0011\u0002\u001bM,G\u000f\u00157bs\u0016#\u0017\u000e^8s)\u0011\ty!a\b\t\r\u0005\u0005B\u00021\u0001{\u0003\u0019)G-\u001b;pe\u0006iqN\\\"mS\u0016tG/\u0012:s_J$\u0002\"a\n\u0002@\u0005%\u00131\u000b\t\u0007\u0003S\ty#a\r\u000e\u0005\u0005-\"bAA\u0017Q\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005E\u00121\u0006\u0002\u0007\rV$XO]3\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f!\u0003\rigoY\u0005\u0005\u0003{\t9D\u0001\u0004SKN,H\u000e\u001e\u0005\b\u0003\u0003j\u0001\u0019AA\"\u0003\u001d\u0011X-];fgR\u0004B!!\u000e\u0002F%!\u0011qIA\u001c\u00055\u0011V-];fgRDU-\u00193fe\"9\u00111J\u0007A\u0002\u00055\u0013AC:uCR,8oQ8eKB\u0019q%a\u0014\n\u0007\u0005E\u0003FA\u0002J]RD\u0001\"!\u0016\u000e!\u0003\u0005\rA_\u0001\b[\u0016\u001c8/Y4f\u00031ygNQ1e%\u0016\fX/Z:u)\u0019\t9#a\u0017\u0002^!9\u0011\u0011\t\bA\u0002\u0005\r\u0003BBA+\u001d\u0001\u0007!0A\u0006p]\u001a{'OY5eI\u0016tGCBA\u0014\u0003G\n)\u0007C\u0004\u0002B=\u0001\r!a\u0011\t\r\u0005Us\u00021\u0001{\u0003)ygNT8u\r>,h\u000e\u001a\u000b\u0007\u0003O\tY'!\u001c\t\u000f\u0005\u0005\u0003\u00031\u0001\u0002D!1\u0011Q\u000b\tA\u0002i\f!c\u001c8Pi\",'o\u00117jK:$XI\u001d:peRA\u0011qEA:\u0003k\n9\bC\u0004\u0002BE\u0001\r!a\u0011\t\u000f\u0005-\u0013\u00031\u0001\u0002N!1\u0011QK\tA\u0002i\fQb\u001c8TKJ4XM]#se>\u0014HCBA\u0014\u0003{\ny\bC\u0004\u0002BI\u0001\r!a\u0011\t\u000f\u0005\u0005%\u00031\u0001\u0002\u0004\u0006IQ\r_2faRLwN\u001c\t\u0005\u0003\u000b\u000byI\u0004\u0003\u0002\b\u0006-ebA?\u0002\n&\t\u0011&C\u0002\u0002\u000e\"\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0012\u0006M%!\u0003+ie><\u0018M\u00197f\u0015\r\ti\tK\u0001\u0012M\u0006$\u0018\r\\#se>\u0014X*Z:tC\u001e,G#\u0002>\u0002\u001a\u0006m\u0005bBA!'\u0001\u0007\u00111\t\u0005\b\u0003\u0003\u001b\u0002\u0019AAB\u00039awnZ*feZ,'/\u0012:s_J$b!a\u0004\u0002\"\u0006\r\u0006bBA!)\u0001\u0007\u00111\t\u0005\b\u0003K#\u0002\u0019AAT\u0003=)8/\u001a4vY\u0016C8-\u001a9uS>t\u0007c\u0001*\u0002*&\u0019\u00111\u0016\u0011\u0003\u001fU\u001bXMZ;m\u000bb\u001cW\r\u001d;j_:\f\u0001c\u001c8EKZ\u001cVM\u001d<fe\u0016\u0013(o\u001c:\u0015\r\u0005\u001d\u0012\u0011WAZ\u0011\u001d\t\t%\u0006a\u0001\u0003\u0007Bq!!!\u0016\u0001\u0004\t9+A\tp]B\u0013x\u000eZ*feZ,'/\u0012:s_J$b!a\n\u0002:\u0006m\u0006bBA!-\u0001\u0007\u00111\t\u0005\b\u0003\u00033\u0002\u0019AATQ\r\u0001\u0011q\u0018\t\u0004Y\u0006\u0005\u0017bAAb[\nI1+\u001b8hY\u0016$xN\\\u0001\u0018\t\u00164\u0017-\u001e7u\u0011R$\b/\u0012:s_JD\u0015M\u001c3mKJ\u0004\"!\f\r\u0014\u0005aYECAAd\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u001b\u0016\u0004c\u0005M7FAAk!\u0011\t9.!9\u000e\u0005\u0005e'\u0002BAn\u0003;\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0007&\u0001\u0006b]:|G/\u0019;j_:LA!a9\u0002Z\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIOK\u00026\u0003'\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAAxU\r\u0011\u00151\u001b")
public class DefaultHttpErrorHandler
implements HttpErrorHandler {
    private final HttpErrorConfig config;
    private final Option<SourceMapper> sourceMapper;
    private final Function0<Option<Router>> router;
    private final Logger logger;
    private Option<String> playEditor;

    public static Option<Router> $lessinit$greater$default$3() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<SourceMapper> $lessinit$greater$default$2() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public static HttpErrorConfig $lessinit$greater$default$1() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public String onClientError$default$3() {
        return HttpErrorHandler.onClientError$default$3$(this);
    }

    private Logger logger() {
        return this.logger;
    }

    private Option<String> playEditor() {
        return this.playEditor;
    }

    private void playEditor_$eq(Option<String> x$1) {
        this.playEditor = x$1;
    }

    public void setPlayEditor(String editor) {
        this.playEditor_$eq((Option<String>)Option$.MODULE$.apply((Object)editor));
    }

    @Override
    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        int n = statusCode;
        if (Status$.MODULE$.BAD_REQUEST() == n) {
            return this.onBadRequest(request, message);
        }
        if (Status$.MODULE$.FORBIDDEN() == n) {
            return this.onForbidden(request, message);
        }
        if (Status$.MODULE$.NOT_FOUND() == n) {
            return this.onNotFound(request, message);
        }
        if (statusCode >= 400 && statusCode < 500) {
            return this.onOtherClientError(request, statusCode, message);
        }
        throw new IllegalArgumentException("onClientError invoked with non client error status code " + statusCode + ": " + message);
    }

    public Future<Result> onBadRequest(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.BadRequest().apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message, request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onForbidden(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Forbidden().apply(unauthorized$.MODULE$.apply(request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onNotFound(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)(this.config.showDevErrors() ? Results$.MODULE$.NotFound().apply(devNotFound$.MODULE$.apply(request.method(), request.uri(), (Option<Router>)((Option)this.router.apply()), request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))) : Results$.MODULE$.NotFound().apply(notFound$.MODULE$.apply(request.method(), request.uri(), request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8())))));
    }

    public Future<Result> onOtherClientError(RequestHeader request, int statusCode, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message, request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    @Override
    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        Object object;
        try {
            UsefulException usefulException = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException(this.sourceMapper, !this.config.showDevErrors(), exception);
            this.logServerError(request, usefulException);
            object = this.config.showDevErrors() ? this.onDevServerError(request, usefulException) : this.onProdServerError(request, usefulException);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logger().error((Function0<String>)(Function0 & Serializable)() -> "Error while handling error", (Function0<Throwable>)(Function0 & Serializable)() -> throwable2, MarkerContext$.MODULE$.NoMarker());
                object = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(this.fatalErrorMessage(request, throwable2), Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8())));
            }
            throw throwable;
        }
        return object;
    }

    public String fatalErrorMessage(RequestHeader request, Throwable exception) {
        return "";
    }

    public void logServerError(RequestHeader request, UsefulException usefulException) {
        this.logger().error((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |\n        |! @%s - Internal server error, for (%s) [%s] ->\n        | "))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{usefulException$1.id, request.method(), request.uri()})), (Function0<Throwable>)(Function0 & Serializable)() -> usefulException, MarkerContext$.MODULE$.NoMarker());
    }

    public Future<Result> onDevServerError(RequestHeader request, UsefulException exception) {
        RequestHeader ir = request;
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(devError$.MODULE$.apply(this.playEditor(), exception, ir), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onProdServerError(RequestHeader request, UsefulException exception) {
        RequestHeader ir = request;
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(error$.MODULE$.apply(exception, ir), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public DefaultHttpErrorHandler(HttpErrorConfig config, Option<SourceMapper> sourceMapper, Function0<Option<Router>> router) {
        this.config = config;
        this.sourceMapper = sourceMapper;
        this.router = router;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.playEditor = config.playEditor();
    }

    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, Option<SourceMapper> sourceMapper, Function0<Option<Router>> router) {
        Mode mode = environment.mode();
        Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
        this(new HttpErrorConfig(mode == null ? prod$ != null : !mode.equals(prod$), (Option<String>)configuration.getOptional("play.editor", ConfigLoader$.MODULE$.stringLoader())), sourceMapper, router);
    }

    @Inject
    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, OptionalSourceMapper sourceMapper, Provider<Router> router) {
        this(environment, configuration, sourceMapper.sourceMapper(), (Function0<Option<Router>>)new Serializable(router){
            private static final long serialVersionUID = 0L;
            private final Provider router$1;

            public final Some<Router> apply() {
                return new Some(this.router$1.get());
            }
            {
                this.router$1 = router$1;
            }
        });
    }
}

