/*
 * Decompiled with CFR 0.152.
 */
package play.api.data.format;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import play.api.data.format.PlayDate$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005Y;a!\u0003\u0006\t\u0002A\u0011bA\u0002\u000b\u000b\u0011\u0003\u0001R\u0003C\u0003\u001d\u0003\u0011\u0005a\u0004C\u0003 \u0003\u0011\u0005\u0001EB\u0003\u0015\u0015\u0001\u0001\"\u0005\u0003\u0005$\t\t\u0005\t\u0015!\u0003%\u0011\u0015aB\u0001\"\u0001/\u0011\u0019\u0001D\u0001)C\u0005c!)A\b\u0002C\u0001{\u0005A\u0001\u000b\\1z\t\u0006$XM\u0003\u0002\f\u0019\u00051am\u001c:nCRT!!\u0004\b\u0002\t\u0011\fG/\u0019\u0006\u0003\u001fA\t1!\u00199j\u0015\u0005\t\u0012\u0001\u00029mCf\u0004\"aE\u0001\u000e\u0003)\u0011\u0001\u0002\u00157bs\u0012\u000bG/Z\n\u0003\u0003Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003I\tQ\u0001]1sg\u0016$2!I$P!\t\u0019Ba\u0005\u0002\u0005-\u0005A\u0011mY2fgN|'\u000f\u0005\u0002&Y5\taE\u0003\u0002(Q\u0005AA/Z7q_J\fGN\u0003\u0002*U\u0005!A/[7f\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0014\u0003!Q+W\u000e]8sC2\f5mY3tg>\u0014HCA\u00110\u0011\u0015\u0019c\u00011\u0001%\u000319W\r^(s\t\u00164\u0017-\u001e7u)\r\u0011TG\u000f\t\u0003/MJ!\u0001\u000e\r\u0003\u0007%sG\u000fC\u00037\u000f\u0001\u0007q'A\u0003gS\u0016dG\r\u0005\u0002&q%\u0011\u0011H\n\u0002\u000e)\u0016l\u0007o\u001c:bY\u001aKW\r\u001c3\t\u000bm:\u0001\u0019\u0001\u001a\u0002\u000f\u0011,g-Y;mi\u0006yAo\u001c.p]\u0016$G)\u0019;f)&lW\r\u0006\u0002?\u0005B\u0011q\bQ\u0007\u0002Q%\u0011\u0011\t\u000b\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\t\u000b\rC\u0001\u0019\u0001#\u0002\ri|g.Z%e!\tyT)\u0003\u0002GQ\t1!l\u001c8f\u0013\u0012DQ\u0001S\u0002A\u0002%\u000bA\u0001^3yiB\u0011!*T\u0007\u0002\u0017*\u0011AJK\u0001\u0005Y\u0006tw-\u0003\u0002O\u0017\na1\t[1s'\u0016\fX/\u001a8dK\")\u0001k\u0001a\u0001#\u0006Iam\u001c:nCR$XM\u001d\t\u0003%Rk\u0011a\u0015\u0006\u0003\u0017!J!!V*\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000f")
public class PlayDate {
    private final TemporalAccessor accessor;

    public static PlayDate parse(CharSequence text, DateTimeFormatter formatter) {
        return PlayDate$.MODULE$.parse(text, formatter);
    }

    private int getOrDefault(TemporalField field, int n) {
        if (this.accessor.isSupported(field)) {
            return this.accessor.get(field);
        }
        return n;
    }

    public ZonedDateTime toZonedDateTime(ZoneId zoneId) {
        int year = this.getOrDefault(ChronoField.YEAR, 1970);
        int month = this.getOrDefault(ChronoField.MONTH_OF_YEAR, 1);
        int day = this.getOrDefault(ChronoField.DAY_OF_MONTH, 1);
        int hour = this.getOrDefault(ChronoField.HOUR_OF_DAY, 0);
        int minute = this.getOrDefault(ChronoField.MINUTE_OF_HOUR, 0);
        int second = this.getOrDefault(ChronoField.SECOND_OF_MINUTE, 0);
        int nano = this.getOrDefault(ChronoField.NANO_OF_SECOND, 0);
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(this.getOrDefault(ChronoField.OFFSET_SECONDS, 0));
        return ZonedDateTime.ofInstant(LocalDateTime.of(year, month, day, hour, minute, second, nano), offset, zoneId);
    }

    public PlayDate(TemporalAccessor accessor) {
        this.accessor = accessor;
    }
}

