/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import play.api.MarkerContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;

public interface LoggerLike {
    public static void $init$(LoggerLike $this) {
    }

    public Logger logger();

    public static Logger underlyingLogger$(LoggerLike $this) {
        return $this.underlyingLogger();
    }

    default public Logger underlyingLogger() {
        return this.logger();
    }

    public static boolean enabled$(LoggerLike $this) {
        return $this.enabled();
    }

    default public boolean enabled() {
        return true;
    }

    public static boolean isTraceEnabled$(LoggerLike $this, MarkerContext mc) {
        return $this.isTraceEnabled(mc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isTraceEnabled(MarkerContext mc) {
        if (!this.enabled()) return false;
        Logger logger = this.logger();
        if (!BoxesRunTime.unboxToBoolean((Object)mc.marker().fold(this::isTraceEnabled$$anonfun$1, (Function1 & Serializable)x$0 -> logger.isTraceEnabled(x$0)))) return false;
        return true;
    }

    public static boolean isDebugEnabled$(LoggerLike $this, MarkerContext mc) {
        return $this.isDebugEnabled(mc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isDebugEnabled(MarkerContext mc) {
        if (!this.enabled()) return false;
        Logger logger = this.logger();
        if (!BoxesRunTime.unboxToBoolean((Object)mc.marker().fold(this::isDebugEnabled$$anonfun$1, (Function1 & Serializable)x$0 -> logger.isDebugEnabled(x$0)))) return false;
        return true;
    }

    public static boolean isInfoEnabled$(LoggerLike $this, MarkerContext mc) {
        return $this.isInfoEnabled(mc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isInfoEnabled(MarkerContext mc) {
        if (!this.enabled()) return false;
        Logger logger = this.logger();
        if (!BoxesRunTime.unboxToBoolean((Object)mc.marker().fold(this::isInfoEnabled$$anonfun$1, (Function1 & Serializable)x$0 -> logger.isInfoEnabled(x$0)))) return false;
        return true;
    }

    public static boolean isWarnEnabled$(LoggerLike $this, MarkerContext mc) {
        return $this.isWarnEnabled(mc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isWarnEnabled(MarkerContext mc) {
        if (!this.enabled()) return false;
        Logger logger = this.logger();
        if (!BoxesRunTime.unboxToBoolean((Object)mc.marker().fold(this::isWarnEnabled$$anonfun$1, (Function1 & Serializable)x$0 -> logger.isWarnEnabled(x$0)))) return false;
        return true;
    }

    public static boolean isErrorEnabled$(LoggerLike $this, MarkerContext mc) {
        return $this.isErrorEnabled(mc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isErrorEnabled(MarkerContext mc) {
        if (!this.enabled()) return false;
        Logger logger = this.logger();
        if (!BoxesRunTime.unboxToBoolean((Object)mc.marker().fold(this::isErrorEnabled$$anonfun$1, (Function1 & Serializable)x$0 -> logger.isErrorEnabled(x$0)))) return false;
        return true;
    }

    public static void trace$(LoggerLike $this, Function0 message, MarkerContext mc) {
        $this.trace((Function0<String>)message, mc);
    }

    default public void trace(Function0<String> message, MarkerContext mc) {
        if (this.isTraceEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().trace((String)message.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().trace(marker, (String)message.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static void trace$(LoggerLike $this, Function0 message, Function0 error2, MarkerContext mc) {
        $this.trace((Function0<String>)message, (Function0<Throwable>)error2, mc);
    }

    default public void trace(Function0<String> message, Function0<Throwable> error2, MarkerContext mc) {
        if (this.isTraceEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().trace((String)message.apply(), (Throwable)error2.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().trace(marker, (String)message.apply(), (Throwable)error2.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static void debug$(LoggerLike $this, Function0 message, MarkerContext mc) {
        $this.debug((Function0<String>)message, mc);
    }

    default public void debug(Function0<String> message, MarkerContext mc) {
        if (this.isDebugEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().debug((String)message.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().debug(marker, (String)message.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static void debug$(LoggerLike $this, Function0 message, Function0 error2, MarkerContext mc) {
        $this.debug((Function0<String>)message, (Function0<Throwable>)error2, mc);
    }

    default public void debug(Function0<String> message, Function0<Throwable> error2, MarkerContext mc) {
        if (this.isDebugEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().debug((String)message.apply(), (Throwable)error2.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().debug(marker, (String)message.apply(), (Throwable)error2.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static void info$(LoggerLike $this, Function0 message, MarkerContext mc) {
        $this.info((Function0<String>)message, mc);
    }

    default public void info(Function0<String> message, MarkerContext mc) {
        if (this.isInfoEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().info((String)message.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().info(marker, (String)message.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static void info$(LoggerLike $this, Function0 message, Function0 error2, MarkerContext mc) {
        $this.info((Function0<String>)message, (Function0<Throwable>)error2, mc);
    }

    default public void info(Function0<String> message, Function0<Throwable> error2, MarkerContext mc) {
        if (this.isInfoEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().info((String)message.apply(), (Throwable)error2.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().info(marker, (String)message.apply(), (Throwable)error2.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static void warn$(LoggerLike $this, Function0 message, MarkerContext mc) {
        $this.warn((Function0<String>)message, mc);
    }

    default public void warn(Function0<String> message, MarkerContext mc) {
        if (this.isWarnEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((String)message.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().warn(marker, (String)message.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static void warn$(LoggerLike $this, Function0 message, Function0 error2, MarkerContext mc) {
        $this.warn((Function0<String>)message, (Function0<Throwable>)error2, mc);
    }

    default public void warn(Function0<String> message, Function0<Throwable> error2, MarkerContext mc) {
        if (this.isWarnEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((String)message.apply(), (Throwable)error2.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().warn(marker, (String)message.apply(), (Throwable)error2.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static void error$(LoggerLike $this, Function0 message, MarkerContext mc) {
        $this.error((Function0<String>)message, mc);
    }

    default public void error(Function0<String> message, MarkerContext mc) {
        if (this.isErrorEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().error((String)message.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().error(marker, (String)message.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    public static void error$(LoggerLike $this, Function0 message, Function0 error2, MarkerContext mc) {
        $this.error((Function0<String>)message, (Function0<Throwable>)error2, mc);
    }

    default public void error(Function0<String> message, Function0<Throwable> error2, MarkerContext mc) {
        if (this.isErrorEnabled(mc)) {
            Option<Marker> option = mc.marker();
            if (None$.MODULE$.equals(option)) {
                this.logger().error((String)message.apply(), (Throwable)error2.apply());
                return;
            }
            if (option instanceof Some) {
                Marker marker = (Marker)((Some)option).value();
                this.logger().error(marker, (String)message.apply(), (Throwable)error2.apply());
                return;
            }
            throw new MatchError(option);
        }
    }

    private boolean isTraceEnabled$$anonfun$1() {
        return this.logger().isTraceEnabled();
    }

    private boolean isDebugEnabled$$anonfun$1() {
        return this.logger().isDebugEnabled();
    }

    private boolean isInfoEnabled$$anonfun$1() {
        return this.logger().isInfoEnabled();
    }

    private boolean isWarnEnabled$$anonfun$1() {
        return this.logger().isWarnEnabled();
    }

    private boolean isErrorEnabled$$anonfun$1() {
        return this.logger().isErrorEnabled();
    }
}

