/*
 * Decompiled with CFR 0.152.
 */
package play.api.data.format;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import play.api.data.format.PlayDate$;

public class PlayDate {
    private final TemporalAccessor accessor;

    public static PlayDate parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        return PlayDate$.MODULE$.parse(charSequence, dateTimeFormatter);
    }

    public PlayDate(TemporalAccessor accessor) {
        this.accessor = accessor;
    }

    private int getOrDefault(TemporalField field, int n) {
        if (this.accessor.isSupported(field)) {
            return this.accessor.get(field);
        }
        return n;
    }

    public ZonedDateTime toZonedDateTime(ZoneId zoneId) {
        int year = this.getOrDefault(ChronoField.YEAR, 1970);
        int month = this.getOrDefault(ChronoField.MONTH_OF_YEAR, 1);
        int day = this.getOrDefault(ChronoField.DAY_OF_MONTH, 1);
        int hour = this.getOrDefault(ChronoField.HOUR_OF_DAY, 0);
        int minute = this.getOrDefault(ChronoField.MINUTE_OF_HOUR, 0);
        int second = this.getOrDefault(ChronoField.SECOND_OF_MINUTE, 0);
        int nano = this.getOrDefault(ChronoField.NANO_OF_SECOND, 0);
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(this.getOrDefault(ChronoField.OFFSET_SECONDS, 0));
        return ZonedDateTime.ofInstant(LocalDateTime.of(year, month, day, hour, minute, second, nano), offset, zoneId);
    }
}

