/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.TreeMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.javadsl.Sink;
import org.apache.pekko.stream.javadsl.Source;
import org.apache.pekko.util.ByteString;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import play.api.http.HttpConfiguration;
import play.api.http.MediaRange;
import play.api.libs.Files;
import play.api.libs.json.JsValue;
import play.api.mvc.Cookie;
import play.api.mvc.Cookie$SameSite$;
import play.api.mvc.Headers$;
import play.api.mvc.MultipartFormData;
import play.api.mvc.request.AssignedCell;
import play.api.mvc.request.Cell;
import play.api.mvc.request.DefaultRequestFactory;
import play.api.mvc.request.RemoteConnection$;
import play.api.mvc.request.RequestAttrKey;
import play.api.mvc.request.RequestFactory;
import play.api.mvc.request.RequestTarget$;
import play.core.formatters.Multipart;
import play.core.j.JavaHelpers$;
import play.core.j.JavaParsers;
import play.i18n.Lang;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Files;
import play.libs.Json;
import play.libs.Scala;
import play.libs.XML;
import play.libs.typedmap.TypedEntry;
import play.libs.typedmap.TypedKey;
import play.libs.typedmap.TypedMap;
import play.mvc.MultipartFormatter;
import play.mvc.Results;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.OptionConverters;

public class Http {

    public static interface HttpVerbs {
        public static final String GET = "GET";
        public static final String POST = "POST";
        public static final String PUT = "PUT";
        public static final String PATCH = "PATCH";
        public static final String DELETE = "DELETE";
        public static final String HEAD = "HEAD";
        public static final String OPTIONS = "OPTIONS";
    }

    public static interface MimeTypes {
        public static final String TEXT = "text/plain";
        public static final String HTML = "text/html";
        public static final String JSON = "application/json";
        public static final String XML = "application/xml";
        public static final String XHTML = "application/xhtml+xml";
        public static final String CSS = "text/css";
        public static final String JAVASCRIPT = "application/javascript";
        public static final String FORM = "application/x-www-form-urlencoded";
        public static final String EVENT_STREAM = "text/event-stream";
        public static final String BINARY = "application/octet-stream";
    }

    public static interface Status {
        public static final int CONTINUE = 100;
        public static final int SWITCHING_PROTOCOLS = 101;
        public static final int OK = 200;
        public static final int CREATED = 201;
        public static final int ACCEPTED = 202;
        public static final int NON_AUTHORITATIVE_INFORMATION = 203;
        public static final int NO_CONTENT = 204;
        public static final int RESET_CONTENT = 205;
        public static final int PARTIAL_CONTENT = 206;
        public static final int MULTI_STATUS = 207;
        public static final int MULTIPLE_CHOICES = 300;
        public static final int MOVED_PERMANENTLY = 301;
        public static final int FOUND = 302;
        public static final int SEE_OTHER = 303;
        public static final int NOT_MODIFIED = 304;
        public static final int USE_PROXY = 305;
        public static final int TEMPORARY_REDIRECT = 307;
        public static final int PERMANENT_REDIRECT = 308;
        public static final int BAD_REQUEST = 400;
        public static final int UNAUTHORIZED = 401;
        public static final int PAYMENT_REQUIRED = 402;
        public static final int FORBIDDEN = 403;
        public static final int NOT_FOUND = 404;
        public static final int METHOD_NOT_ALLOWED = 405;
        public static final int NOT_ACCEPTABLE = 406;
        public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
        public static final int REQUEST_TIMEOUT = 408;
        public static final int CONFLICT = 409;
        public static final int GONE = 410;
        public static final int LENGTH_REQUIRED = 411;
        public static final int PRECONDITION_FAILED = 412;
        public static final int REQUEST_ENTITY_TOO_LARGE = 413;
        public static final int REQUEST_URI_TOO_LONG = 414;
        public static final int UNSUPPORTED_MEDIA_TYPE = 415;
        public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
        public static final int EXPECTATION_FAILED = 417;
        public static final int IM_A_TEAPOT = 418;
        public static final int UNPROCESSABLE_ENTITY = 422;
        public static final int LOCKED = 423;
        public static final int FAILED_DEPENDENCY = 424;
        public static final int UPGRADE_REQUIRED = 426;
        public static final int PRECONDITION_REQUIRED = 428;
        public static final int TOO_MANY_REQUESTS = 429;
        public static final int REQUEST_HEADER_FIELDS_TOO_LARGE = 431;
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int NOT_IMPLEMENTED = 501;
        public static final int BAD_GATEWAY = 502;
        public static final int SERVICE_UNAVAILABLE = 503;
        public static final int GATEWAY_TIMEOUT = 504;
        public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
        public static final int INSUFFICIENT_STORAGE = 507;
        public static final int NETWORK_AUTHENTICATION_REQUIRED = 511;
    }

    public static interface HeaderNames {
        public static final String ACCEPT = "Accept";
        public static final String ACCEPT_CHARSET = "Accept-Charset";
        public static final String ACCEPT_ENCODING = "Accept-Encoding";
        public static final String ACCEPT_LANGUAGE = "Accept-Language";
        public static final String ACCEPT_RANGES = "Accept-Ranges";
        public static final String AGE = "Age";
        public static final String ALLOW = "Allow";
        public static final String AUTHORIZATION = "Authorization";
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CONNECTION = "Connection";
        public static final String CONTENT_DISPOSITION = "Content-Disposition";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_LOCATION = "Content-Location";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String COOKIE = "Cookie";
        public static final String DATE = "Date";
        public static final String ETAG = "ETag";
        public static final String EXPECT = "Expect";
        public static final String EXPIRES = "Expires";
        public static final String FORWARDED = "Forwarded";
        public static final String FROM = "From";
        public static final String HOST = "Host";
        public static final String IF_MATCH = "If-Match";
        public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
        public static final String IF_NONE_MATCH = "If-None-Match";
        public static final String IF_RANGE = "If-Range";
        public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
        public static final String LAST_MODIFIED = "Last-Modified";
        public static final String LINK = "Link";
        public static final String LOCATION = "Location";
        public static final String MAX_FORWARDS = "Max-Forwards";
        public static final String PRAGMA = "Pragma";
        public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
        public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
        public static final String RANGE = "Range";
        public static final String REFERER = "Referer";
        public static final String RETRY_AFTER = "Retry-After";
        public static final String SERVER = "Server";
        public static final String SET_COOKIE = "Set-Cookie";
        public static final String SET_COOKIE2 = "Set-Cookie2";
        public static final String TE = "Te";
        public static final String TRAILER = "Trailer";
        public static final String TRANSFER_ENCODING = "Transfer-Encoding";
        public static final String UPGRADE = "Upgrade";
        public static final String USER_AGENT = "User-Agent";
        public static final String VARY = "Vary";
        public static final String VIA = "Via";
        public static final String WARNING = "Warning";
        public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
        public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
        public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
        public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
        public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
        public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
        public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
        public static final String ORIGIN = "Origin";
        public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
        public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
        public static final String X_FORWARDED_FOR = "X-Forwarded-For";
        public static final String X_FORWARDED_HOST = "X-Forwarded-Host";
        public static final String X_FORWARDED_PORT = "X-Forwarded-Port";
        public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
        public static final String X_REQUESTED_WITH = "X-Requested-With";
        public static final String STRICT_TRANSPORT_SECURITY = "Strict-Transport-Security";
        public static final String X_FRAME_OPTIONS = "X-Frame-Options";
        public static final String X_XSS_PROTECTION = "X-XSS-Protection";
        public static final String X_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options";
        public static final String X_PERMITTED_CROSS_DOMAIN_POLICIES = "X-Permitted-Cross-Domain-Policies";
        public static final String CONTENT_SECURITY_POLICY = "Content-Security-Policy";
        public static final String CONTENT_SECURITY_POLICY_REPORT_ONLY = "Content-Security-Policy-Report-Only";
        public static final String X_CONTENT_SECURITY_POLICY_NONCE_HEADER = "X-Content-Security-Policy-Nonce";
        public static final String REFERRER_POLICY = "Referrer-Policy";
    }

    public static interface Cookies
    extends java.lang.Iterable<Cookie> {
        public Optional<Cookie> get(String var1);

        @Deprecated
        default public Optional<Cookie> getCookie(String string) {
            return this.get(string);
        }
    }

    public static class CookieBuilder {
        private String name;
        private String value;
        private Integer maxAge;
        private String path = "/";
        private String domain;
        private boolean secure = false;
        private boolean httpOnly = true;
        private Cookie.SameSite sameSite;

        private CookieBuilder(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public CookieBuilder withName(String string) {
            this.name = string;
            return this;
        }

        public CookieBuilder withValue(String string) {
            this.value = string;
            return this;
        }

        public CookieBuilder withMaxAge(Duration duration) {
            this.maxAge = (int)duration.getSeconds();
            return this;
        }

        public CookieBuilder withPath(String string) {
            this.path = string;
            return this;
        }

        public CookieBuilder withDomain(String string) {
            this.domain = string;
            return this;
        }

        public CookieBuilder withSecure(boolean bl) {
            this.secure = bl;
            return this;
        }

        public CookieBuilder withHttpOnly(boolean bl) {
            this.httpOnly = bl;
            return this;
        }

        public CookieBuilder withSameSite(Cookie.SameSite sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.maxAge, this.path, this.domain, this.secure, this.httpOnly, this.sameSite);
        }
    }

    public static class Cookie {
        private final String name;
        private final String value;
        private final Integer maxAge;
        private final String path;
        private final String domain;
        private final boolean secure;
        private final boolean httpOnly;
        private final SameSite sameSite;

        public Cookie(String string, String string2, Integer n, String string3, String string4, boolean bl, boolean bl2, SameSite sameSite) {
            this.name = string;
            this.value = string2;
            this.maxAge = n;
            this.path = string3;
            this.domain = string4;
            this.secure = bl;
            this.httpOnly = bl2;
            this.sameSite = sameSite;
        }

        public static CookieBuilder builder(String string, String string2) {
            return new CookieBuilder(string, string2);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public Integer maxAge() {
            return this.maxAge;
        }

        public String path() {
            return this.path;
        }

        public String domain() {
            return this.domain;
        }

        public boolean secure() {
            return this.secure;
        }

        public boolean httpOnly() {
            return this.httpOnly;
        }

        public Optional<SameSite> sameSite() {
            return Optional.ofNullable(this.sameSite);
        }

        public play.api.mvc.Cookie asScala() {
            OptionalInt optionalInt = this.maxAge == null ? OptionalInt.empty() : OptionalInt.of(this.maxAge);
            Optional<String> optional = Optional.ofNullable(this.domain());
            Optional<Cookie.SameSite> optional2 = this.sameSite().map(SameSite::asScala);
            return new play.api.mvc.Cookie(this.name(), this.value(), (Option<Object>)OptionConverters.toScala((OptionalInt)optionalInt).map(n -> n), this.path(), (Option<String>)OptionConverters.toScala(optional), this.secure(), this.httpOnly(), (Option<Cookie.SameSite>)OptionConverters.toScala(optional2));
        }

        public static enum SameSite {
            STRICT("Strict"),
            LAX("Lax"),
            NONE("None");

            private final String value;

            private SameSite(String string2) {
                this.value = string2;
            }

            public String value() {
                return this.value;
            }

            public Cookie.SameSite asScala() {
                return (Cookie.SameSite)Cookie$SameSite$.MODULE$.parse(this.value).get();
            }

            public static Optional<SameSite> parse(String string) {
                for (SameSite sameSite : SameSite.values()) {
                    if (!sameSite.value.equalsIgnoreCase(string)) continue;
                    return Optional.of(sameSite);
                }
                return Optional.empty();
            }
        }
    }

    public static class Flash {
        private final play.api.mvc.Flash underlying;

        public Flash() {
            this.underlying = new play.api.mvc.Flash(Scala.asScala(Collections.emptyMap()));
        }

        public Flash(Map<String, String> map) {
            this.underlying = new play.api.mvc.Flash(Scala.asScala(map));
        }

        public Flash(play.api.mvc.Flash flash) {
            this.underlying = flash;
        }

        public Map<String, String> data() {
            return Scala.asJava(this.underlying.data());
        }

        public Optional<String> get(String string) {
            return OptionConverters.toJava(this.underlying.get(string));
        }

        @Deprecated
        public Optional<String> getOptional(String string) {
            return this.get(string);
        }

        @Deprecated
        public Optional<String> apply(String string) {
            return this.get(string);
        }

        public Flash removing(String ... stringArray) {
            return this.underlying.$minus$minus((Iterable<String>)Scala.varargs(stringArray)).asJava();
        }

        public Flash adding(String string, String string2) {
            return this.underlying.$plus(Scala.Tuple(string, string2)).asJava();
        }

        public Flash adding(Map<String, String> map) {
            return this.underlying.$plus$plus((Iterable<Tuple2<String, String>>)Scala.asScala(map)).asJava();
        }

        public play.api.mvc.Flash asScala() {
            return this.underlying;
        }
    }

    public static class Session {
        private final play.api.mvc.Session underlying;

        public Session() {
            this.underlying = new play.api.mvc.Session(Scala.asScala(Collections.emptyMap()));
        }

        public Session(Map<String, String> map) {
            this.underlying = new play.api.mvc.Session(Scala.asScala(map));
        }

        public Session(play.api.mvc.Session session) {
            this.underlying = session;
        }

        public Map<String, String> data() {
            return Scala.asJava(this.underlying.data());
        }

        public Optional<String> get(String string) {
            return OptionConverters.toJava(this.underlying.get(string));
        }

        @Deprecated
        public Optional<String> getOptional(String string) {
            return this.get(string);
        }

        @Deprecated
        public Optional<String> apply(String string) {
            return this.get(string);
        }

        public Session removing(String ... stringArray) {
            return this.underlying.$minus$minus((Iterable<String>)Scala.varargs(stringArray)).asJava();
        }

        public Session adding(String string, String string2) {
            return this.underlying.$plus(Scala.Tuple(string, string2)).asJava();
        }

        public Session adding(Map<String, String> map) {
            return this.underlying.$plus$plus((Iterable<Tuple2<String, String>>)Scala.asScala(map)).asJava();
        }

        public play.api.mvc.Session asScala() {
            return this.underlying;
        }
    }

    public static final class RequestBody {
        private final Object body;

        public RequestBody(Object object) {
            this.body = object;
        }

        public <A> MultipartFormData<A> asMultipartFormData() {
            return this.as(MultipartFormData.class);
        }

        public Map<String, String[]> asFormUrlEncoded() {
            if (this.body instanceof Map) {
                if (((Map)this.body).isEmpty()) {
                    return Collections.emptyMap();
                }
                Map.Entry entry = ((Map)this.body).entrySet().iterator().next();
                if (entry.getKey() instanceof String && entry.getValue() instanceof String[]) {
                    Map map = (Map)this.body;
                    return map;
                }
            }
            return null;
        }

        public RawBuffer asRaw() {
            return this.as(RawBuffer.class);
        }

        public String asText() {
            return this.as(String.class);
        }

        public Document asXml() {
            return this.as(Document.class);
        }

        public JsonNode asJson() {
            return this.as(JsonNode.class);
        }

        public <A> Optional<A> parseJson(Class<A> clazz) {
            return this.body instanceof JsonNode ? Optional.of(Json.fromJson(this.asJson(), clazz)) : Optional.empty();
        }

        public ByteString asBytes() {
            if (this.body == null) {
                return ByteString.emptyByteString();
            }
            if (this.body instanceof Optional) {
                if (!((Optional)this.body).isPresent()) {
                    return ByteString.emptyByteString();
                }
            } else {
                if (this.body instanceof ByteString) {
                    return (ByteString)this.body;
                }
                if (this.body instanceof byte[]) {
                    return ByteString.fromArray((byte[])((byte[])this.body));
                }
                if (this.body instanceof String) {
                    return ByteString.fromString((String)((String)this.body));
                }
                if (this.body instanceof RawBuffer) {
                    return ((RawBuffer)this.body).asBytes();
                }
                if (this.body instanceof JsonNode) {
                    return ByteString.fromString((String)Json.stringify((JsonNode)this.body));
                }
                if (this.body instanceof Document) {
                    return XML.toBytes((Document)this.body);
                }
                Map<String, String[]> map = this.asFormUrlEncoded();
                if (map != null) {
                    return ByteString.fromString((String)map.entrySet().stream().flatMap(entry -> {
                        String string = this.encode((String)entry.getKey());
                        return Arrays.stream((String[])entry.getValue()).map(string2 -> string + "=" + this.encode((String)string2));
                    }).collect(Collectors.joining("&")));
                }
            }
            return null;
        }

        private String encode(String string) {
            try {
                return URLEncoder.encode(string, "utf8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }

        public <T> T as(Class<T> clazz) {
            if (clazz.isInstance(this.body)) {
                return clazz.cast(this.body);
            }
            return null;
        }

        public String toString() {
            return "RequestBody of " + String.valueOf(this.body == null ? "null" : this.body.getClass());
        }
    }

    public static abstract class MultipartFormData<A> {
        public abstract Map<String, String[]> asFormUrlEncoded();

        public abstract List<FilePart<A>> getFiles();

        public abstract boolean isEmpty();

        public FilePart<A> getFile(String string) {
            for (FilePart<A> filePart : this.getFiles()) {
                if (!filePart.getKey().equals(string)) continue;
                return filePart;
            }
            return null;
        }

        public static class DataPart
        implements Part<Source<ByteString, ?>> {
            private final String key;
            private final String value;

            public DataPart(String string, String string2) {
                this.key = string;
                this.value = string2;
            }

            public String getKey() {
                return this.key;
            }

            public String getValue() {
                return this.value;
            }
        }

        public static class FilePart<A>
        implements Part<A> {
            final String key;
            final String filename;
            final String contentType;
            final A ref;
            final String dispositionType;
            final long fileSize;
            final Function<A, Optional<ByteString>> refToBytes;

            public FilePart(String string, String string2, String string3, A a) {
                this(string, string2, string3, a, object -> Optional.empty());
            }

            public FilePart(String string, String string2, String string3, A a, Function<A, Optional<ByteString>> function) {
                this(string, string2, string3, a, -1L, function);
            }

            public FilePart(String string, String string2, String string3, A a, long l) {
                this(string, string2, string3, a, l, (A object) -> Optional.empty());
            }

            public FilePart(String string, String string2, String string3, A a, long l, Function<A, Optional<ByteString>> function) {
                this(string, string2, string3, a, l, "form-data", function);
            }

            public FilePart(String string, String string2, String string3, A a, long l, String string4) {
                this(string, string2, string3, a, l, string4, object -> Optional.empty());
            }

            public FilePart(String string, String string2, String string3, A a, long l, String string4, Function<A, Optional<ByteString>> function) {
                this.key = string;
                this.filename = string2;
                this.contentType = string3;
                this.ref = a;
                this.dispositionType = string4;
                this.fileSize = l;
                this.refToBytes = function;
            }

            public String getKey() {
                return this.key;
            }

            public String getFilename() {
                return this.filename;
            }

            public String getContentType() {
                return this.contentType;
            }

            public A getRef() {
                return this.ref;
            }

            public String getDispositionType() {
                return this.dispositionType;
            }

            public long getFileSize() {
                return this.fileSize;
            }

            public ByteString transformRefToBytes() {
                return this.refToBytes.apply(this.ref).or(() -> {
                    try {
                        if (this.ref instanceof Files.TemporaryFile) {
                            return Optional.of(ByteString.fromArray((byte[])Files.readAllBytes(((Files.TemporaryFile)this.ref).path())));
                        }
                        if (this.ref instanceof Files.TemporaryFile) {
                            return Optional.of(ByteString.fromArray((byte[])Files.readAllBytes(((Files.TemporaryFile)this.ref).path())));
                        }
                        if (this.ref instanceof File) {
                            return Optional.of(ByteString.fromArray((byte[])Files.readAllBytes(((File)this.ref).toPath())));
                        }
                        if (this.ref instanceof Path) {
                            return Optional.of(ByteString.fromArray((byte[])Files.readAllBytes((Path)this.ref)));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Can not transform the FilePart ref to bytes", iOException);
                    }
                    return Optional.empty();
                }).orElseThrow(() -> new RuntimeException("To be able to convert this FilePart's ref to bytes you need to define refToBytes of FilePart[" + this.ref.getClass().getName() + "]"));
            }

            public MultipartFormData.FilePart<A> asScala() {
                return new MultipartFormData.FilePart<A>(this.getKey(), this.getFilename(), (Option<String>)Option.apply((Object)this.getContentType()), this.getRef(), this.getFileSize(), this.getDispositionType(), object -> OptionConverters.toScala(this.refToBytes.apply(object)));
            }
        }

        public static interface Part<A> {
        }

        public static class FileInfo {
            private final String key;
            private final String filename;
            private final String contentType;

            public FileInfo(String string, String string2, String string3) {
                this.key = string;
                this.filename = string2;
                this.contentType = string3;
            }

            public String getKey() {
                return this.key;
            }

            public String getFilename() {
                return this.filename;
            }

            public String getContentType() {
                return this.contentType;
            }
        }
    }

    public static abstract class RawBuffer {
        public abstract Long size();

        public abstract ByteString asBytes(int var1);

        public abstract ByteString asBytes();

        public abstract File asFile();
    }

    public static class RequestBuilder {
        protected play.api.mvc.Request<RequestBody> req;

        public RequestBuilder() {
            this(new DefaultRequestFactory(HttpConfiguration.createWithDefaults()));
            this.host("localhost");
        }

        public RequestBuilder(RequestBuilder requestBuilder) {
            this.req = requestBuilder.req;
        }

        public RequestBuilder(RequestFactory requestFactory) {
            this.req = requestFactory.createRequest(RemoteConnection$.MODULE$.apply("127.0.0.1", false, (Option<Seq<X509Certificate>>)OptionConverters.toScala(Optional.empty())), "GET", RequestTarget$.MODULE$.apply("/", "/", (scala.collection.immutable.Map<String, Seq<String>>)Map$.MODULE$.empty()), "HTTP/1.1", Headers$.MODULE$.create(), TypedMap.empty().asScala(), new RequestBody(null));
        }

        public RequestBody body() {
            return this.req.body();
        }

        protected RequestBuilder body(RequestBody requestBody, String string) {
            this.header("Content-Type", string);
            this.body(requestBody);
            return this;
        }

        protected RequestBuilder body(RequestBody requestBody) {
            if (requestBody == null || requestBody.as(Object.class) == null) {
                this.headers(this.headers().removing("Content-Length").removing("Transfer-Encoding"));
            } else if (!this.headers().get("Transfer-Encoding").isPresent()) {
                MultipartFormData multipartFormData = requestBody.asMultipartFormData();
                if (multipartFormData != null) {
                    this.header("Content-Length", Long.toString(this.calcMultipartFormDataBodyLength(multipartFormData)));
                } else {
                    int n = requestBody.asBytes().length();
                    this.header("Content-Length", Integer.toString(n));
                }
            }
            this.req = this.req.withBody(requestBody);
            return this;
        }

        private long calcMultipartFormDataBodyLength(MultipartFormData<?> multipartFormData) {
            long l;
            long l2;
            String string = MultipartFormatter.boundaryToContentType("");
            String string3 = this.headers().get("Content-Type").filter(string2 -> string2.startsWith(string)).map(string2 -> "\r\n--" + string2.substring(string.length())).orElseThrow(() -> new RuntimeException("Content-Type header starting with \"" + string + "\" needs to be present"));
            long l3 = multipartFormData.asFormUrlEncoded().entrySet().stream().mapToLong(entry -> Arrays.stream((String[])entry.getValue()).mapToLong(string2 -> this.partLength(string3, "form-data", (String)entry.getKey() + (((String[])entry.getValue()).length > 1 ? "[]" : ""), null, null, (String)string2)).sum()).sum();
            long l4 = l3 + (l2 = multipartFormData.getFiles().stream().mapToLong(filePart -> this.partLength(string3, filePart.getDispositionType(), filePart.getKey(), filePart.getFilename(), filePart.getContentType(), "")).sum()) + (l = multipartFormData.getFiles().stream().mapToLong(MultipartFormData.FilePart::getFileSize).sum());
            if (l4 > 0L) {
                l4 -= 2L;
                l4 += (long)(string3 + "--").getBytes(StandardCharsets.UTF_8).length;
            }
            return l4;
        }

        private int partLength(String string, String string2, String string3, String string4, String string5, String string6) {
            String string7 = string + "\r\nContent-Disposition: " + string2 + "; name=\"" + Multipart.escapeParamWithHTML5Strategy(string3) + "\"" + (String)(string4 != null ? "; filename=\"" + Multipart.escapeParamWithHTML5Strategy(string4) + "\"" : "") + "\r\n" + (String)(string5 != null ? "Content-Type: " + string5 + "\r\n" : "") + "\r\n" + string6;
            return string7.getBytes(StandardCharsets.UTF_8).length;
        }

        public RequestBuilder bodyRaw(ByteString byteString) {
            Files.TemporaryFileCreator temporaryFileCreator = play.libs.Files.singletonTemporaryFileCreator();
            play.api.mvc.RawBuffer rawBuffer = new play.api.mvc.RawBuffer(byteString.size(), temporaryFileCreator.asScala(), byteString);
            return this.body(new RequestBody(JavaParsers.toJavaRaw(rawBuffer)), "application/octet-stream");
        }

        public RequestBuilder bodyRaw(ByteString byteString, Files.TemporaryFileCreator temporaryFileCreator) {
            play.api.mvc.RawBuffer rawBuffer = new play.api.mvc.RawBuffer(byteString.size(), temporaryFileCreator.asScala(), byteString);
            return this.body(new RequestBody(JavaParsers.toJavaRaw(rawBuffer)), "application/octet-stream");
        }

        public RequestBuilder bodyRaw(byte[] byArray) {
            Files.TemporaryFileCreator temporaryFileCreator = play.libs.Files.singletonTemporaryFileCreator();
            return this.bodyRaw(ByteString.fromArray((byte[])byArray), temporaryFileCreator);
        }

        public RequestBuilder bodyRaw(byte[] byArray, Files.TemporaryFileCreator temporaryFileCreator) {
            return this.bodyRaw(ByteString.fromArray((byte[])byArray), temporaryFileCreator);
        }

        public RequestBuilder bodyFormArrayValues(Map<String, String[]> map) {
            return this.body(new RequestBody(map), "application/x-www-form-urlencoded");
        }

        public RequestBuilder bodyForm(Map<String, String> map) {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), new String[]{entry.getValue()});
            }
            return this.bodyFormArrayValues(hashMap);
        }

        @Deprecated
        public RequestBuilder bodyMultipart(List<MultipartFormData.Part<Source<ByteString, ?>>> list, Files.TemporaryFileCreator temporaryFileCreator, Materializer materializer) {
            return this.bodyRaw(list, temporaryFileCreator, materializer);
        }

        public RequestBuilder bodyRaw(List<MultipartFormData.Part<Source<ByteString, ?>>> list, Files.TemporaryFileCreator temporaryFileCreator, Materializer materializer) {
            String string = MultipartFormatter.randomBoundary();
            try {
                ByteString byteString = (ByteString)((CompletionStage)MultipartFormatter.transform(Source.from(list), string).runWith((Graph)Sink.reduce(ByteString::concat), materializer)).toCompletableFuture().get();
                play.api.mvc.RawBuffer rawBuffer = new play.api.mvc.RawBuffer(byteString.size(), temporaryFileCreator.asScala(), byteString);
                return this.body(new RequestBody(JavaParsers.toJavaRaw(rawBuffer)), MultipartFormatter.boundaryToContentType(string));
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new RuntimeException("Failure while materializing Multipart/Form Data", exception);
            }
        }

        public RequestBuilder bodyMultipart(final Map<String, String[]> map, final List<MultipartFormData.FilePart> list) {
            MultipartFormData multipartFormData = new MultipartFormData(){

                @Override
                public Map<String, String[]> asFormUrlEncoded() {
                    return Collections.unmodifiableMap(map);
                }

                public List<MultipartFormData.FilePart> getFiles() {
                    return Collections.unmodifiableList(list);
                }

                @Override
                public boolean isEmpty() {
                    return map.isEmpty() && list.isEmpty();
                }
            };
            return this.body(new RequestBody(multipartFormData), MultipartFormatter.boundaryToContentType(MultipartFormatter.randomBoundary()));
        }

        public RequestBuilder bodyJson(JsonNode jsonNode) {
            return this.body(new RequestBody(jsonNode), "application/json");
        }

        public RequestBuilder bodyJson(JsValue jsValue) {
            return this.bodyJson(Json.parse(play.api.libs.json.Json.stringify((JsValue)jsValue)));
        }

        public RequestBuilder bodyXml(InputSource inputSource) {
            return this.bodyXml(XML.fromInputSource(inputSource));
        }

        public RequestBuilder bodyXml(Document document) {
            return this.body(new RequestBody(document), "application/xml");
        }

        public RequestBuilder bodyText(String string) {
            return this.body(new RequestBody(string), "text/plain");
        }

        public RequestBuilder bodyText(String string, Charset charset) {
            return this.body(new RequestBody(string), "text/plain; charset=" + charset.name());
        }

        public RequestImpl build() {
            return new RequestImpl(this.req);
        }

        public Long id() {
            return this.req.id();
        }

        public RequestBuilder id(Long l) {
            this.attr(new TypedKey<Object>(RequestAttrKey.Id()), l);
            return this;
        }

        public <T> RequestBuilder attr(TypedKey<T> typedKey, T t) {
            this.req = this.req.addAttr(typedKey.asScala(), t);
            return this;
        }

        public RequestBuilder attrs(TypedMap typedMap) {
            this.req = this.req.withAttrs(typedMap.asScala());
            return this;
        }

        public TypedMap attrs() {
            return new TypedMap(this.req.attrs());
        }

        public String method() {
            return this.req.method();
        }

        public RequestBuilder method(String string) {
            this.req = this.req.withMethod(string);
            return this;
        }

        public String uri() {
            return this.req.uri();
        }

        public RequestBuilder uri(URI uRI) {
            this.req = JavaHelpers$.MODULE$.updateRequestWithUri((play.api.mvc.Request)this.req, uRI);
            return this;
        }

        public RequestBuilder uri(String string) {
            try {
                this.uri(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Exception parsing URI", uRISyntaxException);
            }
            return this;
        }

        public RequestBuilder secure(boolean bl) {
            this.req = this.req.withConnection(RemoteConnection$.MODULE$.apply(this.req.connection().remoteAddress(), bl, this.req.connection().clientCertificateChain()));
            return this;
        }

        public boolean secure() {
            return this.req.connection().secure();
        }

        public String host() {
            return this.headers().get("Host").orElse(null);
        }

        public RequestBuilder host(String string) {
            this.header("Host", string);
            return this;
        }

        public String path() {
            return this.req.target().path();
        }

        public RequestBuilder path(String string) {
            URI uRI;
            URI uRI2 = this.req.target().uri();
            try {
                uRI = new URI(uRI2.getScheme(), uRI2.getUserInfo(), uRI2.getHost(), uRI2.getPort(), string, uRI2.getQuery(), uRI2.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("New path couldn't be parsed", uRISyntaxException);
            }
            this.uri(uRI);
            return this;
        }

        public String version() {
            return this.req.version();
        }

        public RequestBuilder version(String string) {
            this.req = this.req.withVersion(string);
            return this;
        }

        public Headers getHeaders() {
            return this.headers();
        }

        public Headers headers() {
            return this.req.headers().asJava();
        }

        public RequestBuilder headers(Headers headers) {
            this.req = this.req.withHeaders(headers.asScala());
            return this;
        }

        public RequestBuilder header(String string, List<String> list) {
            return this.headers(this.headers().adding(string, list));
        }

        public RequestBuilder header(String string, String string2) {
            return this.headers(this.headers().adding(string, string2));
        }

        public Cookies cookies() {
            return JavaHelpers$.MODULE$.cookiesToJavaCookies(this.req.cookies());
        }

        public RequestBuilder cookie(Cookie cookie) {
            play.api.mvc.Cookies cookies = JavaHelpers$.MODULE$.mergeNewCookie(this.req.cookies(), cookie.asScala());
            this.attr(new TypedKey<Cell<play.api.mvc.Cookies>>(RequestAttrKey.Cookies()), new AssignedCell<play.api.mvc.Cookies>(cookies));
            return this;
        }

        public Map<String, String> flash() {
            return Scala.asJava(this.req.flash().data());
        }

        public RequestBuilder flash(String string, String string2) {
            scala.collection.immutable.Map<String, String> map = this.req.flash().data();
            scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)map.updated((Object)string, (Object)string2);
            play.api.mvc.Flash flash = new play.api.mvc.Flash((scala.collection.immutable.Map<String, String>)map2);
            this.attr(new TypedKey<Cell<play.api.mvc.Flash>>(RequestAttrKey.Flash()), new AssignedCell<play.api.mvc.Flash>(flash));
            return this;
        }

        public RequestBuilder flash(Map<String, String> map) {
            play.api.mvc.Flash flash = new play.api.mvc.Flash(Scala.asScala(map));
            this.attr(new TypedKey<Cell<play.api.mvc.Flash>>(RequestAttrKey.Flash()), new AssignedCell<play.api.mvc.Flash>(flash));
            return this;
        }

        public Map<String, String> session() {
            return Scala.asJava(this.req.session().data());
        }

        public RequestBuilder session(String string, String string2) {
            scala.collection.immutable.Map<String, String> map = this.req.session().data();
            scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)map.updated((Object)string, (Object)string2);
            play.api.mvc.Session session = new play.api.mvc.Session((scala.collection.immutable.Map<String, String>)map2);
            this.attr(new TypedKey<Cell<play.api.mvc.Session>>(RequestAttrKey.Session()), new AssignedCell<play.api.mvc.Session>(session));
            return this;
        }

        public RequestBuilder session(Map<String, String> map) {
            play.api.mvc.Session session = new play.api.mvc.Session(Scala.asScala(map));
            this.attr(new TypedKey<Cell<play.api.mvc.Session>>(RequestAttrKey.Session()), new AssignedCell<play.api.mvc.Session>(session));
            return this;
        }

        public String remoteAddress() {
            return this.req.connection().remoteAddressString();
        }

        public RequestBuilder remoteAddress(String string) {
            this.req = this.req.withConnection(RemoteConnection$.MODULE$.apply(string, this.req.connection().secure(), this.req.connection().clientCertificateChain()));
            return this;
        }

        public Optional<List<X509Certificate>> clientCertificateChain() {
            return OptionConverters.toJava(this.req.connection().clientCertificateChain()).map(seq -> new ArrayList(Scala.asJava(seq)));
        }

        public RequestBuilder clientCertificateChain(List<X509Certificate> list) {
            this.req = this.req.withConnection(RemoteConnection$.MODULE$.apply(this.req.connection().remoteAddress(), this.req.connection().secure(), (Option<Seq<X509Certificate>>)OptionConverters.toScala(Optional.ofNullable(Scala.asScala(list)))));
            return this;
        }

        public RequestBuilder langCookie(Lang lang, MessagesApi messagesApi) {
            return Results.ok().withLang(lang, messagesApi).cookie(messagesApi.langCookieName()).map(this::cookie).orElse(this);
        }

        public RequestBuilder langCookie(Locale locale, MessagesApi messagesApi) {
            return this.langCookie(new Lang(locale), messagesApi);
        }

        public RequestBuilder transientLang(Lang lang) {
            this.req = this.req.withTransientLang(lang);
            return this;
        }

        @Deprecated
        public RequestBuilder transientLang(String string) {
            this.req = this.req.withTransientLang(string);
            return this;
        }

        public RequestBuilder transientLang(Locale locale) {
            this.req = this.req.withTransientLang(locale);
            return this;
        }

        public RequestBuilder withoutTransientLang() {
            this.req = this.req.withoutTransientLang();
            return this;
        }

        Optional<Lang> transientLang() {
            return OptionConverters.toJava(this.req.transientLang()).map(play.api.i18n.Lang::asJava);
        }
    }

    public static class RequestImpl
    extends play.core.j.RequestImpl {
        public RequestImpl(play.api.mvc.Request<RequestBody> request) {
            super(request);
        }
    }

    public static interface Request
    extends RequestHeader {
        public RequestBody body();

        @Override
        public Request withBody(RequestBody var1);

        @Override
        public Request withAttrs(TypedMap var1);

        @Override
        public <A> Request addAttr(TypedKey<A> var1, A var2);

        @Override
        public Request addAttrs(TypedEntry<?> var1);

        @Override
        public Request addAttrs(TypedEntry<?> var1, TypedEntry<?> var2);

        @Override
        public Request addAttrs(TypedEntry<?> var1, TypedEntry<?> var2, TypedEntry<?> var3);

        @Override
        public Request addAttrs(List<TypedEntry<?>> var1);

        @Override
        public Request removeAttr(TypedKey<?> var1);

        @Override
        default public Request withTransientLang(Lang lang) {
            return this.addAttr((TypedKey)Messages.Attrs.CurrentLang, lang);
        }

        @Override
        @Deprecated
        default public Request withTransientLang(String string) {
            return this.addAttr((TypedKey)Messages.Attrs.CurrentLang, Lang.forCode(string));
        }

        @Override
        default public Request withTransientLang(Locale locale) {
            return this.addAttr((TypedKey)Messages.Attrs.CurrentLang, new Lang(locale));
        }

        @Override
        default public Request withoutTransientLang() {
            return this.removeAttr((TypedKey)Messages.Attrs.CurrentLang);
        }

        @Override
        public play.api.mvc.Request<RequestBody> asScala();
    }

    public static interface RequestHeader {
        default public Long id() {
            return (Long)this.attrs().get(RequestAttrKey.Id().asJava());
        }

        public String uri();

        public String method();

        public String version();

        public String remoteAddress();

        public boolean secure();

        public TypedMap attrs();

        public RequestHeader withAttrs(TypedMap var1);

        public <A> RequestHeader addAttr(TypedKey<A> var1, A var2);

        public RequestHeader addAttrs(TypedEntry<?> var1);

        public RequestHeader addAttrs(TypedEntry<?> var1, TypedEntry<?> var2);

        public RequestHeader addAttrs(TypedEntry<?> var1, TypedEntry<?> var2, TypedEntry<?> var3);

        public RequestHeader addAttrs(List<TypedEntry<?>> var1);

        public RequestHeader removeAttr(TypedKey<?> var1);

        public Request withBody(RequestBody var1);

        public String host();

        public String path();

        public List<Lang> acceptLanguages();

        public List<MediaRange> acceptedTypes();

        public boolean accepts(String var1);

        public Map<String, String[]> queryString();

        @Deprecated
        public String getQueryString(String var1);

        public Optional<String> queryString(String var1);

        public Cookies cookies();

        public Optional<Cookie> cookie(String var1);

        @Deprecated
        public Optional<Cookie> getCookie(String var1);

        default public Session session() {
            return this.attrs().getOptional(RequestAttrKey.Session().asJava()).map(cell -> ((play.api.mvc.Session)cell.value()).asJava()).orElseGet(() -> new Session());
        }

        default public Flash flash() {
            return this.attrs().getOptional(RequestAttrKey.Flash().asJava()).map(cell -> ((play.api.mvc.Flash)cell.value()).asJava()).orElseGet(() -> new Flash());
        }

        public Headers getHeaders();

        public Headers headers();

        default public Optional<String> header(String string) {
            return this.headers().get(string);
        }

        default public boolean hasHeader(String string) {
            return this.headers().contains(string);
        }

        public boolean hasBody();

        public Optional<String> contentType();

        public Optional<String> charset();

        public Optional<List<X509Certificate>> clientCertificateChain();

        default public RequestHeader withTransientLang(Lang lang) {
            return this.addAttr(Messages.Attrs.CurrentLang, lang);
        }

        @Deprecated
        default public RequestHeader withTransientLang(String string) {
            return this.addAttr(Messages.Attrs.CurrentLang, Lang.forCode(string));
        }

        default public RequestHeader withTransientLang(Locale locale) {
            return this.addAttr(Messages.Attrs.CurrentLang, new Lang(locale));
        }

        default public RequestHeader withoutTransientLang() {
            return this.removeAttr(Messages.Attrs.CurrentLang);
        }

        default public Optional<Lang> transientLang() {
            return this.attrs().getOptional(Messages.Attrs.CurrentLang).map(play.api.i18n.Lang::asJava);
        }

        public play.api.mvc.RequestHeader asScala();
    }

    public static class Headers {
        private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

        public Headers(Map<String, List<String>> map) {
            this.headers.putAll(map);
        }

        @Deprecated
        public Map<String, List<String>> toMap() {
            return this.headers;
        }

        public Map<String, List<String>> asMap() {
            return Collections.unmodifiableMap(this.headers);
        }

        public boolean contains(String string) {
            return this.headers.containsKey(string);
        }

        public Optional<String> get(String string) {
            return Optional.ofNullable(this.headers.get(string)).flatMap(list -> list.stream().findFirst());
        }

        public List<String> getAll(String string) {
            return this.headers.getOrDefault(string, Collections.emptyList());
        }

        public play.api.mvc.Headers asScala() {
            return new play.api.mvc.Headers((Seq<Tuple2<String, String>>)JavaHelpers$.MODULE$.javaMapOfListToScalaSeqOfPairs((Map)this.headers));
        }

        @Deprecated
        public Headers addHeader(String string, String string2) {
            this.headers.put(string, Collections.singletonList(string2));
            return this;
        }

        public Headers adding(String string, String string2) {
            return this.adding(string, Collections.singletonList(string2));
        }

        @Deprecated
        public Headers addHeader(String string, List<String> list) {
            this.headers.put(string, list);
            return this;
        }

        public Headers adding(String string, List<String> list) {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(this.headers.size() + 1);
            hashMap.putAll(this.headers);
            hashMap.put(string, list);
            return new Headers(hashMap);
        }

        @Deprecated
        public Headers remove(String string) {
            this.headers.remove(string);
            return this;
        }

        public Headers removing(String string) {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(this.headers.size());
            hashMap.putAll(this.headers);
            hashMap.remove(string);
            return new Headers(hashMap);
        }
    }
}

