/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.ContentTypeOf$;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.HttpErrorConfig;
import play.api.http.HttpErrorConfig$;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.mvc.Codec$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.api.routing.Router;
import play.core.SourceMapper;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import views.html.defaultpages.badRequest$;
import views.html.defaultpages.devError$;
import views.html.defaultpages.devNotFound$;
import views.html.defaultpages.error$;
import views.html.defaultpages.notFound$;
import views.html.defaultpages.unauthorized$;

@Singleton
public class DefaultHttpErrorHandler
implements HttpErrorHandler {
    private final HttpErrorConfig config;
    private final Option<SourceMapper> sourceMapper;
    private final Function0<Option<Router>> router;
    private final Logger logger;
    private Option<String> playEditor;

    public static HttpErrorConfig $lessinit$greater$default$1() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<SourceMapper> $lessinit$greater$default$2() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public static None$ $lessinit$greater$default$3() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$3();
    }

    public DefaultHttpErrorHandler(HttpErrorConfig config, Option<SourceMapper> sourceMapper, Function0<Option<Router>> router) {
        this.config = config;
        this.sourceMapper = sourceMapper;
        this.router = router;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.playEditor = config.playEditor();
    }

    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, Option<SourceMapper> sourceMapper, Function0<Option<Router>> router) {
        Mode mode = environment.mode();
        Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
        this(HttpErrorConfig$.MODULE$.apply(mode == null ? prod$ != null : !mode.equals(prod$), (Option<String>)configuration.getOptional("play.editor", ConfigLoader$.MODULE$.stringLoader())), sourceMapper, router);
    }

    @Inject
    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, OptionalSourceMapper sourceMapper, Provider<Router> router) {
        this(environment, configuration, sourceMapper.sourceMapper(), DefaultHttpErrorHandler.DefaultHttpErrorHandler$superArg$1(environment, configuration, sourceMapper, router));
    }

    public void setPlayEditor(String editor) {
        this.playEditor = Option$.MODULE$.apply((Object)editor);
    }

    @Override
    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        int n = statusCode;
        if (Status$.MODULE$.BAD_REQUEST() == n) {
            return this.onBadRequest(request, message);
        }
        if (Status$.MODULE$.FORBIDDEN() == n) {
            return this.onForbidden(request, message);
        }
        if (Status$.MODULE$.NOT_FOUND() == n) {
            return this.onNotFound(request, message);
        }
        int clientError = n;
        if (statusCode >= 400 && statusCode < 500) {
            return this.onOtherClientError(request, statusCode, message);
        }
        int nonClientError = n;
        throw new IllegalArgumentException("onClientError invoked with non client error status code " + statusCode + ": " + message);
    }

    public Future<Result> onBadRequest(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.BadRequest().apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message, request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onForbidden(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Forbidden().apply(unauthorized$.MODULE$.apply(request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onNotFound(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)(this.config.showDevErrors() ? Results$.MODULE$.NotFound().apply(devNotFound$.MODULE$.apply(request.method(), request.uri(), (Option<Router>)((Option)this.router.apply()), request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))) : Results$.MODULE$.NotFound().apply(notFound$.MODULE$.apply(request.method(), request.uri(), request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8())))));
    }

    public Future<Result> onOtherClientError(RequestHeader request, int statusCode, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message, request), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    @Override
    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        Object object;
        try {
            UsefulException usefulException = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException(this.sourceMapper, !this.config.showDevErrors(), exception);
            this.logServerError(request, usefulException);
            object = this.config.showDevErrors() ? this.onDevServerError(request, usefulException) : this.onProdServerError(request, usefulException);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.logger.error(DefaultHttpErrorHandler::onServerError$$anonfun$1, () -> DefaultHttpErrorHandler.onServerError$$anonfun$2(e), MarkerContext$.MODULE$.NoMarker());
                object = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(this.fatalErrorMessage(request, e), Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8())));
            }
            throw throwable;
        }
        return object;
    }

    public String fatalErrorMessage(RequestHeader request, Throwable exception) {
        return "";
    }

    public void logServerError(RequestHeader request, UsefulException usefulException) {
        this.logger.error(() -> DefaultHttpErrorHandler.logServerError$$anonfun$1(usefulException, request), () -> DefaultHttpErrorHandler.logServerError$$anonfun$2(usefulException), MarkerContext$.MODULE$.NoMarker());
    }

    public Future<Result> onDevServerError(RequestHeader request, UsefulException exception) {
        RequestHeader ir = request;
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(devError$.MODULE$.apply(this.playEditor, exception, ir), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onProdServerError(RequestHeader request, UsefulException exception) {
        RequestHeader ir = request;
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(error$.MODULE$.apply(exception, ir), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    private static Function0<Option<Router>> DefaultHttpErrorHandler$superArg$1(Environment environment, Configuration configuration, OptionalSourceMapper sourceMapper, Provider<Router> router) {
        return () -> DefaultHttpErrorHandler.DefaultHttpErrorHandler$superArg$1$$anonfun$1(router);
    }

    private static final String onServerError$$anonfun$1() {
        return "Error while handling error";
    }

    private static final Throwable onServerError$$anonfun$2(Throwable e$1) {
        return e$1;
    }

    private static final String logServerError$$anonfun$1(UsefulException usefulException$1, RequestHeader request$1) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |\n        |! @%s - Internal server error, for (%s) [%s] ->\n        | "))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{usefulException$1.id, request$1.method(), request$1.uri()}));
    }

    private static final Throwable logServerError$$anonfun$2(UsefulException usefulException$2) {
        return usefulException$2;
    }

    private static final Option DefaultHttpErrorHandler$superArg$1$$anonfun$1(Provider router$1) {
        return Some$.MODULE$.apply(router$1.get());
    }
}

