/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import com.typesafe.config.ConfigException;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.http.HttpFilters;
import play.api.inject.BindingKey;
import play.api.inject.BindingKey$;
import play.api.inject.Injector;
import play.api.mvc.EssentialFilter;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;

@Singleton
public class EnabledFilters
implements HttpFilters {
    private final Environment env;
    private final Configuration configuration;
    private final Injector injector;
    private final String url;
    private final Logger logger;
    private final String enabledKey;
    private final Seq filters;

    @Inject
    public EnabledFilters(Environment env, Configuration configuration, Injector injector) {
        Nil$ nil$;
        this.env = env;
        this.configuration = configuration;
        this.injector = injector;
        this.url = "https://www.playframework.com/documentation/latest/Filters";
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.enabledKey = "play.filters.enabled";
        String disabledKey = "play.filters.disabled";
        EnabledFilters enabledFilters = this;
        try {
            Set disabledSet = ((IterableOnceOps)configuration.get(disabledKey, ConfigLoader$.MODULE$.seqStringLoader())).toSet();
            Seq enabledList = (Seq)((IterableOps)configuration.get(this.enabledKey, ConfigLoader$.MODULE$.seqStringLoader())).filterNot((Function1 & Serializable)elem -> disabledSet.contains(elem));
            nil$ = (Seq)enabledList.map((Function1 & Serializable)filterClassName -> {
                BindingKey<?> bindingKey;
                try {
                    Class<?> filterClass = env.classLoader().loadClass((String)filterClassName);
                    bindingKey = BindingKey$.MODULE$.apply(filterClass);
                }
                catch (ClassNotFoundException e) {
                    throw configuration.reportError(this.enabledKey, "Cannot load class " + filterClassName, (Option)Some$.MODULE$.apply((Object)e));
                }
                return bindingKey;
            });
        }
        catch (ConfigException.Null e) {
            nil$ = package$.MODULE$.Nil();
        }
        catch (ConfigException.Missing e) {
            nil$ = package$.MODULE$.Nil();
        }
        Nil$ nil$2 = nil$;
        EnabledFilters enabledFilters2 = enabledFilters;
        enabledFilters = null;
        Nil$ nil$3 = nil$2;
        nil$2 = null;
        Nil$ bindings = nil$3;
        enabledFilters2.filters = (Seq)bindings.map((Function1 & Serializable)_$1 -> (EssentialFilter)injector.instanceOf(_$1));
        this.start();
    }

    @Override
    public Seq<EssentialFilter> filters() {
        return this.filters;
    }

    private void printMessageInDevMode() {
        Mode mode = this.env.mode();
        Mode.Dev$ dev$ = Mode.Dev$.MODULE$;
        if (!(mode != null ? !mode.equals(dev$) : dev$ != null)) {
            StringBuffer b = new StringBuffer();
            b.append("Enabled Filters (see <" + this.url + ">):\n\n");
            this.filters().foreach((Function1 & Serializable)f -> b.append("    " + f.getClass().getCanonicalName() + "\n"));
            this.logger.info(() -> EnabledFilters.printMessageInDevMode$$anonfun$2(b), MarkerContext$.MODULE$.NoMarker());
            return;
        }
    }

    public void start() {
        this.printMessageInDevMode();
    }

    private static final String printMessageInDevMode$$anonfun$2(StringBuffer b$2) {
        return b$2.toString();
    }
}

