/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import play.api.mvc.Cookie;
import play.api.mvc.Cookie$;
import play.api.mvc.CookieDataCodec;
import play.api.mvc.DiscardingCookie;
import play.api.mvc.DiscardingCookie$;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Map;

public interface CookieBaker<T> {
    public String COOKIE_NAME();

    public T emptyCookie();

    public static boolean isSigned$(CookieBaker $this) {
        return $this.isSigned();
    }

    default public boolean isSigned() {
        return false;
    }

    public static boolean httpOnly$(CookieBaker $this) {
        return $this.httpOnly();
    }

    default public boolean httpOnly() {
        return true;
    }

    public static Option maxAge$(CookieBaker $this) {
        return $this.maxAge();
    }

    default public Option<Object> maxAge() {
        return None$.MODULE$;
    }

    public static Option domain$(CookieBaker $this) {
        return $this.domain();
    }

    default public Option<String> domain() {
        return None$.MODULE$;
    }

    public static boolean secure$(CookieBaker $this) {
        return $this.secure();
    }

    default public boolean secure() {
        return false;
    }

    public static String path$(CookieBaker $this) {
        return $this.path();
    }

    default public String path() {
        return "/";
    }

    public static Option sameSite$(CookieBaker $this) {
        return $this.sameSite();
    }

    default public Option<Cookie.SameSite> sameSite() {
        return None$.MODULE$;
    }

    public static boolean partitioned$(CookieBaker $this) {
        return $this.partitioned();
    }

    default public boolean partitioned() {
        return false;
    }

    public static Cookie encodeAsCookie$(CookieBaker $this, Object data) {
        return $this.encodeAsCookie(data);
    }

    default public Cookie encodeAsCookie(T data) {
        String cookie = ((CookieDataCodec)((Object)this)).encode(this.serialize(data));
        return Cookie$.MODULE$.apply(this.COOKIE_NAME(), cookie, this.maxAge(), this.path(), this.domain(), this.secure(), this.httpOnly(), this.sameSite(), this.partitioned());
    }

    public static Map decodeCookieToMap$(CookieBaker $this, Option cookie) {
        return $this.decodeCookieToMap((Option<Cookie>)cookie);
    }

    default public Map<String, String> decodeCookieToMap(Option<Cookie> cookie) {
        return this.serialize(this.decodeFromCookie(cookie));
    }

    public static Object decodeFromCookie$(CookieBaker $this, Option cookie) {
        return $this.decodeFromCookie((Option<Cookie>)cookie);
    }

    default public T decodeFromCookie(Option<Cookie> cookie) {
        if (cookie.isEmpty()) {
            return this.emptyCookie();
        }
        Cookie extractedCookie = (Cookie)cookie.get();
        String string = extractedCookie.name();
        String string2 = this.COOKIE_NAME();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return this.emptyCookie();
        }
        return this.deserialize(((CookieDataCodec)((Object)this)).decode(extractedCookie.value()));
    }

    public static DiscardingCookie discard$(CookieBaker $this) {
        return $this.discard();
    }

    default public DiscardingCookie discard() {
        return DiscardingCookie$.MODULE$.apply(this.COOKIE_NAME(), this.path(), this.domain(), this.secure(), this.sameSite(), this.partitioned());
    }

    public T deserialize(Map<String, String> var1);

    public Map<String, String> serialize(T var1);
}

