/*
 * Decompiled with CFR 0.152.
 */
package play.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.Serializable;
import play.utils.DeserializerContext;
import play.utils.KeyRead;
import play.utils.ReadingList;
import play.utils.ReadingList$;
import play.utils.ReadingMap;
import play.utils.ReadingMap$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class JsonNodeDeserializer
extends JsonDeserializer<JsonNode> {
    private final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    private final NullNode getNullValue = NullNode.instance;

    public boolean isCachable() {
        return true;
    }

    public JsonNode deserialize(JsonParser jp, DeserializationContext ctxt) {
        return this.deserialize(jp, ctxt, (List<DeserializerContext>)package$.MODULE$.Nil());
    }

    private JsonNode fromInt(JsonParser jp, DeserializationContext ctxt) {
        JsonParser.NumberType numberType;
        int feats = ctxt.getDeserializationFeatures();
        JsonNodeFactory nodeFactory = ctxt.getNodeFactory();
        JsonParser.NumberType numberType2 = numberType = (feats & this.F_MASK_INT_COERCIONS) != 0 ? (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(feats) ? JsonParser.NumberType.BIG_INTEGER : (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(feats) ? JsonParser.NumberType.LONG : jp.getNumberType())) : jp.getNumberType();
        JsonParser.NumberType numberType3 = JsonParser.NumberType.INT;
        JsonParser.NumberType numberType4 = numberType2;
        if (!(numberType3 != null ? !numberType3.equals(numberType4) : numberType4 != null)) {
            return nodeFactory.numberNode(jp.getIntValue());
        }
        JsonParser.NumberType numberType5 = JsonParser.NumberType.LONG;
        JsonParser.NumberType numberType6 = numberType2;
        if (!(numberType5 != null ? !numberType5.equals(numberType6) : numberType6 != null)) {
            return nodeFactory.numberNode(jp.getLongValue());
        }
        return nodeFactory.numberNode(jp.getBigIntegerValue());
    }

    private JsonNode fromFloat(JsonParser jp, DeserializationContext ctxt) {
        JsonNodeFactory nodeFactory = ctxt.getNodeFactory();
        JsonParser.NumberType nt = jp.getNumberType();
        if (nt == JsonParser.NumberType.BIG_DECIMAL) {
            return nodeFactory.numberNode(jp.getDecimalValue());
        }
        if (ctxt.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            if (jp.isNaN()) {
                return nodeFactory.numberNode(jp.getDoubleValue());
            }
            return nodeFactory.numberNode(jp.getDecimalValue());
        }
        if (nt == JsonParser.NumberType.FLOAT) {
            return nodeFactory.numberNode(jp.getFloatValue());
        }
        return nodeFactory.numberNode(jp.getDoubleValue());
    }

    private JsonNode fromEmbedded(JsonParser p, DeserializationContext ctxt) {
        JsonNodeFactory nodeFactory = ctxt.getNodeFactory();
        Object ob = p.getEmbeddedObject();
        if (ob == null) {
            return nodeFactory.nullNode();
        }
        Class<?> type = ob.getClass();
        if (type == byte[].class) {
            return nodeFactory.binaryNode((byte[])ob);
        }
        if (ob instanceof RawValue) {
            return nodeFactory.rawValueNode((RawValue)ob);
        }
        if (ob instanceof JsonNode) {
            return (JsonNode)ob;
        }
        return nodeFactory.pojoNode(ob);
    }

    public final JsonNode deserialize(JsonParser jp, DeserializationContext ctxt, List<DeserializerContext> parserContext) {
        while (true) {
            List toPass;
            if (jp.getCurrentToken() == null) {
                jp.nextToken();
            }
            int n = jp.getCurrentToken().id();
            Tuple2 tuple2 = switch (n) {
                case 7 -> Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)this.fromInt(jp, ctxt)), parserContext);
                case 8 -> Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)this.fromFloat(jp, ctxt)), parserContext);
                case 6 -> Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)new TextNode(jp.getText())), parserContext);
                case 9 -> Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BooleanNode.TRUE), parserContext);
                case 10 -> Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BooleanNode.FALSE), parserContext);
                case 11 -> Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)NullNode.instance), parserContext);
                case 3 -> {
                    ReadingList var7_7 = ReadingList$.MODULE$.apply((ArrayBuffer<JsonNode>)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JsonNode[0]))));
                    yield Tuple2$.MODULE$.apply((Object)None$.MODULE$, parserContext.$plus$colon((Object)var7_7));
                }
                case 4 -> {
                    List var8_8 = parserContext;
                    if (var8_8 instanceof .colon.colon) {
                        .colon.colon var9_9 = (.colon.colon)var8_8;
                        DeserializerContext var10_10 = (DeserializerContext)var9_9.head();
                        List var11_11 = var9_9.next$access$1();
                        if (var10_10 instanceof ReadingList) {
                            ArrayBuffer<JsonNode> var13_13;
                            ReadingList var12_12 = ReadingList$.MODULE$.unapply((ReadingList)var10_10);
                            ArrayBuffer<JsonNode> content = var13_13 = var12_12._1();
                            List stack = var11_11;
                            ArrayNode node = new ArrayNode(ctxt.getNodeFactory());
                            content.foreach((Function1 & Serializable)x$0 -> node.add(x$0));
                            yield Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)node), (Object)stack);
                        }
                    }
                    throw new RuntimeException("We should have been reading list, something got wrong");
                }
                case 1 -> {
                    ReadingMap var17_17 = ReadingMap$.MODULE$.apply((ListBuffer<Tuple2<String, JsonNode>>)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
                    yield Tuple2$.MODULE$.apply((Object)None$.MODULE$, parserContext.$plus$colon((Object)var17_17));
                }
                case 5 -> {
                    List var18_18 = parserContext;
                    if (var18_18 instanceof .colon.colon) {
                        .colon.colon var19_19 = (.colon.colon)var18_18;
                        DeserializerContext var20_20 = (DeserializerContext)var19_19.head();
                        List var21_21 = var19_19.next$access$1();
                        if (var20_20 instanceof ReadingMap) {
                            ReadingMap c = (ReadingMap)var20_20;
                            List stack = var21_21;
                            KeyRead var24_24 = c.setField(jp.getCurrentName());
                            yield Tuple2$.MODULE$.apply((Object)None$.MODULE$, stack.$plus$colon((Object)var24_24));
                        }
                    }
                    throw new RuntimeException("We should be reading map, something got wrong");
                }
                case 2 -> {
                    List var25_25 = parserContext;
                    if (var25_25 instanceof .colon.colon) {
                        .colon.colon var26_26 = (.colon.colon)var25_25;
                        DeserializerContext var27_27 = (DeserializerContext)var26_26.head();
                        List var28_28 = var26_26.next$access$1();
                        if (var27_27 instanceof ReadingMap) {
                            ListBuffer<Tuple2<String, JsonNode>> var30_30;
                            ReadingMap var29_29 = ReadingMap$.MODULE$.unapply((ReadingMap)var27_27);
                            ListBuffer<Tuple2<String, JsonNode>> content = var30_30 = var29_29._1();
                            List stack = var28_28;
                            ObjectNode node = new ObjectNode(ctxt.getNodeFactory());
                            content.foreach((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    JsonNode jsonNode = (JsonNode)tuple2._2();
                                    String k = (String)tuple2._1();
                                    if (jsonNode != null) {
                                        JsonNode v = jsonNode;
                                        return node.set(k, v);
                                    }
                                }
                                throw new MatchError((Object)tuple2);
                            });
                            yield Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)node), (Object)stack);
                        }
                    }
                    throw new RuntimeException("We should have been reading an object, something got wrong");
                }
                case -1 -> throw new RuntimeException("Didn't receive a token when requesting one. See Jackson's JsonToken#NOT_AVAILABLE.");
                case 12 -> Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)this.fromEmbedded(jp, ctxt)), parserContext);
                default -> throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            };
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option maybeValue = (Option)tuple2._1();
            List nextContext = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)maybeValue, (Object)nextContext);
            Option maybeValue2 = (Option)tuple22._1();
            List nextContext2 = (List)tuple22._2();
            Option option = maybeValue2;
            if (option instanceof Some) {
                JsonNode v2 = (JsonNode)((Some)option).value();
                if (nextContext2.isEmpty()) {
                    return v2;
                }
            }
            Option maybeValue3 = option;
            jp.nextToken();
            parserContext = toPass = (List)maybeValue3.map((Function1 & Serializable)v -> {
                List list = nextContext2;
                if (!(list instanceof .colon.colon)) {
                    throw new MatchError((Object)list);
                }
                .colon.colon colon2 = (.colon.colon)list;
                List list2 = colon2.next$access$1();
                DeserializerContext previous = (DeserializerContext)colon2.head();
                List stack = list2;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)previous, (Object)stack);
                DeserializerContext previous2 = (DeserializerContext)tuple2._1();
                List stack2 = (List)tuple2._2();
                DeserializerContext deserializerContext = previous2.addValue((JsonNode)v);
                return (List)stack2.$plus$colon((Object)deserializerContext);
            }).getOrElse(() -> JsonNodeDeserializer.$anonfun$4(nextContext2));
        }
    }

    public NullNode getNullValue() {
        return this.getNullValue;
    }

    private static final List $anonfun$4(List nextContext$2) {
        return nextContext$2;
    }
}

