/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.org.asynchttpclient.request.body.Body;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.FeedListener;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.UnboundedQueueFeedableBodyGenerator;
import play.shaded.ahc.org.asynchttpclient.util.Assertions;

public class ReactiveStreamsBodyGenerator
implements FeedableBodyGenerator {
    private final Publisher<ByteBuf> publisher;
    private final FeedableBodyGenerator feedableBodyGenerator;
    private final long contentLength;
    private volatile FeedListener feedListener;

    public ReactiveStreamsBodyGenerator(Publisher<ByteBuf> publisher, long contentLength) {
        this.publisher = publisher;
        this.feedableBodyGenerator = new UnboundedQueueFeedableBodyGenerator();
        this.contentLength = contentLength;
    }

    public Publisher<ByteBuf> getPublisher() {
        return this.publisher;
    }

    @Override
    public boolean feed(ByteBuf buffer, boolean isLast) throws Exception {
        return this.feedableBodyGenerator.feed(buffer, isLast);
    }

    @Override
    public void setListener(FeedListener listener) {
        this.feedListener = listener;
        this.feedableBodyGenerator.setListener(listener);
    }

    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public Body createBody() {
        return new StreamedBody(this.feedableBodyGenerator, this.contentLength);
    }

    private class SimpleSubscriber
    implements Subscriber<ByteBuf> {
        private final Logger LOGGER = LoggerFactory.getLogger(SimpleSubscriber.class);
        private final FeedableBodyGenerator feeder;
        private volatile Subscription subscription;

        public SimpleSubscriber(FeedableBodyGenerator feeder) {
            this.feeder = feeder;
        }

        public void onSubscribe(Subscription s) {
            Assertions.assertNotNull(s, "subscription");
            if (this.subscription != null) {
                s.cancel();
            } else {
                this.subscription = s;
                this.subscription.request(Long.MAX_VALUE);
            }
        }

        public void onNext(ByteBuf b) {
            Assertions.assertNotNull(b, "bytebuf");
            try {
                this.feeder.feed(b, false);
            }
            catch (Exception e) {
                this.LOGGER.error("Exception occurred while processing element in stream.", (Throwable)e);
                this.subscription.cancel();
            }
        }

        public void onError(Throwable t) {
            Assertions.assertNotNull(t, "throwable");
            this.LOGGER.debug("Error occurred while consuming body stream.", t);
            FeedListener listener = ReactiveStreamsBodyGenerator.this.feedListener;
            if (listener != null) {
                listener.onError(t);
            }
        }

        public void onComplete() {
            try {
                this.feeder.feed(Unpooled.EMPTY_BUFFER, true);
            }
            catch (Exception e) {
                this.LOGGER.info("Ignoring exception occurred while completing stream processing.", (Throwable)e);
                this.subscription.cancel();
            }
        }
    }

    private class StreamedBody
    implements Body {
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private final SimpleSubscriber subscriber;
        private final Body body;
        private final long contentLength;

        public StreamedBody(FeedableBodyGenerator bodyGenerator, long contentLength) {
            this.body = bodyGenerator.createBody();
            this.subscriber = new SimpleSubscriber(bodyGenerator);
            this.contentLength = contentLength;
        }

        @Override
        public void close() throws IOException {
            this.body.close();
        }

        @Override
        public long getContentLength() {
            return this.contentLength;
        }

        @Override
        public Body.BodyState transferTo(ByteBuf target) throws IOException {
            if (this.initialized.compareAndSet(false, true)) {
                ReactiveStreamsBodyGenerator.this.publisher.subscribe((Subscriber)this.subscriber);
            }
            return this.body.transferTo(target);
        }
    }
}

