/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.channel;

import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.netty.channel.CombinedConnectionSemaphore;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ConnectionSemaphore;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ConnectionSemaphoreFactory;
import play.shaded.ahc.org.asynchttpclient.netty.channel.MaxConnectionSemaphore;
import play.shaded.ahc.org.asynchttpclient.netty.channel.NoopConnectionSemaphore;

public class DefaultConnectionSemaphoreFactory
implements ConnectionSemaphoreFactory {
    @Override
    public ConnectionSemaphore newConnectionSemaphore(AsyncHttpClientConfig config) {
        int acquireFreeChannelTimeout = Math.max(0, config.getAcquireFreeChannelTimeout());
        int maxConnections = config.getMaxConnections();
        int maxConnectionsPerHost = config.getMaxConnectionsPerHost();
        if (maxConnections > 0 && maxConnectionsPerHost > 0) {
            return new CombinedConnectionSemaphore(maxConnections, maxConnectionsPerHost, acquireFreeChannelTimeout);
        }
        if (maxConnections > 0) {
            return new MaxConnectionSemaphore(maxConnections, acquireFreeChannelTimeout);
        }
        if (maxConnectionsPerHost > 0) {
            return new CombinedConnectionSemaphore(maxConnections, maxConnectionsPerHost, acquireFreeChannelTimeout);
        }
        return new NoopConnectionSemaphore();
    }
}

