/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.crypto;

import java.io.Serializable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import play.silhouette.api.crypto.Signer;
import play.silhouette.api.exceptions.CryptoException;
import play.silhouette.api.exceptions.CryptoException$;
import play.silhouette.crypto.JcaSigner$;
import play.silhouette.crypto.JcaSignerSettings;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public class JcaSigner
implements Signer {
    private final JcaSignerSettings settings;

    public static String BadSignature() {
        return JcaSigner$.MODULE$.BadSignature();
    }

    public static String InvalidMessageFormat() {
        return JcaSigner$.MODULE$.InvalidMessageFormat();
    }

    public static String UnknownVersion() {
        return JcaSigner$.MODULE$.UnknownVersion();
    }

    public JcaSigner(JcaSignerSettings settings) {
        this.settings = settings;
    }

    public String sign(String data) {
        String message = new StringBuilder(0).append(this.settings.pepper()).append(data).append(this.settings.pepper()).toString();
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec(this.settings.key().getBytes("UTF-8"), "HmacSHA1"));
        String signature = Hex.encodeHexString((byte[])mac.doFinal(message.getBytes("UTF-8")));
        int version = 1;
        return new StringBuilder(2).append(version).append("-").append(signature).append("-").append(data).toString();
    }

    public Try<String> extract(String message) {
        return this.fragment(message).withFilter((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                String actualSignature = (String)tuple3._2();
                String actualData = (String)tuple3._3();
                return true;
            }
            return false;
        }).flatMap((Function1 & Serializable)x$12 -> {
            Tuple3 tuple3 = x$12;
            if (tuple3 != null) {
                String actualSignature = (String)tuple3._2();
                String actualData = (String)tuple3._3();
                return this.fragment(this.sign(actualData)).withFilter((Function1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 != null) {
                        String expectedSignature = (String)tuple3._2();
                        return true;
                    }
                    return false;
                }).map((Function1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 != null) {
                        String expectedSignature = (String)tuple3._2();
                        if (this.constantTimeEquals(expectedSignature, actualSignature)) {
                            return actualData;
                        }
                        throw new CryptoException(JcaSigner$.MODULE$.BadSignature(), CryptoException$.MODULE$.$lessinit$greater$default$2());
                    }
                    throw new MatchError((Object)tuple3);
                });
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private Try<Tuple3<String, String, String>> fragment(String message) {
        Object object;
        String[] stringArray = message.split("-", 3);
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 3) == 0) {
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2);
            String version = string;
            String signature = string2;
            String data = string3;
            String string4 = version;
            String string5 = "1";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return Success$.MODULE$.apply((Object)Tuple3$.MODULE$.apply((Object)version, (Object)signature, (Object)data));
            }
            String version2 = string;
            return Failure$.MODULE$.apply((Throwable)new CryptoException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JcaSigner$.MODULE$.UnknownVersion()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{version2})), CryptoException$.MODULE$.$lessinit$greater$default$2()));
        }
        return Failure$.MODULE$.apply((Throwable)new CryptoException(JcaSigner$.MODULE$.InvalidMessageFormat(), CryptoException$.MODULE$.$lessinit$greater$default$2()));
    }

    private boolean constantTimeEquals(String a, String b) {
        if (a.length() != b.length()) {
            return false;
        }
        IntRef equal = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), a.length()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> equal$1.elem |= (char)(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(a), i) ^ StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(b), i)));
        return equal.elem == 0;
    }
}

