/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.persistence.repositories;

import javax.inject.Inject;
import play.silhouette.api.StorableAuthenticator;
import play.silhouette.api.repositories.AuthenticatorRepository;
import play.silhouette.api.util.CacheLayer;
import scala.Option;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;

public class CacheAuthenticatorRepository<T extends StorableAuthenticator>
implements AuthenticatorRepository<T> {
    private final CacheLayer cacheLayer;
    private final ClassTag<T> evidence$1;

    @Inject
    public CacheAuthenticatorRepository(CacheLayer cacheLayer, ClassTag<T> evidence$1) {
        this.cacheLayer = cacheLayer;
        this.evidence$1 = evidence$1;
    }

    public Future<Option<T>> find(String id) {
        return this.cacheLayer.find(id, this.evidence$1);
    }

    public Future<T> add(T authenticator) {
        return this.cacheLayer.save(authenticator.id(), authenticator, (Duration)Duration$.MODULE$.Inf());
    }

    public Future<T> update(T authenticator) {
        return this.cacheLayer.save(authenticator.id(), authenticator, (Duration)Duration$.MODULE$.Inf());
    }

    public Future<BoxedUnit> remove(String id) {
        return this.cacheLayer.remove(id);
    }
}

