/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.authenticators;

import java.io.Serializable;
import java.time.ZonedDateTime;
import play.api.Logger;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.silhouette.api.Authenticator$Implicits$;
import play.silhouette.api.LoginInfo;
import play.silhouette.api.exceptions.AuthenticatorCreationException;
import play.silhouette.api.exceptions.AuthenticatorDiscardingException;
import play.silhouette.api.exceptions.AuthenticatorInitializationException;
import play.silhouette.api.exceptions.AuthenticatorRenewalException;
import play.silhouette.api.exceptions.AuthenticatorRetrievalException;
import play.silhouette.api.exceptions.AuthenticatorUpdateException;
import play.silhouette.api.repositories.AuthenticatorRepository;
import play.silhouette.api.services.AuthenticatorResult;
import play.silhouette.api.services.AuthenticatorResult$;
import play.silhouette.api.services.AuthenticatorService;
import play.silhouette.api.services.AuthenticatorService$;
import play.silhouette.api.util.Clock;
import play.silhouette.api.util.ExtractableRequest;
import play.silhouette.api.util.IDGenerator;
import play.silhouette.impl.authenticators.BearerTokenAuthenticator;
import play.silhouette.impl.authenticators.BearerTokenAuthenticatorService$;
import play.silhouette.impl.authenticators.BearerTokenAuthenticatorSettings;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001B\f\u0019\u0001\u0005B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!q\u0005A!b\u0001\n\u0007y\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u000b]\u0003A\u0011\u0001-\t\u000b\u0001\u0004A\u0011I1\t\u000bQ\u0004A\u0011I;\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!9\u0011\u0011\b\u0001\u0005B\u0005m\u0002bBA\u001d\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003;\u0002A\u0011IA0\u0011\u001d\t)\b\u0001C!\u0003oBq!!!\u0001\t\u0003\n\u0019\tC\u0004\u0002\u0002\u0002!\t%a#\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\u001e9\u0011\u0011\u0015\r\t\u0002\u0005\rfAB\f\u0019\u0011\u0003\t)\u000b\u0003\u0004X'\u0011\u0005\u0011q\u0015\u0005\n\u0003S\u001b\"\u0019!C\u0001\u0003WC\u0001\"a/\u0014A\u0003%\u0011Q\u0016\u0002 \u0005\u0016\f'/\u001a:U_.,g.Q;uQ\u0016tG/[2bi>\u00148+\u001a:wS\u000e,'BA\r\u001b\u00039\tW\u000f\u001e5f]RL7-\u0019;peNT!a\u0007\u000f\u0002\t%l\u0007\u000f\u001c\u0006\u0003;y\t!b]5mQ>,X\r\u001e;f\u0015\u0005y\u0012\u0001\u00029mCf\u001c\u0001a\u0005\u0003\u0001E!\"\u0004CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\rE\u0002*]Aj\u0011A\u000b\u0006\u0003W1\n\u0001b]3sm&\u001cWm\u001d\u0006\u0003[q\t1!\u00199j\u0013\ty#F\u0001\u000bBkRDWM\u001c;jG\u0006$xN]*feZL7-\u001a\t\u0003cIj\u0011\u0001G\u0005\u0003ga\u0011\u0001DQ3be\u0016\u0014Hk\\6f]\u0006+H\u000f[3oi&\u001c\u0017\r^8s!\t)d'D\u0001-\u0013\t9DF\u0001\u0004M_\u001e<WM]\u0001\tg\u0016$H/\u001b8hgB\u0011\u0011GO\u0005\u0003wa\u0011\u0001EQ3be\u0016\u0014Hk\\6f]\u0006+H\u000f[3oi&\u001c\u0017\r^8s'\u0016$H/\u001b8hg\u0006Q!/\u001a9pg&$xN]=\u0011\u0007y\n\u0005'D\u0001@\u0015\t\u0001E&\u0001\u0007sKB|7/\u001b;pe&,7/\u0003\u0002C\u007f\t9\u0012)\u001e;iK:$\u0018nY1u_J\u0014V\r]8tSR|'/_\u0001\fS\u0012<UM\\3sCR|'\u000f\u0005\u0002F\u00116\taI\u0003\u0002HY\u0005!Q\u000f^5m\u0013\tIeIA\u0006J\t\u001e+g.\u001a:bi>\u0014\u0018!B2m_\u000e\\\u0007CA#M\u0013\tieIA\u0003DY>\u001c7.\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\t\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002TI\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005U\u0013&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003E)\u00070Z2vi&|gnQ8oi\u0016DH\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000becVLX0\u0015\u0005i[\u0006CA\u0019\u0001\u0011\u0015qu\u0001q\u0001Q\u0011\u0015At\u00011\u0001:\u0011\u0015at\u00011\u0001>\u0011\u0015\u0019u\u00011\u0001E\u0011\u0015Qu\u00011\u0001L\u0003\u0019\u0019'/Z1uKR\u0011!m\u001c\u000b\u0003G\u001a\u00042!\u001531\u0013\t)'K\u0001\u0004GkR,(/\u001a\u0005\u0006O\"\u0001\u001d\u0001[\u0001\be\u0016\fX/Z:u!\tIW.D\u0001k\u0015\tYG.A\u0002nm\u000eT!!\f\u0010\n\u00059T'!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0003q\u0011\u0001\u0007\u0011/A\u0005m_\u001eLg.\u00138g_B\u0011QG]\u0005\u0003g2\u0012\u0011\u0002T8hS:LeNZ8\u0002\u0011I,GO]5fm\u0016,2A^A\u0002)\t98\u0010E\u0002RIb\u00042aI=1\u0013\tQHE\u0001\u0004PaRLwN\u001c\u0005\u0006O&\u0001\u001d\u0001 \t\u0004\u000bv|\u0018B\u0001@G\u0005I)\u0005\u0010\u001e:bGR\f'\r\\3SKF,Xm\u001d;\u0011\t\u0005\u0005\u00111\u0001\u0007\u0001\t\u001d\t)!\u0003b\u0001\u0003\u000f\u0011\u0011AQ\t\u0005\u0003\u0013\ty\u0001E\u0002$\u0003\u0017I1!!\u0004%\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aIA\t\u0013\r\t\u0019\u0002\n\u0002\u0004\u0003:L\u0018\u0001B5oSR$B!!\u0007\u00026Q!\u00111DA\u001a!\u0011\tF-!\b\u0011\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tI\u0003E\u0002\u0002$\u0011j!!!\n\u000b\u0007\u0005\u001d\u0002%\u0001\u0004=e>|GOP\u0005\u0004\u0003W!\u0013A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,\u0011BQa\u001a\u0006A\u0004!Da!a\u000e\u000b\u0001\u0004\u0001\u0014!D1vi\",g\u000e^5dCR|'/A\u0003f[\n,G\r\u0006\u0004\u0002>\u0005%\u0013Q\n\u000b\u0005\u0003\u007f\t9\u0005\u0005\u0003RI\u0006\u0005\u0003cA\u0015\u0002D%\u0019\u0011Q\t\u0016\u0003'\u0005+H\u000f[3oi&\u001c\u0017\r^8s%\u0016\u001cX\u000f\u001c;\t\u000b\u001d\\\u00019\u00015\t\u000f\u0005-3\u00021\u0001\u0002\u001e\u0005)Ao\\6f]\"9\u0011qJ\u0006A\u0002\u0005E\u0013A\u0002:fgVdG\u000fE\u0002j\u0003'J1!!\u0016k\u0005\u0019\u0011Vm];miR)\u0001.!\u0017\u0002\\!9\u00111\n\u0007A\u0002\u0005u\u0001\"B4\r\u0001\u0004A\u0017!\u0002;pk\u000eDG\u0003BA1\u0003g\u0002b!a\u0019\u0002nA\u0002d\u0002BA3\u0003SrA!a\t\u0002h%\tQ%C\u0002\u0002l\u0011\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002p\u0005E$AB#ji\",'OC\u0002\u0002l\u0011Ba!a\u000e\u000e\u0001\u0004\u0001\u0014AB;qI\u0006$X\r\u0006\u0004\u0002z\u0005u\u0014q\u0010\u000b\u0005\u0003\u007f\tY\bC\u0003h\u001d\u0001\u000f\u0001\u000e\u0003\u0004\u000289\u0001\r\u0001\r\u0005\b\u0003\u001fr\u0001\u0019AA)\u0003\u0015\u0011XM\\3x)\u0011\t))!#\u0015\t\u0005m\u0011q\u0011\u0005\u0006O>\u0001\u001d\u0001\u001b\u0005\u0007\u0003oy\u0001\u0019\u0001\u0019\u0015\r\u00055\u0015\u0011SAJ)\u0011\ty$a$\t\u000b\u001d\u0004\u00029\u00015\t\r\u0005]\u0002\u00031\u00011\u0011\u001d\ty\u0005\u0005a\u0001\u0003#\nq\u0001Z5tG\u0006\u0014H\r\u0006\u0004\u0002\u001a\u0006u\u0015q\u0014\u000b\u0005\u0003\u007f\tY\nC\u0003h#\u0001\u000f\u0001\u000e\u0003\u0004\u00028E\u0001\r\u0001\r\u0005\b\u0003\u001f\n\u0002\u0019AA)\u0003}\u0011U-\u0019:feR{7.\u001a8BkRDWM\u001c;jG\u0006$xN]*feZL7-\u001a\t\u0003cM\u0019\"a\u0005\u0012\u0015\u0005\u0005\r\u0016AA%E+\t\ti\u000b\u0005\u0003\u00020\u0006eVBAAY\u0015\u0011\t\u0019,!.\u0002\t1\fgn\u001a\u0006\u0003\u0003o\u000bAA[1wC&!\u0011qFAY\u0003\rIE\t\t")
public class BearerTokenAuthenticatorService
implements AuthenticatorService<BearerTokenAuthenticator>,
play.silhouette.api.Logger {
    private final BearerTokenAuthenticatorSettings settings;
    private final AuthenticatorRepository<BearerTokenAuthenticator> repository;
    private final IDGenerator idGenerator;
    private final Clock clock;
    private final ExecutionContext executionContext;
    private Logger logger;

    public static String ID() {
        return BearerTokenAuthenticatorService$.MODULE$.ID();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void play$silhouette$api$Logger$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public Future<BearerTokenAuthenticator> create(LoginInfo loginInfo, RequestHeader request) {
        return this.idGenerator.generate().map((Function1 & Serializable)id -> {
            ZonedDateTime now = $this.clock.now();
            return new BearerTokenAuthenticator((String)id, loginInfo, now, Authenticator$Implicits$.MODULE$.RichDateTime(now).$plus($this.settings.authenticatorExpiry()), $this.settings.authenticatorIdleTimeout());
        }, this.executionContext()).recover((PartialFunction)new Serializable(null, loginInfo){
            private static final long serialVersionUID = 0L;
            private final LoginInfo loginInfo$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorCreationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.CreateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BearerTokenAuthenticatorService$.MODULE$.ID(), this.loginInfo$1})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.loginInfo$1 = loginInfo$1;
            }
        }, this.executionContext());
    }

    @Override
    public <B> Future<Option<BearerTokenAuthenticator>> retrieve(ExtractableRequest<B> request) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> request.extractString($this.settings.fieldName(), $this.settings.requestParts()))).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                String token = (String)some.value();
                return $this.repository.find(token);
            }
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRetrievalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RetrieveError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BearerTokenAuthenticatorService$.MODULE$.ID()})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, this.executionContext());
    }

    @Override
    public Future<String> init(BearerTokenAuthenticator authenticator, RequestHeader request) {
        return this.repository.add(authenticator).map((Function1 & Serializable)a -> a.id(), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final BearerTokenAuthenticator authenticator$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorInitializationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.InitError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BearerTokenAuthenticatorService$.MODULE$.ID(), this.authenticator$1})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$1 = authenticator$1;
            }
        }, this.executionContext());
    }

    public Future<AuthenticatorResult> embed(String token, Result result, RequestHeader request) {
        return Future$.MODULE$.successful((Object)AuthenticatorResult$.MODULE$.apply(result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.settings.fieldName()), (Object)token)}))));
    }

    public RequestHeader embed(String token, RequestHeader request) {
        .colon.colon additional = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.settings.fieldName()), (Object)token), (List)Nil$.MODULE$);
        return request.withHeaders(request.headers().replace((Seq)additional));
    }

    @Override
    public Either<BearerTokenAuthenticator, BearerTokenAuthenticator> touch(BearerTokenAuthenticator authenticator) {
        if (authenticator.idleTimeout().isDefined()) {
            ZonedDateTime x$1 = this.clock.now();
            String x$2 = authenticator.copy$default$1();
            LoginInfo x$3 = authenticator.copy$default$2();
            ZonedDateTime x$4 = authenticator.copy$default$4();
            Option<FiniteDuration> x$5 = authenticator.copy$default$5();
            return package$.MODULE$.Left().apply((Object)authenticator.copy(x$2, x$3, x$1, x$4, x$5));
        }
        return package$.MODULE$.Right().apply((Object)authenticator);
    }

    @Override
    public Future<AuthenticatorResult> update(BearerTokenAuthenticator authenticator, Result result, RequestHeader request) {
        return this.repository.update(authenticator).map((Function1 & Serializable)x$1 -> AuthenticatorResult$.MODULE$.apply(result), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final BearerTokenAuthenticator authenticator$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorUpdateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.UpdateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BearerTokenAuthenticatorService$.MODULE$.ID(), this.authenticator$2})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$2 = authenticator$2;
            }
        }, this.executionContext());
    }

    @Override
    public Future<String> renew(BearerTokenAuthenticator authenticator, RequestHeader request) {
        return this.repository.remove(authenticator.id()).flatMap((Function1 & Serializable)x$2 -> this.create(authenticator.loginInfo(), request).flatMap((Function1 & Serializable)authenticator -> this.init((BearerTokenAuthenticator)authenticator, request), this.executionContext()), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final BearerTokenAuthenticator authenticator$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BearerTokenAuthenticatorService$.MODULE$.ID(), this.authenticator$3})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$3 = authenticator$3;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> renew(BearerTokenAuthenticator authenticator, Result result, RequestHeader request) {
        return this.renew(authenticator, request).flatMap((Function1 & Serializable)v -> this.embed((String)v, result, request), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final BearerTokenAuthenticator authenticator$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BearerTokenAuthenticatorService$.MODULE$.ID(), this.authenticator$4})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$4 = authenticator$4;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> discard(BearerTokenAuthenticator authenticator, Result result, RequestHeader request) {
        return this.repository.remove(authenticator.id()).map((Function1 & Serializable)x$3 -> AuthenticatorResult$.MODULE$.apply(result), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final BearerTokenAuthenticator authenticator$5;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorDiscardingException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.DiscardError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BearerTokenAuthenticatorService$.MODULE$.ID(), this.authenticator$5})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$5 = authenticator$5;
            }
        }, this.executionContext());
    }

    public BearerTokenAuthenticatorService(BearerTokenAuthenticatorSettings settings, AuthenticatorRepository<BearerTokenAuthenticator> repository, IDGenerator idGenerator, Clock clock, ExecutionContext executionContext) {
        this.settings = settings;
        this.repository = repository;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.executionContext = executionContext;
        play.silhouette.api.Logger.$init$(this);
        Statics.releaseFence();
    }
}

