/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.authenticators;

import java.io.Serializable;
import java.time.ZonedDateTime;
import play.api.Logger;
import play.api.MarkerContext$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Session;
import play.api.mvc.SessionCookieBaker;
import play.api.mvc.request.Cell;
import play.api.mvc.request.Cell$;
import play.api.mvc.request.RequestAttrKey$;
import play.silhouette.api.Authenticator$Implicits$;
import play.silhouette.api.LoginInfo;
import play.silhouette.api.crypto.AuthenticatorEncoder;
import play.silhouette.api.exceptions.AuthenticatorCreationException;
import play.silhouette.api.exceptions.AuthenticatorDiscardingException;
import play.silhouette.api.exceptions.AuthenticatorRenewalException;
import play.silhouette.api.exceptions.AuthenticatorRetrievalException;
import play.silhouette.api.exceptions.AuthenticatorUpdateException;
import play.silhouette.api.services.AuthenticatorResult;
import play.silhouette.api.services.AuthenticatorResult$;
import play.silhouette.api.services.AuthenticatorService;
import play.silhouette.api.services.AuthenticatorService$;
import play.silhouette.api.util.Clock;
import play.silhouette.api.util.ExtractableRequest;
import play.silhouette.api.util.FingerprintGenerator;
import play.silhouette.impl.authenticators.SessionAuthenticator;
import play.silhouette.impl.authenticators.SessionAuthenticator$;
import play.silhouette.impl.authenticators.SessionAuthenticatorService$;
import play.silhouette.impl.authenticators.SessionAuthenticatorSettings;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\u0010 \u0001!B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002C/\u0001\u0005\u000b\u0007I1\u00010\t\u0011\u0015\u0004!\u0011!Q\u0001\n}CQA\u001a\u0001\u0005\u0002\u001dDQ\u0001\u001d\u0001\u0005BEDq!!\u0001\u0001\t\u0003\n\u0019\u0001C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D!9\u0011\u0011\t\u0001\u0005B\u0005}\u0003bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\ty\t\u0001C!\u0003#Cq!a$\u0001\t\u0003\nI\nC\u0004\u0002$\u0002!\t%!*\b\u000f\u0005=v\u0004#\u0001\u00022\u001a1ad\bE\u0001\u0003gCaA\u001a\u000b\u0005\u0002\u0005U\u0006\"CA\\)\t\u0007I\u0011AA]\u0011!\tY\r\u0006Q\u0001\n\u0005m\u0006\"CAg)\t\u0007I\u0011AA]\u0011!\ty\r\u0006Q\u0001\n\u0005m\u0006\"CAi)\t\u0007I\u0011AA]\u0011!\t\u0019\u000e\u0006Q\u0001\n\u0005m\u0006\"CAk)\t\u0007I\u0011AA]\u0011!\t9\u000e\u0006Q\u0001\n\u0005m&aG*fgNLwN\\!vi\",g\u000e^5dCR|'oU3sm&\u001cWM\u0003\u0002!C\u0005q\u0011-\u001e;iK:$\u0018nY1u_J\u001c(B\u0001\u0012$\u0003\u0011IW\u000e\u001d7\u000b\u0005\u0011*\u0013AC:jY\"|W/\u001a;uK*\ta%\u0001\u0003qY\u0006L8\u0001A\n\u0005\u0001%z3\b\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0004aU:T\"A\u0019\u000b\u0005I\u001a\u0014\u0001C:feZL7-Z:\u000b\u0005Q\u001a\u0013aA1qS&\u0011a'\r\u0002\u0015\u0003V$\b.\u001a8uS\u000e\fGo\u001c:TKJ4\u0018nY3\u0011\u0005aJT\"A\u0010\n\u0005iz\"\u0001F*fgNLwN\\!vi\",g\u000e^5dCR|'\u000f\u0005\u0002={5\t1'\u0003\u0002?g\t1Aj\\4hKJ\f\u0001b]3ui&twm\u001d\t\u0003q\u0005K!AQ\u0010\u00039M+7o]5p]\u0006+H\u000f[3oi&\u001c\u0017\r^8s'\u0016$H/\u001b8hg\u0006!b-\u001b8hKJ\u0004(/\u001b8u\u000f\u0016tWM]1u_J\u0004\"!\u0012%\u000e\u0003\u0019S!aR\u001a\u0002\tU$\u0018\u000e\\\u0005\u0003\u0013\u001a\u0013ACR5oO\u0016\u0014\bO]5oi\u001e+g.\u001a:bi>\u0014\u0018\u0001F1vi\",g\u000e^5dCR|'/\u00128d_\u0012,'\u000f\u0005\u0002M\u001f6\tQJ\u0003\u0002Og\u000511M]=qi>L!\u0001U'\u0003)\u0005+H\u000f[3oi&\u001c\u0017\r^8s\u000b:\u001cw\u000eZ3s\u0003I\u0019Xm]:j_:\u001cun\\6jK\n\u000b7.\u001a:\u0011\u0005M;V\"\u0001+\u000b\u0005U3\u0016aA7wG*\u0011A'J\u0005\u00031R\u0013!cU3tg&|gnQ8pW&,')Y6fe\u0006)1\r\\8dWB\u0011QiW\u0005\u00039\u001a\u0013Qa\u00117pG.\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!AY\u0016\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002eC\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004iW2lgn\u001c\u000b\u0003S*\u0004\"\u0001\u000f\u0001\t\u000buC\u00019A0\t\u000b}B\u0001\u0019\u0001!\t\u000b\rC\u0001\u0019\u0001#\t\u000b)C\u0001\u0019A&\t\u000bEC\u0001\u0019\u0001*\t\u000beC\u0001\u0019\u0001.\u0002\r\r\u0014X-\u0019;f)\t\u00118\u0010\u0006\u0002tmB\u0019\u0001\r^\u001c\n\u0005U\f'A\u0002$viV\u0014X\rC\u0003x\u0013\u0001\u000f\u00010A\u0004sKF,Xm\u001d;\u0011\u0005MK\u0018B\u0001>U\u00055\u0011V-];fgRDU-\u00193fe\")A0\u0003a\u0001{\u0006IAn\\4j]&sgm\u001c\t\u0003yyL!a`\u001a\u0003\u00131{w-\u001b8J]\u001a|\u0017\u0001\u0003:fiJLWM^3\u0016\t\u0005\u0015\u00111\u0004\u000b\u0005\u0003\u000f\ty\u0001\u0005\u0003ai\u0006%\u0001\u0003\u0002\u0016\u0002\f]J1!!\u0004,\u0005\u0019y\u0005\u000f^5p]\"1qO\u0003a\u0002\u0003#\u0001R!RA\n\u0003/I1!!\u0006G\u0005I)\u0005\u0010\u001e:bGR\f'\r\\3SKF,Xm\u001d;\u0011\t\u0005e\u00111\u0004\u0007\u0001\t\u001d\tiB\u0003b\u0001\u0003?\u0011\u0011AQ\t\u0005\u0003C\t9\u0003E\u0002+\u0003GI1!!\n,\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AKA\u0015\u0013\r\tYc\u000b\u0002\u0004\u0003:L\u0018\u0001B5oSR$B!!\r\u0002>Q!\u00111GA\u001e!\u0011\u0001G/!\u000e\u0011\u0007M\u000b9$C\u0002\u0002:Q\u0013qaU3tg&|g\u000eC\u0003x\u0017\u0001\u000f\u0001\u0010\u0003\u0004\u0002@-\u0001\raN\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u000b\u0015l'-\u001a3\u0015\r\u0005\u0015\u0013\u0011KA+)\u0011\t9%a\u0014\u0011\t\u0001$\u0018\u0011\n\t\u0004a\u0005-\u0013bAA'c\t\u0019\u0012)\u001e;iK:$\u0018nY1u_J\u0014Vm];mi\")q\u000f\u0004a\u0002q\"9\u00111\u000b\u0007A\u0002\u0005U\u0012aB:fgNLwN\u001c\u0005\b\u0003/b\u0001\u0019AA-\u0003\u0019\u0011Xm];miB\u00191+a\u0017\n\u0007\u0005uCK\u0001\u0004SKN,H\u000e\u001e\u000b\u0006q\u0006\u0005\u00141\r\u0005\b\u0003'j\u0001\u0019AA\u001b\u0011\u00159X\u00021\u0001y\u0003\u0015!x.^2i)\u0011\tI'!!\u0011\r\u0005-\u00141P\u001c8\u001d\u0011\ti'a\u001e\u000f\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d(\u0003\u0019a$o\\8u}%\tA&C\u0002\u0002z-\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002~\u0005}$AB#ji\",'OC\u0002\u0002z-Ba!a\u0010\u000f\u0001\u00049\u0014AB;qI\u0006$X\r\u0006\u0004\u0002\b\u0006-\u0015Q\u0012\u000b\u0005\u0003\u000f\nI\tC\u0003x\u001f\u0001\u000f\u0001\u0010\u0003\u0004\u0002@=\u0001\ra\u000e\u0005\b\u0003/z\u0001\u0019AA-\u0003\u0015\u0011XM\\3x)\u0011\t\u0019*a&\u0015\t\u0005M\u0012Q\u0013\u0005\u0006oB\u0001\u001d\u0001\u001f\u0005\u0007\u0003\u007f\u0001\u0002\u0019A\u001c\u0015\r\u0005m\u0015qTAQ)\u0011\t9%!(\t\u000b]\f\u00029\u0001=\t\r\u0005}\u0012\u00031\u00018\u0011\u001d\t9&\u0005a\u0001\u00033\nq\u0001Z5tG\u0006\u0014H\r\u0006\u0004\u0002(\u0006-\u0016Q\u0016\u000b\u0005\u0003\u000f\nI\u000bC\u0003x%\u0001\u000f\u0001\u0010\u0003\u0004\u0002@I\u0001\ra\u000e\u0005\b\u0003/\u0012\u0002\u0019AA-\u0003m\u0019Vm]:j_:\fU\u000f\u001e5f]RL7-\u0019;peN+'O^5dKB\u0011\u0001\bF\n\u0003)%\"\"!!-\u0002\u0005%#UCAA^!\u0011\ti,a2\u000e\u0005\u0005}&\u0002BAa\u0003\u0007\fA\u0001\\1oO*\u0011\u0011QY\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0006}&AB*ue&tw-A\u0002J\t\u0002\naBS:p]B\u000b'o]3FeJ|'/A\bKg>t\u0007+\u0019:tK\u0016\u0013(o\u001c:!\u0003EIeN^1mS\u0012T5o\u001c8G_Jl\u0017\r^\u0001\u0013\u0013:4\u0018\r\\5e\u0015N|gNR8s[\u0006$\b%\u0001\nJ]Z\fG.\u001b3GS:<WM\u001d9sS:$\u0018aE%om\u0006d\u0017\u000e\u001a$j]\u001e,'\u000f\u001d:j]R\u0004\u0003")
public class SessionAuthenticatorService
implements AuthenticatorService<SessionAuthenticator>,
play.silhouette.api.Logger {
    private final SessionAuthenticatorSettings settings;
    private final FingerprintGenerator fingerprintGenerator;
    private final AuthenticatorEncoder authenticatorEncoder;
    private final SessionCookieBaker sessionCookieBaker;
    private final Clock clock;
    private final ExecutionContext executionContext;
    private Logger logger;

    public static String InvalidFingerprint() {
        return SessionAuthenticatorService$.MODULE$.InvalidFingerprint();
    }

    public static String InvalidJsonFormat() {
        return SessionAuthenticatorService$.MODULE$.InvalidJsonFormat();
    }

    public static String JsonParseError() {
        return SessionAuthenticatorService$.MODULE$.JsonParseError();
    }

    public static String ID() {
        return SessionAuthenticatorService$.MODULE$.ID();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void play$silhouette$api$Logger$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public Future<SessionAuthenticator> create(LoginInfo loginInfo, RequestHeader request) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ZonedDateTime now = $this.clock.now();
            return new SessionAuthenticator(loginInfo, now, Authenticator$Implicits$.MODULE$.RichDateTime(now).$plus($this.settings.authenticatorExpiry()), $this.settings.authenticatorIdleTimeout(), (Option<String>)($this.settings.useFingerprinting() ? new Some((Object)$this.fingerprintGenerator.generate(request)) : None$.MODULE$));
        })).recover((PartialFunction)new Serializable(null, loginInfo){
            private static final long serialVersionUID = 0L;
            private final LoginInfo loginInfo$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorCreationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.CreateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{SessionAuthenticatorService$.MODULE$.ID(), this.loginInfo$1})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.loginInfo$1 = loginInfo$1;
            }
        }, this.executionContext());
    }

    @Override
    public <B> Future<Option<SessionAuthenticator>> retrieve(ExtractableRequest<B> request) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            if ($this.settings.useFingerprinting()) {
                return new Some((Object)$this.fingerprintGenerator.generate((RequestHeader)request));
            }
            return None$.MODULE$;
        })).map((Function1 & Serializable)fingerprint -> request.session().get($this.settings.sessionKey()).flatMap((Function1 & Serializable)value -> {
            boolean bl = false;
            Success success = null;
            Try<SessionAuthenticator> try_ = SessionAuthenticator$.MODULE$.unserialize((String)value, $this.authenticatorEncoder);
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                SessionAuthenticator authenticator = (SessionAuthenticator)success.value();
                if (fingerprint.isDefined()) {
                    Option<String> option = authenticator.fingerprint();
                    Option option2 = fingerprint;
                    if (option == null ? option2 != null : !option.equals((Object)option2)) {
                        this.logger().info((Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(SessionAuthenticatorService$.MODULE$.InvalidFingerprint()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{SessionAuthenticatorService$.MODULE$.ID(), fingerprint, authenticator})), MarkerContext$.MODULE$.NoMarker());
                        return None$.MODULE$;
                    }
                }
            }
            if (bl) {
                SessionAuthenticator authenticator = (SessionAuthenticator)success.value();
                return new Some((Object)authenticator);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                this.logger().info((Function0 & Serializable)() -> error.getMessage(), (Function0 & Serializable)() -> error, MarkerContext$.MODULE$.NoMarker());
                return None$.MODULE$;
            }
            throw new MatchError(try_);
        }), this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRetrievalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RetrieveError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{SessionAuthenticatorService$.MODULE$.ID()})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, this.executionContext());
    }

    @Override
    public Future<Session> init(SessionAuthenticator authenticator, RequestHeader request) {
        return Future$.MODULE$.successful((Object)request.session().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.settings.sessionKey()), (Object)SessionAuthenticator$.MODULE$.serialize(authenticator, this.authenticatorEncoder))));
    }

    public Future<AuthenticatorResult> embed(Session session, Result result, RequestHeader request) {
        return Future$.MODULE$.successful((Object)AuthenticatorResult$.MODULE$.apply(result.addingToSession(session.data().toSeq(), request)));
    }

    public RequestHeader embed(Session session, RequestHeader request) {
        Session session2;
        Option option = request.attrs().get(RequestAttrKey$.MODULE$.Session());
        if (option instanceof Some) {
            Some some = (Some)option;
            Cell existing = (Cell)some.value();
            session2 = this.sessionCookieBaker.deserialize((Map)((Session)existing.value()).data().$plus$plus((IterableOnce)session.data()));
        } else if (None$.MODULE$.equals(option)) {
            session2 = session;
        } else {
            throw new MatchError((Object)option);
        }
        Session s = session2;
        return request.withAttrs(request.attrs().updated(RequestAttrKey$.MODULE$.Session(), (Object)Cell$.MODULE$.apply((Object)s)));
    }

    @Override
    public Either<SessionAuthenticator, SessionAuthenticator> touch(SessionAuthenticator authenticator) {
        if (authenticator.idleTimeout().isDefined()) {
            ZonedDateTime x$1 = this.clock.now();
            LoginInfo x$2 = authenticator.copy$default$1();
            ZonedDateTime x$3 = authenticator.copy$default$3();
            Option<FiniteDuration> x$4 = authenticator.copy$default$4();
            Option<String> x$5 = authenticator.copy$default$5();
            return package$.MODULE$.Left().apply((Object)authenticator.copy(x$2, x$1, x$3, x$4, x$5));
        }
        return package$.MODULE$.Right().apply((Object)authenticator);
    }

    @Override
    public Future<AuthenticatorResult> update(SessionAuthenticator authenticator, Result result, RequestHeader request) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> AuthenticatorResult$.MODULE$.apply(result.addingToSession((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.settings.sessionKey()), (Object)SessionAuthenticator$.MODULE$.serialize(authenticator, $this.authenticatorEncoder))}), request))).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final SessionAuthenticator authenticator$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorUpdateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.UpdateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{SessionAuthenticatorService$.MODULE$.ID(), this.authenticator$2})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$2 = authenticator$2;
            }
        }));
    }

    @Override
    public Future<Session> renew(SessionAuthenticator authenticator2, RequestHeader request) {
        return this.create(authenticator2.loginInfo(), request).flatMap((Function1 & Serializable)authenticator -> this.init((SessionAuthenticator)authenticator, request), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator2){
            private static final long serialVersionUID = 0L;
            private final SessionAuthenticator authenticator$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{SessionAuthenticatorService$.MODULE$.ID(), this.authenticator$3})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$3 = authenticator$3;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> renew(SessionAuthenticator authenticator, Result result, RequestHeader request) {
        return this.renew(authenticator, request).flatMap((Function1 & Serializable)v -> this.embed((Session)v, result, request), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final SessionAuthenticator authenticator$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{SessionAuthenticatorService$.MODULE$.ID(), this.authenticator$4})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$4 = authenticator$4;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> discard(SessionAuthenticator authenticator, Result result, RequestHeader request) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> AuthenticatorResult$.MODULE$.apply(result.removingFromSession((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.settings.sessionKey()}), request))).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final SessionAuthenticator authenticator$5;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorDiscardingException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.DiscardError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{SessionAuthenticatorService$.MODULE$.ID(), this.authenticator$5})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$5 = authenticator$5;
            }
        }));
    }

    public SessionAuthenticatorService(SessionAuthenticatorSettings settings, FingerprintGenerator fingerprintGenerator, AuthenticatorEncoder authenticatorEncoder, SessionCookieBaker sessionCookieBaker, Clock clock, ExecutionContext executionContext) {
        this.settings = settings;
        this.fingerprintGenerator = fingerprintGenerator;
        this.authenticatorEncoder = authenticatorEncoder;
        this.sessionCookieBaker = sessionCookieBaker;
        this.clock = clock;
        this.executionContext = executionContext;
        play.silhouette.api.Logger.$init$(this);
        Statics.releaseFence();
    }
}

