/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.providers.oauth1.secrets;

import java.io.Serializable;
import java.time.ZonedDateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.Format$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonConfiguration;
import play.api.libs.json.JsonConfiguration$;
import play.api.libs.json.OFormat;
import play.api.libs.json.OFormat$;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.silhouette.api.crypto.Crypter;
import play.silhouette.api.crypto.Signer;
import play.silhouette.impl.exceptions.OAuth1TokenSecretException;
import play.silhouette.impl.exceptions.OAuth1TokenSecretException$;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecret;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecretProvider$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CookieSecret$
implements Serializable {
    public static final CookieSecret$ MODULE$ = new CookieSecret$();
    private static final OFormat<CookieSecret> jsonFormat;

    static {
        JsonConfiguration config$macro$2 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
        OFormat underlying = (OFormat)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("value")).format(Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.StringReads(), (Writes)Writes$.MODULE$.StringWrites())), OFormat$.MODULE$.functionalCanBuildFormats(FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())), OWrites$.MODULE$.functionalCanBuildOWrites())).and((Object)JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("expirationDate")).format(Format$.MODULE$.GenericFormat(Reads$.MODULE$.DefaultZonedDateTimeReads(), Writes$.MODULE$.DefaultZonedDateTimeWrites()))).apply((Function2 & Serializable)(value, expirationDate) -> new CookieSecret((String)value, (ZonedDateTime)expirationDate), package$.MODULE$.unlift((Function1 & Serializable)x$0 -> MODULE$.unapply((CookieSecret)x$0)), OFormat$.MODULE$.invariantFunctorOFormat());
        Function1 & Serializable rfn = (Function1 & Serializable)x0$1 -> {
            JsValue jsValue = x0$1;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                return underlying.reads((JsValue)jsObject);
            }
            return JsError$.MODULE$.apply("error.expected.jsobject");
        };
        jsonFormat = OFormat$.MODULE$.apply((Function1)rfn, (Function1 & Serializable)o -> underlying.writes(o));
    }

    public OFormat<CookieSecret> jsonFormat() {
        return jsonFormat;
    }

    public String serialize(CookieSecret secret, Signer signer, Crypter crypter) {
        return signer.sign(crypter.encrypt(Json$.MODULE$.toJson((Object)secret, this.jsonFormat()).toString()));
    }

    public Try<CookieSecret> unserialize(String str, Signer signer, Crypter crypter) {
        Try<String> try_ = signer.extract(str);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String data = (String)success.value();
            return this.buildSecret(crypter.decrypt(data));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return new Failure((Throwable)new OAuth1TokenSecretException(CookieSecretProvider$.MODULE$.InvalidCookieSignature(), (Option<Throwable>)new Some((Object)e)));
        }
        throw new MatchError(try_);
    }

    private Try<CookieSecret> buildSecret(String str) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Json$.MODULE$.parse(str));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JsValue json = (JsValue)success.value();
            Either either = json.validate(this.jsonFormat()).asEither();
            if (either instanceof Left) {
                Left left = (Left)either;
                Seq error = (Seq)left.value();
                return new Failure((Throwable)new OAuth1TokenSecretException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieSecretProvider$.MODULE$.InvalidSecretFormat()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{error})), OAuth1TokenSecretException$.MODULE$.$lessinit$greater$default$2()));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                CookieSecret authenticator = (CookieSecret)right.value();
                return new Success((Object)authenticator);
            }
            throw new MatchError((Object)either);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            return new Failure((Throwable)new OAuth1TokenSecretException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieSecretProvider$.MODULE$.InvalidJson()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{str})), (Option<Throwable>)new Some((Object)error)));
        }
        throw new MatchError((Object)try_);
    }

    public CookieSecret apply(String value, ZonedDateTime expirationDate) {
        return new CookieSecret(value, expirationDate);
    }

    public Option<Tuple2<String, ZonedDateTime>> unapply(CookieSecret x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.value(), (Object)x$0.expirationDate()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CookieSecret$.class);
    }

    private CookieSecret$() {
    }
}

