/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.providers.state;

import java.io.Serializable;
import javax.inject.Inject;
import play.api.MarkerContext$;
import play.api.libs.json.Json$;
import play.api.mvc.Cookie;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.silhouette.api.Logger;
import play.silhouette.api.crypto.Signer;
import play.silhouette.api.util.ExtractableRequest;
import play.silhouette.api.util.IDGenerator;
import play.silhouette.impl.exceptions.OAuth2StateException;
import play.silhouette.impl.exceptions.OAuth2StateException$;
import play.silhouette.impl.providers.PublishableSocialStateItemHandler;
import play.silhouette.impl.providers.SocialStateItem;
import play.silhouette.impl.providers.SocialStateItemHandler;
import play.silhouette.impl.providers.state.CsrfStateItem;
import play.silhouette.impl.providers.state.CsrfStateItem$;
import play.silhouette.impl.providers.state.CsrfStateItemHandler$;
import play.silhouette.impl.providers.state.CsrfStateSettings;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003H\u0001\u0011\u0005\u0001*\u0002\u0003W\u0001\u0001:\u0006\"\u0002.\u0001\t\u0003Z\u0006\"B5\u0001\t\u0003R\u0007\"B5\u0001\t\u0003\u0012\bbBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!!\u001e\u0001\t\u0013\t9hB\u0004\u0002\fVA\t!!$\u0007\rQ)\u0002\u0012AAH\u0011\u00199e\u0002\"\u0001\u0002\u0012\"I\u00111\u0013\bC\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003Os\u0001\u0015!\u0003\u0002\u0018\"I\u0011\u0011\u0016\bC\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003Ws\u0001\u0015!\u0003\u0002\u0018\n!2i\u001d:g'R\fG/Z%uK6D\u0015M\u001c3mKJT!AF\f\u0002\u000bM$\u0018\r^3\u000b\u0005aI\u0012!\u00039s_ZLG-\u001a:t\u0015\tQ2$\u0001\u0003j[Bd'B\u0001\u000f\u001e\u0003)\u0019\u0018\u000e\u001c5pk\u0016$H/\u001a\u0006\u0002=\u0005!\u0001\u000f\\1z\u0007\u0001\u0019R\u0001A\u0011(WE\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u00059\u0012B\u0001\u0016\u0018\u0005Y\u0019vnY5bYN#\u0018\r^3Ji\u0016l\u0007*\u00198eY\u0016\u0014\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001c\u0003\r\t\u0007/[\u0005\u0003a5\u0012a\u0001T8hO\u0016\u0014\bC\u0001\u00153\u0013\t\u0019tCA\u0011Qk\nd\u0017n\u001d5bE2,7k\\2jC2\u001cF/\u0019;f\u0013R,W\u000eS1oI2,'/\u0001\u0005tKR$\u0018N\\4t!\t1t'D\u0001\u0016\u0013\tATCA\tDgJ47\u000b^1uKN+G\u000f^5oON\f1\"\u001b3HK:,'/\u0019;peB\u00111HP\u0007\u0002y)\u0011Q(L\u0001\u0005kRLG.\u0003\u0002@y\tY\u0011\nR$f]\u0016\u0014\u0018\r^8s\u0003\u0019\u0019\u0018n\u001a8feB\u0011!)R\u0007\u0002\u0007*\u0011A)L\u0001\u0007GJL\b\u000f^8\n\u0005\u0019\u001b%AB*jO:,'/\u0001\u0004=S:LGO\u0010\u000b\u0005\u0013*[E\n\u0005\u00027\u0001!)A\u0007\u0002a\u0001k!)\u0011\b\u0002a\u0001u!)\u0001\t\u0002a\u0001\u0003\"\u0012AA\u0014\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000ba!\u001b8kK\u000e$(\"A*\u0002\u000b)\fg/\u0019=\n\u0005U\u0003&AB%oU\u0016\u001cGO\u0001\u0003Ji\u0016l\u0007C\u0001\u001cY\u0013\tIVCA\u0007DgJ47\u000b^1uK&#X-\\\u0001\u0005SR,W\u000e\u0006\u0002]IB\u0019Q\f\u00192\u000e\u0003yS!aX\u0012\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002b=\n1a)\u001e;ve\u0016\u0004\"aY\u0003\u000e\u0003\u0001AQ!\u001a\u0004A\u0004\u0019\f!!Z2\u0011\u0005u;\u0017B\u00015_\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0005dC:D\u0015M\u001c3mKR\u00111N\u001c\t\u0004E1\u0014\u0017BA7$\u0005\u0019y\u0005\u000f^5p]\")!l\u0002a\u0001_B\u0011\u0001\u0006]\u0005\u0003c^\u0011qbU8dS\u0006d7\u000b^1uK&#X-\\\u000b\u0003g~$2\u0001^A\t)\t)\b\u0010\u0005\u0002#m&\u0011qo\t\u0002\b\u0005>|G.Z1o\u0011\u0015I\b\u0002q\u0001{\u0003\u001d\u0011X-];fgR\u00042aO>~\u0013\taHH\u0001\nFqR\u0014\u0018m\u0019;bE2,'+Z9vKN$\bC\u0001@\u0000\u0019\u0001!q!!\u0001\t\u0005\u0004\t\u0019AA\u0001C#\u0011\t)!a\u0003\u0011\u0007\t\n9!C\u0002\u0002\n\r\u0012qAT8uQ&tw\rE\u0002#\u0003\u001bI1!a\u0004$\u0005\r\te.\u001f\u0005\u00075\"\u0001\r!a\u0005\u0011\t\u0005U\u0011\u0011\u0007\b\u0005\u0003/\tiC\u0004\u0003\u0002\u001a\u0005-b\u0002BA\u000e\u0003SqA!!\b\u0002(9!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$}\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\tA\u0012$C\u0002\u00020]\tqbU8dS\u0006d7\u000b^1uK&#X-\\\u0005\u0005\u0003g\t)DA\u0007Ji\u0016l7\u000b\u001e:vGR,(/\u001a\u0006\u0004\u0003_9\u0012!C:fe&\fG.\u001b>f)\u0011\t\u0019\"a\u000f\t\u000biK\u0001\u0019\u00012\u0002\u0017Ut7/\u001a:jC2L'0Z\u000b\u0005\u0003\u0003\nY\u0005\u0006\u0003\u0002D\u0005=C#\u0002/\u0002F\u00055\u0003BB=\u000b\u0001\b\t9\u0005\u0005\u0003<w\u0006%\u0003c\u0001@\u0002L\u00119\u0011\u0011\u0001\u0006C\u0002\u0005\r\u0001\"B3\u000b\u0001\b1\u0007B\u0002.\u000b\u0001\u0004\t\u0019\"A\u0004qk\nd\u0017n\u001d5\u0016\t\u0005U\u0013Q\u000e\u000b\u0007\u0003/\ny'!\u001d\u0015\t\u0005e\u0013q\r\t\u0005\u00037\n\u0019'\u0004\u0002\u0002^)!\u0011qLA1\u0003\rigo\u0019\u0006\u0003]uIA!!\u001a\u0002^\t1!+Z:vYRDa!_\u0006A\u0004\u0005%\u0004\u0003B\u001e|\u0003W\u00022A`A7\t\u001d\t\ta\u0003b\u0001\u0003\u0007AQAW\u0006A\u0002\tDq!a\u001d\f\u0001\u0004\tI&\u0001\u0004sKN,H\u000e^\u0001\fG2LWM\u001c;Ti\u0006$X\r\u0006\u0003\u0002z\u0005\r\u0005#BA>\u0003\u007f\u0012WBAA?\u0015\ti4%\u0003\u0003\u0002\u0002\u0006u$a\u0001+ss\"1\u0011\u0010\u0004a\u0002\u0003\u000b\u0003B!a\u0017\u0002\b&!\u0011\u0011RA/\u00055\u0011V-];fgRDU-\u00193fe\u0006!2i\u001d:g'R\fG/Z%uK6D\u0015M\u001c3mKJ\u0004\"A\u000e\b\u0014\u00059\tCCAAG\u0003\tIE)\u0006\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015\u0001\u00027b]\u001eT!!!)\u0002\t)\fg/Y\u0005\u0005\u0003K\u000bYJ\u0001\u0004TiJLgnZ\u0001\u0004\u0013\u0012\u0003\u0013\u0001G\"mS\u0016tGo\u0015;bi\u0016$u.Z:O_R,\u00050[:ug\u0006I2\t\\5f]R\u001cF/\u0019;f\t>,7OT8u\u000bbL7\u000f^:!\u0001")
public class CsrfStateItemHandler
implements SocialStateItemHandler,
Logger,
PublishableSocialStateItemHandler {
    private final CsrfStateSettings settings;
    private final IDGenerator idGenerator;
    private final Signer signer;
    private play.api.Logger logger;

    public static String ClientStateDoesNotExists() {
        return CsrfStateItemHandler$.MODULE$.ClientStateDoesNotExists();
    }

    public static String ID() {
        return CsrfStateItemHandler$.MODULE$.ID();
    }

    @Override
    public play.api.Logger logger() {
        return this.logger;
    }

    @Override
    public void play$silhouette$api$Logger$_setter_$logger_$eq(play.api.Logger x$1) {
        this.logger = x$1;
    }

    public Future<CsrfStateItem> item(ExecutionContext ec) {
        return this.idGenerator.generate().map((Function1 & Serializable)token -> new CsrfStateItem((String)token), ec);
    }

    public Option<CsrfStateItem> canHandle(SocialStateItem item) {
        SocialStateItem socialStateItem = item;
        if (socialStateItem instanceof CsrfStateItem) {
            CsrfStateItem csrfStateItem = (CsrfStateItem)socialStateItem;
            return new Some((Object)csrfStateItem);
        }
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <B> boolean canHandle(SocialStateItem.ItemStructure item, ExtractableRequest<B> request) {
        Try<CsrfStateItem> try_;
        String string = item.id();
        String string2 = CsrfStateItemHandler$.MODULE$.ID();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if ((try_ = this.clientState((RequestHeader)request)) instanceof Success) {
            CsrfStateItem i;
            Success success = (Success)try_;
            CsrfStateItem csrfStateItem = i = (CsrfStateItem)success.value();
            Object object = item.data().as(CsrfStateItem$.MODULE$.csrfFormat());
            if (csrfStateItem != null) {
                if (!((Object)csrfStateItem).equals(object)) return false;
                return true;
            }
            if (object == null) return true;
            return false;
        }
        if (!(try_ instanceof Failure)) throw new MatchError(try_);
        Failure failure = (Failure)try_;
        Throwable e = failure.exception();
        this.logger().warn((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
        return false;
    }

    public SocialStateItem.ItemStructure serialize(CsrfStateItem item) {
        return new SocialStateItem.ItemStructure(CsrfStateItemHandler$.MODULE$.ID(), Json$.MODULE$.toJson((Object)item, CsrfStateItem$.MODULE$.csrfFormat()));
    }

    public <B> Future<CsrfStateItem> unserialize(SocialStateItem.ItemStructure item, ExtractableRequest<B> request, ExecutionContext ec) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> (CsrfStateItem)item.data().as(CsrfStateItem$.MODULE$.csrfFormat())));
    }

    public <B> Result publish(CsrfStateItem item, Result result, ExtractableRequest<B> request) {
        return result.withCookies((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cookie[]{new Cookie(this.settings.cookieName(), this.signer.sign(item.token()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)((int)this.settings.expirationTime().toSeconds()))), this.settings.cookiePath(), this.settings.cookieDomain(), this.settings.secureCookie(), this.settings.httpOnlyCookie(), this.settings.sameSite())}));
    }

    private Try<CsrfStateItem> clientState(RequestHeader request) {
        Option option = request.cookies().get(this.settings.cookieName());
        if (option instanceof Some) {
            Some some = (Some)option;
            Cookie cookie = (Cookie)some.value();
            return this.signer.extract(cookie.value()).map((Function1 & Serializable)token -> new CsrfStateItem((String)token));
        }
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)new OAuth2StateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CsrfStateItemHandler$.MODULE$.ClientStateDoesNotExists()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.settings.cookieName()})), OAuth2StateException$.MODULE$.$lessinit$greater$default$2()));
        }
        throw new MatchError((Object)option);
    }

    @Inject
    public CsrfStateItemHandler(CsrfStateSettings settings, IDGenerator idGenerator, Signer signer) {
        this.settings = settings;
        this.idGenerator = idGenerator;
        this.signer = signer;
        Logger.$init$(this);
        Statics.releaseFence();
    }
}

