/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.authenticators;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.Verification;
import java.io.Serializable;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsArray$;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.silhouette.api.LoginInfo;
import play.silhouette.api.LoginInfo$;
import play.silhouette.api.crypto.AuthenticatorEncoder;
import play.silhouette.api.exceptions.AuthenticatorException;
import play.silhouette.api.exceptions.AuthenticatorException$;
import play.silhouette.impl.authenticators.JWTAuthenticator;
import play.silhouette.impl.authenticators.JWTAuthenticatorService$;
import play.silhouette.impl.authenticators.JWTAuthenticatorSettings;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JWTAuthenticator$
implements Serializable {
    public static final JWTAuthenticator$ MODULE$ = new JWTAuthenticator$();

    public Option<JsObject> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public String serialize(JWTAuthenticator authenticator, AuthenticatorEncoder authenticatorEncoder, JWTAuthenticatorSettings settings) {
        String subject = Json$.MODULE$.toJson((Object)authenticator.loginInfo(), LoginInfo$.MODULE$.jsonFormat()).toString();
        JWTCreator.Builder jwtBuilder = JWT.create().withJWTId(authenticator.id()).withIssuer(settings.issuerClaim()).withSubject(authenticatorEncoder.encode(subject)).withIssuedAt(Date.from(authenticator.lastUsedDateTime().toInstant())).withExpiresAt(Date.from(authenticator.expirationDateTime().toInstant()));
        authenticator.customClaims().foreach((Function1 & Serializable)data -> {
            JWTAuthenticator$.$anonfun$serialize$1(jwtBuilder, data);
            return BoxedUnit.UNIT;
        });
        return jwtBuilder.sign(Algorithm.HMAC256((String)settings.sharedSecret()));
    }

    public Try<JWTAuthenticator> unserialize(String str, AuthenticatorEncoder authenticatorEncoder, JWTAuthenticatorSettings settings, Option<play.silhouette.api.util.Clock> clock) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Verification verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)settings.sharedSecret())).withIssuer(settings.issuerClaim());
            Option option = clock;
            if (None$.MODULE$.equals(option)) {
                return verifier.build().verify(str);
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                play.silhouette.api.util.Clock cl = (play.silhouette.api.util.Clock)some.value();
                return ((JWTVerifier.BaseVerification)verifier).build(Clock.fixed(cl.now().toInstant(), cl.now().getZone())).verify(str);
            }
            throw new MatchError((Object)option);
        }).flatMap((Function1 & Serializable)c -> {
            String subject = authenticatorEncoder.decode(c.getSubject());
            return MODULE$.buildLoginInfo(subject).map((Function1 & Serializable)loginInfo -> {
                scala.collection.mutable.Map filteredClaims = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(c.getClaims()).asScala().filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)JWTAuthenticator$.$anonfun$unserialize$4(x0$1)));
                JsObject customClaims = MODULE$.unserializeCustomClaims(CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)filteredClaims.map((Function1 & Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), ((Claim)kv._2()).as(Object.class)))).asJava());
                return new JWTAuthenticator(c.getId(), (LoginInfo)loginInfo, ZonedDateTime.ofInstant(c.getIssuedAt().toInstant(), ZoneId.systemDefault()), ZonedDateTime.ofInstant(c.getExpiresAt().toInstant(), ZoneId.systemDefault()), settings.authenticatorIdleTimeout(), (Option<JsObject>)(customClaims.keys().isEmpty() ? None$.MODULE$ : new Some((Object)customClaims)));
            });
        }).recover((PartialFunction)new Serializable(str){
            private static final long serialVersionUID = 0L;
            private final String str$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.InvalidJWTToken()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.str$1})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.str$1 = str$1;
            }
        });
    }

    public Option<play.silhouette.api.util.Clock> unserialize$default$4(String str, AuthenticatorEncoder authenticatorEncoder, JWTAuthenticatorSettings settings) {
        return None$.MODULE$;
    }

    private java.util.Map<String, Object> serializeCustomClaims(JsObject claims) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)claims.fieldSet().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                JsValue value = (JsValue)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), this.toJava$1(value));
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    private JsObject unserializeCustomClaims(java.util.Map<String, Object> claims) {
        return JsObject$.MODULE$.apply((Seq)CollectionConverters$.MODULE$.MapHasAsScala(claims).asScala().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Object value = tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)this.toJson$1(value));
            }
            throw new MatchError((Object)tuple2);
        }).toSeq());
    }

    private Try<LoginInfo> buildLoginInfo(String str) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Json$.MODULE$.parse(str));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JsValue json = (JsValue)success.value();
            return new Success(json.as(LoginInfo$.MODULE$.jsonFormat()));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            return new Failure((Throwable)new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.JsonParseError()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), str})), (Option<Throwable>)new Some((Object)error)));
        }
        throw new MatchError((Object)try_);
    }

    public JWTAuthenticator apply(String id, LoginInfo loginInfo, ZonedDateTime lastUsedDateTime, ZonedDateTime expirationDateTime, Option<FiniteDuration> idleTimeout, Option<JsObject> customClaims) {
        return new JWTAuthenticator(id, loginInfo, lastUsedDateTime, expirationDateTime, idleTimeout, customClaims);
    }

    public Option<JsObject> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<Tuple6<String, LoginInfo, ZonedDateTime, ZonedDateTime, Option<FiniteDuration>, Option<JsObject>>> unapply(JWTAuthenticator x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.id(), (Object)x$0.loginInfo(), (Object)x$0.lastUsedDateTime(), (Object)x$0.expirationDateTime(), x$0.idleTimeout(), x$0.customClaims()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JWTAuthenticator$.class);
    }

    public static final /* synthetic */ void $anonfun$serialize$1(JWTCreator.Builder jwtBuilder$1, JsObject data) {
        CollectionConverters$.MODULE$.MapHasAsScala(MODULE$.serializeCustomClaims(data)).asScala().foreach((Function1 & Serializable)keyVal -> {
            if (JWTAuthenticatorService$.MODULE$.ReservedClaims().contains(keyVal._1())) {
                throw new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.OverrideReservedClaim()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), keyVal._1(), JWTAuthenticatorService$.MODULE$.ReservedClaims().mkString(", ")})), AuthenticatorException$.MODULE$.$lessinit$greater$default$2());
            }
            Object object = keyVal._2();
            if (object instanceof String) {
                String string = (String)object;
                return jwtBuilder$1.withClaim((String)keyVal._1(), string);
            }
            if (object instanceof Double) {
                Double d = (Double)object;
                return jwtBuilder$1.withClaim((String)keyVal._1(), d);
            }
            if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                return jwtBuilder$1.withClaim((String)keyVal._1(), bl);
            }
            if (object instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object;
                return jwtBuilder$1.withClaim((String)keyVal._1(), map);
            }
            if (object instanceof List) {
                List list = (List)object;
                return jwtBuilder$1.withClaim((String)keyVal._1(), list);
            }
            throw new IllegalArgumentException("Claim value format not supported.");
        });
    }

    public static final /* synthetic */ boolean $anonfun$unserialize$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            Claim v = (Claim)tuple2._2();
            return JWTAuthenticatorService$.MODULE$.ReservedClaims().contains((Object)k) || v == null;
        }
        throw new MatchError((Object)tuple2);
    }

    private final Object toJava$1(JsValue value2) {
        JsValue jsValue = value2;
        if (jsValue instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            return jsString.value();
        }
        if (jsValue instanceof JsNumber) {
            JsNumber jsNumber = (JsNumber)jsValue;
            return BoxesRunTime.boxToDouble((double)jsNumber.value().toDouble());
        }
        if (jsValue instanceof JsBoolean) {
            JsBoolean jsBoolean = (JsBoolean)jsValue;
            return BoxesRunTime.boxToBoolean((boolean)jsBoolean.value());
        }
        if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            return this.serializeCustomClaims(jsObject);
        }
        if (jsValue instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)jsArray.value().map((Function1 & Serializable)value -> this.toJava$1((JsValue)value))).asJava();
        }
        throw new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.UnexpectedJsonValue()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), jsValue})), AuthenticatorException$.MODULE$.$lessinit$greater$default$2());
    }

    private final JsValue toJson$1(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return new JsString(string);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return new JsNumber(package$.MODULE$.BigDecimal().apply(number.toString()));
        }
        if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            return JsBoolean$.MODULE$.apply(Predef$.MODULE$.Boolean2boolean(bl));
        }
        if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            return this.unserializeCustomClaims(map);
        }
        if (object instanceof List) {
            List list = (List)object;
            return JsArray$.MODULE$.apply((Seq)CollectionConverters$.MODULE$.ListHasAsScala(list).asScala().map((Function1 & Serializable)value -> this.toJson$1(value)));
        }
        throw new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(JWTAuthenticatorService$.MODULE$.UnexpectedJsonValue()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), object})), AuthenticatorException$.MODULE$.$lessinit$greater$default$2());
    }

    private JWTAuthenticator$() {
    }
}

