/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.authenticators;

import java.io.Serializable;
import java.time.ZonedDateTime;
import play.api.Logger;
import play.api.MarkerContext$;
import play.api.libs.json.JsObject;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.silhouette.api.Authenticator$Implicits$;
import play.silhouette.api.LoginInfo;
import play.silhouette.api.crypto.AuthenticatorEncoder;
import play.silhouette.api.exceptions.AuthenticatorCreationException;
import play.silhouette.api.exceptions.AuthenticatorDiscardingException;
import play.silhouette.api.exceptions.AuthenticatorInitializationException;
import play.silhouette.api.exceptions.AuthenticatorRenewalException;
import play.silhouette.api.exceptions.AuthenticatorRetrievalException;
import play.silhouette.api.exceptions.AuthenticatorUpdateException;
import play.silhouette.api.repositories.AuthenticatorRepository;
import play.silhouette.api.services.AuthenticatorResult;
import play.silhouette.api.services.AuthenticatorResult$;
import play.silhouette.api.services.AuthenticatorService;
import play.silhouette.api.services.AuthenticatorService$;
import play.silhouette.api.util.Clock;
import play.silhouette.api.util.ExtractableRequest;
import play.silhouette.api.util.IDGenerator;
import play.silhouette.impl.authenticators.JWTAuthenticator;
import play.silhouette.impl.authenticators.JWTAuthenticator$;
import play.silhouette.impl.authenticators.JWTAuthenticatorService$;
import play.silhouette.impl.authenticators.JWTAuthenticatorSettings;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001B\u0012%\u00015B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002\u00033\u0001\u0005\u000b\u0007I1A3\t\u00111\u0004!\u0011!Q\u0001\n\u0019DQ!\u001c\u0001\u0005\u00029DQa\u001e\u0001\u0005\naDq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005}\u0003\u0001\"\u0011\u0002b!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA7\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u001d\tI\u000b\u0001C!\u0003WCq!!.\u0001\t\u0003\n9\fC\u0004\u00026\u0002!\t%!7\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\u001e9\u0011q\u001e\u0013\t\u0002\u0005EhAB\u0012%\u0011\u0003\t\u0019\u0010\u0003\u0004n+\u0011\u0005\u0011Q\u001f\u0005\n\u0003o,\"\u0019!C\u0001\u0003sD\u0001\"a@\u0016A\u0003%\u00111 \u0005\n\u0005\u0003)\"\u0019!C\u0001\u0003sD\u0001Ba\u0001\u0016A\u0003%\u00111 \u0005\n\u0005\u000b)\"\u0019!C\u0001\u0003sD\u0001Ba\u0002\u0016A\u0003%\u00111 \u0005\n\u0005\u0013)\"\u0019!C\u0001\u0003sD\u0001Ba\u0003\u0016A\u0003%\u00111 \u0005\n\u0005\u001b)\"\u0019!C\u0001\u0003sD\u0001Ba\u0004\u0016A\u0003%\u00111 \u0005\n\u0005#)\"\u0019!C\u0001\u0005'A\u0001Ba\u0007\u0016A\u0003%!Q\u0003\u0002\u0018\u0015^#\u0016)\u001e;iK:$\u0018nY1u_J\u001cVM\u001d<jG\u0016T!!\n\u0014\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sg*\u0011q\u0005K\u0001\u0005S6\u0004HN\u0003\u0002*U\u0005Q1/\u001b7i_V,G\u000f^3\u000b\u0003-\nA\u0001\u001d7bs\u000e\u00011\u0003\u0002\u0001/i\u0001\u0003\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007cA\u001b;y5\taG\u0003\u00028q\u0005A1/\u001a:wS\u000e,7O\u0003\u0002:Q\u0005\u0019\u0011\r]5\n\u0005m2$\u0001F!vi\",g\u000e^5dCR|'oU3sm&\u001cW\r\u0005\u0002>}5\tA%\u0003\u0002@I\t\u0001\"j\u0016+BkRDWM\u001c;jG\u0006$xN\u001d\t\u0003\u0003\nk\u0011\u0001O\u0005\u0003\u0007b\u0012a\u0001T8hO\u0016\u0014\u0018\u0001C:fiRLgnZ:\u0011\u0005u2\u0015BA$%\u0005aQu\u000bV!vi\",g\u000e^5dCR|'oU3ui&twm]\u0001\u000be\u0016\u0004xn]5u_JL\bcA\u0018K\u0019&\u00111\n\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00075\u0003F(D\u0001O\u0015\ty\u0005(\u0001\u0007sKB|7/\u001b;pe&,7/\u0003\u0002R\u001d\n9\u0012)\u001e;iK:$\u0018nY1u_J\u0014V\r]8tSR|'/_\u0001\u0015CV$\b.\u001a8uS\u000e\fGo\u001c:F]\u000e|G-\u001a:\u0011\u0005Q;V\"A+\u000b\u0005YC\u0014AB2ssB$x.\u0003\u0002Y+\n!\u0012)\u001e;iK:$\u0018nY1u_J,enY8eKJ\f1\"\u001b3HK:,'/\u0019;peB\u00111LX\u0007\u00029*\u0011Q\fO\u0001\u0005kRLG.\u0003\u0002`9\nY\u0011\nR$f]\u0016\u0014\u0018\r^8s\u0003\u0015\u0019Gn\\2l!\tY&-\u0003\u0002d9\n)1\t\\8dW\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002MB\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eM\u0001\u000bG>t7-\u001e:sK:$\u0018BA6i\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\na\u0001P5oSRtDCB8sgR,h\u000f\u0006\u0002qcB\u0011Q\b\u0001\u0005\u0006I\"\u0001\u001dA\u001a\u0005\u0006\t\"\u0001\r!\u0012\u0005\u0006\u0011\"\u0001\r!\u0013\u0005\u0006%\"\u0001\ra\u0015\u0005\u00063\"\u0001\rA\u0017\u0005\u0006A\"\u0001\r!Y\u0001\u000ba\u0006\u00148/\u001a,bYV,GcA=\u0002\fA\u0019qF\u0013>\u0011\u0007m\f)AD\u0002}\u0003\u0003\u0001\"! \u0019\u000e\u0003yT!a \u0017\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019\u0001M\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r\u0001\u0007\u0003\u0004\u0002\u000e%\u0001\rA_\u0001\u0004e\u0006<\u0018AB2sK\u0006$X\r\u0006\u0003\u0002\u0014\u00055B\u0003BA\u000b\u00037\u0001BaZA\fy%\u0019\u0011\u0011\u00045\u0003\r\u0019+H/\u001e:f\u0011\u001d\tiB\u0003a\u0002\u0003?\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\"\u0005%RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0007548M\u0003\u0002:U%!\u00111FA\u0012\u00055\u0011V-];fgRDU-\u00193fe\"9\u0011q\u0006\u0006A\u0002\u0005E\u0012!\u00037pO&t\u0017J\u001c4p!\r\t\u00151G\u0005\u0004\u0003kA$!\u0003'pO&t\u0017J\u001c4p\u0003!\u0011X\r\u001e:jKZ,W\u0003BA\u001e\u0003\u001b\"B!!\u0010\u0002BA)q-a\u0006\u0002@A\u0019qF\u0013\u001f\t\u000f\u0005u1\u0002q\u0001\u0002DA)1,!\u0012\u0002J%\u0019\u0011q\t/\u0003%\u0015CHO]1di\u0006\u0014G.\u001a*fcV,7\u000f\u001e\t\u0005\u0003\u0017\ni\u0005\u0004\u0001\u0005\u000f\u0005=3B1\u0001\u0002R\t\t!)\u0005\u0003\u0002T\u0005e\u0003cA\u0018\u0002V%\u0019\u0011q\u000b\u0019\u0003\u000f9{G\u000f[5oOB\u0019q&a\u0017\n\u0007\u0005u\u0003GA\u0002B]f\fA!\u001b8jiR!\u00111MA5)\u0011\t)'a\u001a\u0011\t\u001d\f9B\u001f\u0005\b\u0003;a\u00019AA\u0010\u0011\u0019\tY\u0007\u0004a\u0001y\u0005i\u0011-\u001e;iK:$\u0018nY1u_J\fQ!Z7cK\u0012$b!!\u001d\u0002~\u0005\u0005E\u0003BA:\u0003w\u0002RaZA\f\u0003k\u00022!NA<\u0013\r\tIH\u000e\u0002\u0014\u0003V$\b.\u001a8uS\u000e\fGo\u001c:SKN,H\u000e\u001e\u0005\b\u0003;i\u00019AA\u0010\u0011\u0019\ty(\u0004a\u0001u\u0006)Ao\\6f]\"9\u00111Q\u0007A\u0002\u0005\u0015\u0015A\u0002:fgVdG\u000f\u0005\u0003\u0002\"\u0005\u001d\u0015\u0002BAE\u0003G\u0011aAU3tk2$HCBA\u0010\u0003\u001b\u000by\t\u0003\u0004\u0002\u00009\u0001\rA\u001f\u0005\b\u0003;q\u0001\u0019AA\u0010\u0003\u0015!x.^2i)\u0011\t)*a*\u0011\r\u0005]\u0015\u0011\u0015\u001f=\u001d\u0011\tI*!(\u000f\u0007u\fY*C\u00012\u0013\r\ty\nM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019+!*\u0003\r\u0015KG\u000f[3s\u0015\r\ty\n\r\u0005\u0007\u0003Wz\u0001\u0019\u0001\u001f\u0002\rU\u0004H-\u0019;f)\u0019\ti+!-\u00024R!\u00111OAX\u0011\u001d\ti\u0002\u0005a\u0002\u0003?Aa!a\u001b\u0011\u0001\u0004a\u0004bBAB!\u0001\u0007\u0011QQ\u0001\u0006e\u0016tWm\u001e\u000b\u0005\u0003s\u000bi\f\u0006\u0003\u0002f\u0005m\u0006bBA\u000f#\u0001\u000f\u0011q\u0004\u0005\u0007\u0003W\n\u0002\u0019\u0001\u001f)\u000fE\t\t-!5\u0002TB!\u00111YAg\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017\u0001\u00027b]\u001eT!!a3\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\f)M\u0001\tTkB\u0004(/Z:t/\u0006\u0014h.\u001b8hg\u0006)a/\u00197vK2\u0012\u0011Q[\u0011\u0003\u0003/\f\u0011CV1sS\u0006\u0014G.Z*iC\u0012|w/\u001b8h)\u0019\tY.a8\u0002bR!\u00111OAo\u0011\u001d\tiB\u0005a\u0002\u0003?Aa!a\u001b\u0013\u0001\u0004a\u0004bBAB%\u0001\u0007\u0011QQ\u0001\bI&\u001c8-\u0019:e)\u0019\t9/a;\u0002nR!\u00111OAu\u0011\u001d\tib\u0005a\u0002\u0003?Aa!a\u001b\u0014\u0001\u0004a\u0004bBAB'\u0001\u0007\u0011QQ\u0001\u0018\u0015^#\u0016)\u001e;iK:$\u0018nY1u_J\u001cVM\u001d<jG\u0016\u0004\"!P\u000b\u0014\u0005UqCCAAy\u0003\tIE)\u0006\u0002\u0002|B!\u00111YA\u007f\u0013\u0011\t9!!2\u0002\u0007%#\u0005%A\bJ]Z\fG.\u001b3K/R#vn[3o\u0003AIeN^1mS\u0012Tu\u000b\u0016+pW\u0016t\u0007%\u0001\bKg>t\u0007+\u0019:tK\u0016\u0013(o\u001c:\u0002\u001f)\u001bxN\u001c)beN,WI\u001d:pe\u0002\n1#\u00168fqB,7\r^3e\u0015N|gNV1mk\u0016\fA#\u00168fqB,7\r^3e\u0015N|gNV1mk\u0016\u0004\u0013!F(wKJ\u0014\u0018\u000eZ3SKN,'O^3e\u00072\f\u0017.\\\u0001\u0017\u001fZ,'O]5eKJ+7/\u001a:wK\u0012\u001cE.Y5nA\u0005q!+Z:feZ,Gm\u00117bS6\u001cXC\u0001B\u000b!\u0015\t9Ja\u0006{\u0013\u0011\u0011I\"!*\u0003\u0007M+\u0017/A\bSKN,'O^3e\u00072\f\u0017.\\:!\u0001")
public class JWTAuthenticatorService
implements AuthenticatorService<JWTAuthenticator>,
play.silhouette.api.Logger {
    private final JWTAuthenticatorSettings settings;
    private final Option<AuthenticatorRepository<JWTAuthenticator>> repository;
    private final AuthenticatorEncoder authenticatorEncoder;
    private final IDGenerator idGenerator;
    private final Clock clock;
    private final ExecutionContext executionContext;
    private Logger logger;

    public static Seq<String> ReservedClaims() {
        return JWTAuthenticatorService$.MODULE$.ReservedClaims();
    }

    public static String OverrideReservedClaim() {
        return JWTAuthenticatorService$.MODULE$.OverrideReservedClaim();
    }

    public static String UnexpectedJsonValue() {
        return JWTAuthenticatorService$.MODULE$.UnexpectedJsonValue();
    }

    public static String JsonParseError() {
        return JWTAuthenticatorService$.MODULE$.JsonParseError();
    }

    public static String InvalidJWTToken() {
        return JWTAuthenticatorService$.MODULE$.InvalidJWTToken();
    }

    public static String ID() {
        return JWTAuthenticatorService$.MODULE$.ID();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void play$silhouette$api$Logger$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    private Option<String> parseValue(String raw) {
        return this.settings.valueParser().parseValue(raw);
    }

    @Override
    public Future<JWTAuthenticator> create(LoginInfo loginInfo, RequestHeader request) {
        return this.idGenerator.generate().map((Function1 & Serializable)id -> {
            ZonedDateTime now = $this.clock.now();
            return new JWTAuthenticator((String)id, loginInfo, now, Authenticator$Implicits$.MODULE$.RichDateTime(now).$plus($this.settings.authenticatorExpiry()), $this.settings.authenticatorIdleTimeout(), JWTAuthenticator$.MODULE$.apply$default$6());
        }, this.executionContext()).recover((PartialFunction)new Serializable(null, loginInfo){
            private static final long serialVersionUID = 0L;
            private final LoginInfo loginInfo$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorCreationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.CreateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.loginInfo$1})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.loginInfo$1 = loginInfo$1;
            }
        }, this.executionContext());
    }

    @Override
    public <B> Future<Option<JWTAuthenticator>> retrieve(ExtractableRequest<B> request) {
        Option maybeToken = request.extractString(this.settings.fieldName(), this.settings.requestParts()).flatMap((Function1 & Serializable)raw -> this.parseValue((String)raw));
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> maybeToken)).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                String token = (String)some.value();
                Try<JWTAuthenticator> try_ = JWTAuthenticator$.MODULE$.unserialize(token, $this.authenticatorEncoder, $this.settings, (Option<Clock>)new Some((Object)$this.clock));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    JWTAuthenticator authenticator = (JWTAuthenticator)success.value();
                    return (Future)$this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)Option$.MODULE$.apply((Object)authenticator)), (Function1 & Serializable)x$1 -> x$1.find(authenticator.id()));
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.logger().info((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
                    return Future$.MODULE$.successful((Object)None$.MODULE$);
                }
                throw new MatchError(try_);
            }
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRetrievalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RetrieveError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID()})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, this.executionContext());
    }

    @Override
    public Future<String> init(JWTAuthenticator authenticator, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)authenticator), (Function1 & Serializable)x$2 -> x$2.add(authenticator))).map((Function1 & Serializable)a -> JWTAuthenticator$.MODULE$.serialize((JWTAuthenticator)a, $this.authenticatorEncoder, $this.settings), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorInitializationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.InitError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$2})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$2 = authenticator$2;
            }
        }, this.executionContext());
    }

    public Future<AuthenticatorResult> embed(String token, Result result, RequestHeader request) {
        return Future$.MODULE$.successful((Object)AuthenticatorResult$.MODULE$.apply(result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.settings.fieldName()), (Object)token)}))));
    }

    public RequestHeader embed(String token, RequestHeader request) {
        .colon.colon additional = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.settings.fieldName()), (Object)token), (List)Nil$.MODULE$);
        return request.withHeaders(request.headers().replace((Seq)additional));
    }

    @Override
    public Either<JWTAuthenticator, JWTAuthenticator> touch(JWTAuthenticator authenticator) {
        if (authenticator.idleTimeout().isDefined()) {
            ZonedDateTime x$1 = this.clock.now();
            String x$2 = authenticator.copy$default$1();
            LoginInfo x$3 = authenticator.copy$default$2();
            ZonedDateTime x$4 = authenticator.copy$default$4();
            Option<FiniteDuration> x$5 = authenticator.copy$default$5();
            Option<JsObject> x$6 = authenticator.copy$default$6();
            return new Left((Object)authenticator.copy(x$2, x$3, x$1, x$4, x$5, x$6));
        }
        return new Right((Object)authenticator);
    }

    @Override
    public Future<AuthenticatorResult> update(JWTAuthenticator authenticator, Result result, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)authenticator), (Function1 & Serializable)x$3 -> x$3.update(authenticator))).map((Function1 & Serializable)a -> AuthenticatorResult$.MODULE$.apply(result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.settings.fieldName()), (Object)JWTAuthenticator$.MODULE$.serialize((JWTAuthenticator)a, $this.authenticatorEncoder, $this.settings))}))), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorUpdateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.UpdateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$3})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$3 = authenticator$3;
            }
        }, this.executionContext());
    }

    @Override
    public Future<String> renew(JWTAuthenticator authenticator, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT), (Function1 & Serializable)x$4 -> x$4.remove(authenticator.id()))).flatMap((Function1 & Serializable)x$5 -> this.create(authenticator.loginInfo(), request).map((Function1 & Serializable)auth -> {
            Option<JsObject> x$1 = authenticator.customClaims();
            String x$2 = auth.copy$default$1();
            LoginInfo x$3 = auth.copy$default$2();
            ZonedDateTime x$4 = auth.copy$default$3();
            ZonedDateTime x$5 = auth.copy$default$4();
            Option<FiniteDuration> x$6 = auth.copy$default$5();
            return auth.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        }, this.executionContext()).flatMap((Function1 & Serializable)authenticator -> this.init((JWTAuthenticator)authenticator, request), this.executionContext()), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$4})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$4 = authenticator$4;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> renew(JWTAuthenticator authenticator, Result result, RequestHeader request) {
        return this.renew(authenticator, request).flatMap((Function1 & Serializable)v -> this.embed((String)v, result, request), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$5;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$5})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$5 = authenticator$5;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> discard(JWTAuthenticator authenticator, Result result, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT), (Function1 & Serializable)x$6 -> x$6.remove(authenticator.id()))).map((Function1 & Serializable)x$7 -> AuthenticatorResult$.MODULE$.apply(result), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$6;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorDiscardingException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.DiscardError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$6})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$6 = authenticator$6;
            }
        }, this.executionContext());
    }

    public JWTAuthenticatorService(JWTAuthenticatorSettings settings, Option<AuthenticatorRepository<JWTAuthenticator>> repository, AuthenticatorEncoder authenticatorEncoder, IDGenerator idGenerator, Clock clock, ExecutionContext executionContext) {
        this.settings = settings;
        this.repository = repository;
        this.authenticatorEncoder = authenticatorEncoder;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.executionContext = executionContext;
        play.silhouette.api.Logger.$init$(this);
        Statics.releaseFence();
    }
}

