/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.providers;

import jakarta.inject.Inject;
import java.io.Serializable;
import play.silhouette.api.LoginInfo;
import play.silhouette.api.exceptions.ConfigurationException;
import play.silhouette.api.exceptions.ConfigurationException$;
import play.silhouette.api.repositories.AuthInfoRepository;
import play.silhouette.api.util.Credentials;
import play.silhouette.api.util.PasswordHasherRegistry;
import play.silhouette.impl.exceptions.IdentityNotFoundException;
import play.silhouette.impl.exceptions.IdentityNotFoundException$;
import play.silhouette.impl.exceptions.InvalidPasswordException;
import play.silhouette.impl.exceptions.InvalidPasswordException$;
import play.silhouette.impl.providers.CredentialsProvider$;
import play.silhouette.impl.providers.PasswordProvider;
import play.silhouette.impl.providers.PasswordProvider$Authenticated$;
import play.silhouette.impl.providers.PasswordProvider$InvalidPassword$;
import play.silhouette.impl.providers.PasswordProvider$NotFound$;
import play.silhouette.impl.providers.PasswordProvider$UnsupportedHasher$;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005M4A\u0001E\t\u00015!AQ\u0005\u0001BC\u0002\u0013Ea\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u0003(\u0011!\u0001\u0004A!b\u0001\n#\t\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011e\u0002!Q1A\u0005\u0004iB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006%\u0002!\te\u0015\u0005\u00069\u0002!\t!\u0018\u0005\u0006U\u0002!\ta[\u0004\u0006[FA\tA\u001c\u0004\u0006!EA\ta\u001c\u0005\u0006\u00052!\t\u0001\u001d\u0005\bc2\u0011\r\u0011\"\u0001T\u0011\u0019\u0011H\u0002)A\u0005)\n\u00192I]3eK:$\u0018.\u00197t!J|g/\u001b3fe*\u0011!cE\u0001\naJ|g/\u001b3feNT!\u0001F\u000b\u0002\t%l\u0007\u000f\u001c\u0006\u0003-]\t!b]5mQ>,X\r\u001e;f\u0015\u0005A\u0012\u0001\u00029mCf\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012$\u001b\u0005\t\u0012B\u0001\u0013\u0012\u0005A\u0001\u0016m]:x_J$\u0007K]8wS\u0012,'/\u0001\nbkRD\u0017J\u001c4p%\u0016\u0004xn]5u_JLX#A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013\u0001\u0004:fa>\u001c\u0018\u000e^8sS\u0016\u001c(B\u0001\u0017\u0016\u0003\r\t\u0007/[\u0005\u0003]%\u0012!#Q;uQ&sgm\u001c*fa>\u001c\u0018\u000e^8ss\u0006\u0019\u0012-\u001e;i\u0013:4wNU3q_NLGo\u001c:zA\u00051\u0002/Y:to>\u0014H\rS1tQ\u0016\u0014(+Z4jgR\u0014\u00180F\u00013!\t\u0019d'D\u00015\u0015\t)4&\u0001\u0003vi&d\u0017BA\u001c5\u0005Y\u0001\u0016m]:x_J$\u0007*Y:iKJ\u0014VmZ5tiJL\u0018a\u00069bgN<xN\u001d3ICNDWM\u001d*fO&\u001cHO]=!\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001<!\tat(D\u0001>\u0015\tqT$\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001Q\u001f\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA\u00051A(\u001b8jiz\"2\u0001R$I)\t)e\t\u0005\u0002#\u0001!)\u0011h\u0002a\u0002w!)Qe\u0002a\u0001O!)\u0001g\u0002a\u0001e!\u0012qA\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000ba!\u001b8kK\u000e$(\"A(\u0002\u000f)\f7.\u0019:uC&\u0011\u0011\u000b\u0014\u0002\u0007\u0013:TWm\u0019;\u0002\u0005%$W#\u0001+\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016\u0001\u00027b]\u001eT\u0011!W\u0001\u0005U\u00064\u0018-\u0003\u0002\\-\n11\u000b\u001e:j]\u001e\fA\"Y;uQ\u0016tG/[2bi\u0016$\"AX3\u0011\u0007qz\u0016-\u0003\u0002a{\t1a)\u001e;ve\u0016\u0004\"AY2\u000e\u0003-J!\u0001Z\u0016\u0003\u00131{w-\u001b8J]\u001a|\u0007\"\u00024\n\u0001\u00049\u0017aC2sK\u0012,g\u000e^5bYN\u0004\"a\r5\n\u0005%$$aC\"sK\u0012,g\u000e^5bYN\f\u0011\u0002\\8hS:LeNZ8\u0015\u0005yc\u0007\"\u00024\u000b\u0001\u00049\u0017aE\"sK\u0012,g\u000e^5bYN\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u0012\r'\ta1\u0004F\u0001o\u0003\tIE)A\u0002J\t\u0002\u0002")
public class CredentialsProvider
implements PasswordProvider {
    private final AuthInfoRepository authInfoRepository;
    private final PasswordHasherRegistry passwordHasherRegistry;
    private final ExecutionContext executionContext;
    private volatile PasswordProvider$Authenticated$ Authenticated$module;
    private volatile PasswordProvider$InvalidPassword$ InvalidPassword$module;
    private volatile PasswordProvider$UnsupportedHasher$ UnsupportedHasher$module;
    private volatile PasswordProvider$NotFound$ NotFound$module;

    public static String ID() {
        return CredentialsProvider$.MODULE$.ID();
    }

    @Override
    public Future<PasswordProvider.State> authenticate(LoginInfo loginInfo, String password) {
        return PasswordProvider.authenticate$(this, loginInfo, password);
    }

    @Override
    public PasswordProvider$Authenticated$ Authenticated() {
        if (this.Authenticated$module == null) {
            this.Authenticated$lzycompute$1();
        }
        return this.Authenticated$module;
    }

    @Override
    public PasswordProvider$InvalidPassword$ InvalidPassword() {
        if (this.InvalidPassword$module == null) {
            this.InvalidPassword$lzycompute$1();
        }
        return this.InvalidPassword$module;
    }

    @Override
    public PasswordProvider$UnsupportedHasher$ UnsupportedHasher() {
        if (this.UnsupportedHasher$module == null) {
            this.UnsupportedHasher$lzycompute$1();
        }
        return this.UnsupportedHasher$module;
    }

    @Override
    public PasswordProvider$NotFound$ NotFound() {
        if (this.NotFound$module == null) {
            this.NotFound$lzycompute$1();
        }
        return this.NotFound$module;
    }

    @Override
    public AuthInfoRepository authInfoRepository() {
        return this.authInfoRepository;
    }

    @Override
    public PasswordHasherRegistry passwordHasherRegistry() {
        return this.passwordHasherRegistry;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String id() {
        return CredentialsProvider$.MODULE$.ID();
    }

    public Future<LoginInfo> authenticate(Credentials credentials) {
        return this.loginInfo(credentials).flatMap((Function1 & Serializable)loginInfo -> this.authenticate((LoginInfo)loginInfo, credentials.password()).map((Function1 & Serializable)x0$1 -> {
            PasswordProvider.State state = x0$1;
            if (this.Authenticated().equals(state)) {
                return loginInfo;
            }
            if (state instanceof PasswordProvider.InvalidPassword) {
                PasswordProvider.InvalidPassword invalidPassword = (PasswordProvider.InvalidPassword)state;
                String error = invalidPassword.error();
                throw new InvalidPasswordException(error, InvalidPasswordException$.MODULE$.$lessinit$greater$default$2());
            }
            if (state instanceof PasswordProvider.UnsupportedHasher) {
                PasswordProvider.UnsupportedHasher unsupportedHasher = (PasswordProvider.UnsupportedHasher)state;
                String error = unsupportedHasher.error();
                throw new ConfigurationException(error, ConfigurationException$.MODULE$.$lessinit$greater$default$2());
            }
            if (state instanceof PasswordProvider.NotFound) {
                PasswordProvider.NotFound notFound = (PasswordProvider.NotFound)state;
                String error = notFound.error();
                throw new IdentityNotFoundException(error, IdentityNotFoundException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError((Object)state);
        }, this.executionContext()), this.executionContext());
    }

    public Future<LoginInfo> loginInfo(Credentials credentials) {
        return Future$.MODULE$.successful((Object)new LoginInfo(this.id(), credentials.identifier()));
    }

    private final void Authenticated$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.Authenticated$module == null) {
                this.Authenticated$module = new PasswordProvider$Authenticated$(this);
            }
        }
    }

    private final void InvalidPassword$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.InvalidPassword$module == null) {
                this.InvalidPassword$module = new PasswordProvider$InvalidPassword$(this);
            }
        }
    }

    private final void UnsupportedHasher$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.UnsupportedHasher$module == null) {
                this.UnsupportedHasher$module = new PasswordProvider$UnsupportedHasher$(this);
            }
        }
    }

    private final void NotFound$lzycompute$1() {
        CredentialsProvider credentialsProvider = this;
        synchronized (credentialsProvider) {
            if (this.NotFound$module == null) {
                this.NotFound$module = new PasswordProvider$NotFound$(this);
            }
        }
    }

    @Inject
    public CredentialsProvider(AuthInfoRepository authInfoRepository, PasswordHasherRegistry passwordHasherRegistry, ExecutionContext executionContext) {
        this.authInfoRepository = authInfoRepository;
        this.passwordHasherRegistry = passwordHasherRegistry;
        this.executionContext = executionContext;
        PasswordProvider.$init$(this);
    }
}

