/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.providers.oauth1.secrets;

import jakarta.inject.Inject;
import play.api.mvc.Cookie;
import play.api.mvc.Cookie$;
import play.api.mvc.Result;
import play.silhouette.api.crypto.Crypter;
import play.silhouette.api.crypto.Signer;
import play.silhouette.api.util.Clock;
import play.silhouette.api.util.ExtractableRequest;
import play.silhouette.impl.exceptions.OAuth1TokenSecretException;
import play.silhouette.impl.exceptions.OAuth1TokenSecretException$;
import play.silhouette.impl.providers.OAuth1Info;
import play.silhouette.impl.providers.OAuth1TokenSecretProvider;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecret;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecret$;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecretProvider$;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecretSettings;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\f\u0019\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u000b\u0011I\u0006\u0001\t.\t\u000bu\u0003A\u0011\t0\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\u0004\u0001\u0005B\u0005mqaBA 1!\u0005\u0011\u0011\t\u0004\u0007/aA\t!a\u0011\t\r%[A\u0011AA#\u0011%\t9e\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002\\-\u0001\u000b\u0011BA&\u0011%\tif\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002`-\u0001\u000b\u0011BA&\u0011%\t\tg\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002d-\u0001\u000b\u0011BA&\u0011%\t)g\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002h-\u0001\u000b\u0011BA&\u0011%\tIg\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002l-\u0001\u000b\u0011BA&\u0005Q\u0019un\\6jKN+7M]3u!J|g/\u001b3fe*\u0011\u0011DG\u0001\bg\u0016\u001c'/\u001a;t\u0015\tYB$\u0001\u0004pCV$\b.\r\u0006\u0003;y\t\u0011\u0002\u001d:pm&$WM]:\u000b\u0005}\u0001\u0013\u0001B5na2T!!\t\u0012\u0002\u0015MLG\u000e[8vKR$XMC\u0001$\u0003\u0011\u0001H.Y=\u0004\u0001M\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\tic&D\u0001\u001d\u0013\tyCDA\rP\u0003V$\b.\r+pW\u0016t7+Z2sKR\u0004&o\u001c<jI\u0016\u0014\u0018\u0001C:fiRLgnZ:\u0011\u0005I\u001aT\"\u0001\r\n\u0005QB\"\u0001F\"p_.LWmU3de\u0016$8+\u001a;uS:<7/\u0001\u0004tS\u001etWM\u001d\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\naa\u0019:zaR|'BA\u001e!\u0003\r\t\u0007/[\u0005\u0003{a\u0012aaU5h]\u0016\u0014\u0018aB2ssB$XM\u001d\t\u0003o\u0001K!!\u0011\u001d\u0003\u000f\r\u0013\u0018\u0010\u001d;fe\u0006)1\r\\8dWB\u0011AiR\u0007\u0002\u000b*\u0011aIO\u0001\u0005kRLG.\u0003\u0002I\u000b\n)1\t\\8dW\u00061A(\u001b8jiz\"Ra\u0013'N\u001d>\u0003\"A\r\u0001\t\u000bA*\u0001\u0019A\u0019\t\u000bU*\u0001\u0019\u0001\u001c\t\u000by*\u0001\u0019A \t\u000b\t+\u0001\u0019A\")\u0005\u0015\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0019IgN[3di*\ta+A\u0004kC.\f'\u000f^1\n\u0005a\u001b&AB%oU\u0016\u001cGO\u0001\u0004TK\u000e\u0014X\r\u001e\t\u0003emK!\u0001\u0018\r\u0003\u0019\r{wn[5f'\u0016\u001c'/\u001a;\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0005}sGC\u00011})\r\twm\u001e\t\u0004E\u0016TV\"A2\u000b\u0005\u0011D\u0013AC2p]\u000e,(O]3oi&\u0011am\u0019\u0002\u0007\rV$XO]3\t\u000b!<\u00019A5\u0002\u000fI,\u0017/^3tiB\u0019AI\u001b7\n\u0005-,%AE#yiJ\f7\r^1cY\u0016\u0014V-];fgR\u0004\"!\u001c8\r\u0001\u0011)qn\u0002b\u0001a\n\t!)\u0005\u0002riB\u0011qE]\u0005\u0003g\"\u0012qAT8uQ&tw\r\u0005\u0002(k&\u0011a\u000f\u000b\u0002\u0004\u0003:L\b\"\u0002=\b\u0001\bI\u0018AA3d!\t\u0011'0\u0003\u0002|G\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006{\u001e\u0001\rA`\u0001\u0005S:4w\u000e\u0005\u0002.\u007f&\u0019\u0011\u0011\u0001\u000f\u0003\u0015=\u000bU\u000f\u001e52\u0013:4w.\u0001\u0005sKR\u0014\u0018.\u001a<f+\u0011\t9!!\u0006\u0015\r\u0005%\u0011qBA\f!\u0011\u0011W-a\u0003\u0011\u0007\u00055a!D\u0001\u0001\u0011\u0019A\u0007\u0002q\u0001\u0002\u0012A!AI[A\n!\ri\u0017Q\u0003\u0003\u0006_\"\u0011\r\u0001\u001d\u0005\u0006q\"\u0001\u001d!_\u0001\baV\u0014G.[:i+\u0011\ti\"!\u000e\u0015\r\u0005}\u0011qGA\u001e)\u0011\t\t#a\f\u0011\t\u0005\r\u00121F\u0007\u0003\u0003KQA!a\n\u0002*\u0005\u0019QN^2\u000b\u0005m\u0012\u0013\u0002BA\u0017\u0003K\u0011aAU3tk2$\bB\u00025\n\u0001\b\t\t\u0004\u0005\u0003EU\u0006M\u0002cA7\u00026\u0011)q.\u0003b\u0001a\"9\u0011\u0011H\u0005A\u0002\u0005\u0005\u0012A\u0002:fgVdG\u000f\u0003\u0004\u0002>%\u0001\rAW\u0001\u0007g\u0016\u001c'/\u001a;\u0002)\r{wn[5f'\u0016\u001c'/\u001a;Qe>4\u0018\u000eZ3s!\t\u00114b\u0005\u0002\fMQ\u0011\u0011\u0011I\u0001\u001a\u00072LWM\u001c;TK\u000e\u0014X\r\u001e#pKNtu\u000e^#ySN$8/\u0006\u0002\u0002LA!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001\u00027b]\u001eT!!!\u0016\u0002\t)\fg/Y\u0005\u0005\u00033\nyE\u0001\u0004TiJLgnZ\u0001\u001b\u00072LWM\u001c;TK\u000e\u0014X\r\u001e#pKNtu\u000e^#ySN$8\u000fI\u0001\u0010'\u0016\u001c'/\u001a;Jg\u0016C\b/\u001b:fI\u0006\u00012+Z2sKRL5/\u0012=qSJ,G\rI\u0001\f\u0013:4\u0018\r\\5e\u0015N|g.\u0001\u0007J]Z\fG.\u001b3Kg>t\u0007%A\nJ]Z\fG.\u001b3TK\u000e\u0014X\r\u001e$pe6\fG/\u0001\u000bJ]Z\fG.\u001b3TK\u000e\u0014X\r\u001e$pe6\fG\u000fI\u0001\u0017\u0013:4\u0018\r\\5e\u0007>|7.[3TS\u001et\u0017\r^;sK\u00069\u0012J\u001c<bY&$7i\\8lS\u0016\u001c\u0016n\u001a8biV\u0014X\r\t")
public class CookieSecretProvider
implements OAuth1TokenSecretProvider {
    private final CookieSecretSettings settings;
    private final Signer signer;
    private final Crypter crypter;
    private final Clock clock;

    public static String InvalidCookieSignature() {
        return CookieSecretProvider$.MODULE$.InvalidCookieSignature();
    }

    public static String InvalidSecretFormat() {
        return CookieSecretProvider$.MODULE$.InvalidSecretFormat();
    }

    public static String InvalidJson() {
        return CookieSecretProvider$.MODULE$.InvalidJson();
    }

    public static String SecretIsExpired() {
        return CookieSecretProvider$.MODULE$.SecretIsExpired();
    }

    public static String ClientSecretDoesNotExists() {
        return CookieSecretProvider$.MODULE$.ClientSecretDoesNotExists();
    }

    public <B> Future<CookieSecret> build(OAuth1Info info, ExtractableRequest<B> request, ExecutionContext ec) {
        return Future$.MODULE$.successful((Object)new CookieSecret(info.secret(), this.clock.now().plusSeconds((int)this.settings.expirationTime().toSeconds())));
    }

    public <B> Future<CookieSecret> retrieve(ExtractableRequest<B> request, ExecutionContext ec) {
        Option option = request.cookies().get(this.settings.cookieName());
        if (option instanceof Some) {
            Some some = (Some)option;
            Cookie cookie = (Cookie)some.value();
            boolean bl = false;
            Success success = null;
            Try<CookieSecret> try_ = CookieSecret$.MODULE$.unserialize(cookie.value(), this.signer, this.crypter);
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                CookieSecret secret = (CookieSecret)success.value();
                if (secret.isExpired()) {
                    return Future$.MODULE$.failed((Throwable)new OAuth1TokenSecretException(CookieSecretProvider$.MODULE$.SecretIsExpired(), OAuth1TokenSecretException$.MODULE$.$lessinit$greater$default$2()));
                }
            }
            if (bl) {
                CookieSecret secret = (CookieSecret)success.value();
                return Future$.MODULE$.successful((Object)secret);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                return Future$.MODULE$.failed(error);
            }
            throw new MatchError(try_);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.failed((Throwable)new OAuth1TokenSecretException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieSecretProvider$.MODULE$.ClientSecretDoesNotExists()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.settings.cookieName()})), OAuth1TokenSecretException$.MODULE$.$lessinit$greater$default$2()));
        }
        throw new MatchError((Object)option);
    }

    public <B> Result publish(Result result, CookieSecret secret, ExtractableRequest<B> request) {
        return result.withCookies((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cookie[]{new Cookie(this.settings.cookieName(), CookieSecret$.MODULE$.serialize(secret, this.signer, this.crypter), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)((int)this.settings.expirationTime().toSeconds()))), this.settings.cookiePath(), this.settings.cookieDomain(), this.settings.secureCookie(), this.settings.httpOnlyCookie(), this.settings.sameSite(), Cookie$.MODULE$.apply$default$9())}));
    }

    @Inject
    public CookieSecretProvider(CookieSecretSettings settings, Signer signer, Crypter crypter, Clock clock) {
        this.settings = settings;
        this.signer = signer;
        this.crypter = crypter;
        this.clock = clock;
    }
}

