/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.providers.state;

import jakarta.inject.Inject;
import java.io.Serializable;
import play.api.MarkerContext$;
import play.api.libs.json.Json$;
import play.api.mvc.Cookie;
import play.api.mvc.Cookie$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.silhouette.api.Logger;
import play.silhouette.api.crypto.Signer;
import play.silhouette.api.util.ExtractableRequest;
import play.silhouette.api.util.IDGenerator;
import play.silhouette.impl.exceptions.OAuth2StateException;
import play.silhouette.impl.exceptions.OAuth2StateException$;
import play.silhouette.impl.providers.PublishableSocialStateItemHandler;
import play.silhouette.impl.providers.SocialStateItem;
import play.silhouette.impl.providers.SocialStateItemHandler;
import play.silhouette.impl.providers.state.CsrfStateItem;
import play.silhouette.impl.providers.state.CsrfStateItem$;
import play.silhouette.impl.providers.state.CsrfStateItemHandler$;
import play.silhouette.impl.providers.state.CsrfStateSettings;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0003H\u0001\u0011\u0005\u0001*\u0002\u0003W\u0001\u0001:\u0006\"\u0002.\u0001\t\u0003Z\u0006\"B5\u0001\t\u0003R\u0007\"B5\u0001\t\u0003\u0012\bbBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!!\u001e\u0001\t\u0013\t9hB\u0004\u0002\fVA\t!!$\u0007\rQ)\u0002\u0012AAH\u0011\u00199e\u0002\"\u0001\u0002\u0012\"I\u00111\u0013\bC\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003Os\u0001\u0015!\u0003\u0002\u0018\"I\u0011\u0011\u0016\bC\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003Ws\u0001\u0015!\u0003\u0002\u0018\n!2i\u001d:g'R\fG/Z%uK6D\u0015M\u001c3mKJT!AF\f\u0002\u000bM$\u0018\r^3\u000b\u0005aI\u0012!\u00039s_ZLG-\u001a:t\u0015\tQ2$\u0001\u0003j[Bd'B\u0001\u000f\u001e\u0003)\u0019\u0018\u000e\u001c5pk\u0016$H/\u001a\u0006\u0002=\u0005!\u0001\u000f\\1z\u0007\u0001\u0019R\u0001A\u0011(WE\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u00059\u0012B\u0001\u0016\u0018\u0005Y\u0019vnY5bYN#\u0018\r^3Ji\u0016l\u0007*\u00198eY\u0016\u0014\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001c\u0003\r\t\u0007/[\u0005\u0003a5\u0012a\u0001T8hO\u0016\u0014\bC\u0001\u00153\u0013\t\u0019tCA\u0011Qk\nd\u0017n\u001d5bE2,7k\\2jC2\u001cF/\u0019;f\u0013R,W\u000eS1oI2,'/\u0001\u0005tKR$\u0018N\\4t!\t1t'D\u0001\u0016\u0013\tATCA\tDgJ47\u000b^1uKN+G\u000f^5oON\f1\"\u001b3HK:,'/\u0019;peB\u00111HP\u0007\u0002y)\u0011Q(L\u0001\u0005kRLG.\u0003\u0002@y\tY\u0011\nR$f]\u0016\u0014\u0018\r^8s\u0003\u0019\u0019\u0018n\u001a8feB\u0011!)R\u0007\u0002\u0007*\u0011A)L\u0001\u0007GJL\b\u000f^8\n\u0005\u0019\u001b%AB*jO:,'/\u0001\u0004=S:LGO\u0010\u000b\u0005\u0013*[E\n\u0005\u00027\u0001!)A\u0007\u0002a\u0001k!)\u0011\b\u0002a\u0001u!)\u0001\t\u0002a\u0001\u0003\"\u0012AA\u0014\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000ba!\u001b8kK\u000e$(\"A*\u0002\u000f)\f7.\u0019:uC&\u0011Q\u000b\u0015\u0002\u0007\u0013:TWm\u0019;\u0003\t%#X-\u001c\t\u0003maK!!W\u000b\u0003\u001b\r\u001b(OZ*uCR,\u0017\n^3n\u0003\u0011IG/Z7\u0015\u0005q#\u0007cA/aE6\taL\u0003\u0002`G\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0005t&A\u0002$viV\u0014X\r\u0005\u0002d\u000b5\t\u0001\u0001C\u0003f\r\u0001\u000fa-\u0001\u0002fGB\u0011QlZ\u0005\u0003Qz\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0013\r\fg\u000eS1oI2,GCA6o!\r\u0011CNY\u0005\u0003[\u000e\u0012aa\u00149uS>t\u0007\"\u0002.\b\u0001\u0004y\u0007C\u0001\u0015q\u0013\t\txCA\bT_\u000eL\u0017\r\\*uCR,\u0017\n^3n+\t\u0019x\u0010F\u0002u\u0003#!\"!\u001e=\u0011\u0005\t2\u0018BA<$\u0005\u001d\u0011un\u001c7fC:DQ!\u001f\u0005A\u0004i\fqA]3rk\u0016\u001cH\u000fE\u0002<wvL!\u0001 \u001f\u0003%\u0015CHO]1di\u0006\u0014G.\u001a*fcV,7\u000f\u001e\t\u0003}~d\u0001\u0001B\u0004\u0002\u0002!\u0011\r!a\u0001\u0003\u0003\t\u000bB!!\u0002\u0002\fA\u0019!%a\u0002\n\u0007\u0005%1EA\u0004O_RD\u0017N\\4\u0011\u0007\t\ni!C\u0002\u0002\u0010\r\u00121!\u00118z\u0011\u0019Q\u0006\u00021\u0001\u0002\u0014A!\u0011QCA\u0019\u001d\u0011\t9\"!\f\u000f\t\u0005e\u00111\u0006\b\u0005\u00037\tIC\u0004\u0003\u0002\u001e\u0005\u001db\u0002BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rr$\u0001\u0004=e>|GOP\u0005\u0002=%\u0011A$H\u0005\u00035mI!\u0001G\r\n\u0007\u0005=r#A\bT_\u000eL\u0017\r\\*uCR,\u0017\n^3n\u0013\u0011\t\u0019$!\u000e\u0003\u001b%#X-\\*ueV\u001cG/\u001e:f\u0015\r\tycF\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$B!a\u0005\u0002<!)!,\u0003a\u0001E\u0006YQO\\:fe&\fG.\u001b>f+\u0011\t\t%a\u0013\u0015\t\u0005\r\u0013q\n\u000b\u00069\u0006\u0015\u0013Q\n\u0005\u0007s*\u0001\u001d!a\u0012\u0011\tmZ\u0018\u0011\n\t\u0004}\u0006-CaBA\u0001\u0015\t\u0007\u00111\u0001\u0005\u0006K*\u0001\u001dA\u001a\u0005\u00075*\u0001\r!a\u0005\u0002\u000fA,(\r\\5tQV!\u0011QKA7)\u0019\t9&a\u001c\u0002rQ!\u0011\u0011LA4!\u0011\tY&a\u0019\u000e\u0005\u0005u#\u0002BA0\u0003C\n1!\u001c<d\u0015\tqS$\u0003\u0003\u0002f\u0005u#A\u0002*fgVdG\u000f\u0003\u0004z\u0017\u0001\u000f\u0011\u0011\u000e\t\u0005wm\fY\u0007E\u0002\u007f\u0003[\"q!!\u0001\f\u0005\u0004\t\u0019\u0001C\u0003[\u0017\u0001\u0007!\rC\u0004\u0002t-\u0001\r!!\u0017\u0002\rI,7/\u001e7u\u0003-\u0019G.[3oiN#\u0018\r^3\u0015\t\u0005e\u00141\u0011\t\u0006\u0003w\nyHY\u0007\u0003\u0003{R!!P\u0012\n\t\u0005\u0005\u0015Q\u0010\u0002\u0004)JL\bBB=\r\u0001\b\t)\t\u0005\u0003\u0002\\\u0005\u001d\u0015\u0002BAE\u0003;\u0012QBU3rk\u0016\u001cH\u000fS3bI\u0016\u0014\u0018\u0001F\"te\u001a\u001cF/\u0019;f\u0013R,W\u000eS1oI2,'\u000f\u0005\u00027\u001dM\u0011a\"\t\u000b\u0003\u0003\u001b\u000b!!\u0013#\u0016\u0005\u0005]\u0005\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\u0005Y\u0006twM\u0003\u0002\u0002\"\u0006!!.\u0019<b\u0013\u0011\t)+a'\u0003\rM#(/\u001b8h\u0003\rIE\tI\u0001\u0019\u00072LWM\u001c;Ti\u0006$X\rR8fg:{G/\u0012=jgR\u001c\u0018!G\"mS\u0016tGo\u0015;bi\u0016$u.Z:O_R,\u00050[:ug\u0002\u0002")
public class CsrfStateItemHandler
implements SocialStateItemHandler,
Logger,
PublishableSocialStateItemHandler {
    private final CsrfStateSettings settings;
    private final IDGenerator idGenerator;
    private final Signer signer;
    private play.api.Logger logger;

    public static String ClientStateDoesNotExists() {
        return CsrfStateItemHandler$.MODULE$.ClientStateDoesNotExists();
    }

    public static String ID() {
        return CsrfStateItemHandler$.MODULE$.ID();
    }

    @Override
    public play.api.Logger logger() {
        return this.logger;
    }

    @Override
    public void play$silhouette$api$Logger$_setter_$logger_$eq(play.api.Logger x$1) {
        this.logger = x$1;
    }

    public Future<CsrfStateItem> item(ExecutionContext ec) {
        return this.idGenerator.generate().map((Function1 & Serializable)token -> new CsrfStateItem((String)token), ec);
    }

    public Option<CsrfStateItem> canHandle(SocialStateItem item) {
        SocialStateItem socialStateItem = item;
        if (socialStateItem instanceof CsrfStateItem) {
            CsrfStateItem csrfStateItem = (CsrfStateItem)socialStateItem;
            return new Some((Object)csrfStateItem);
        }
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <B> boolean canHandle(SocialStateItem.ItemStructure item, ExtractableRequest<B> request) {
        Try<CsrfStateItem> try_;
        String string = item.id();
        String string2 = CsrfStateItemHandler$.MODULE$.ID();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if ((try_ = this.clientState((RequestHeader)request)) instanceof Success) {
            CsrfStateItem i;
            Success success = (Success)try_;
            CsrfStateItem csrfStateItem = i = (CsrfStateItem)success.value();
            Object object = item.data().as(CsrfStateItem$.MODULE$.csrfFormat());
            if (csrfStateItem != null) {
                if (!((Object)csrfStateItem).equals(object)) return false;
                return true;
            }
            if (object == null) return true;
            return false;
        }
        if (!(try_ instanceof Failure)) throw new MatchError(try_);
        Failure failure = (Failure)try_;
        Throwable e = failure.exception();
        this.logger().warn((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
        return false;
    }

    public SocialStateItem.ItemStructure serialize(CsrfStateItem item) {
        return new SocialStateItem.ItemStructure(CsrfStateItemHandler$.MODULE$.ID(), Json$.MODULE$.toJson((Object)item, CsrfStateItem$.MODULE$.csrfFormat()));
    }

    public <B> Future<CsrfStateItem> unserialize(SocialStateItem.ItemStructure item, ExtractableRequest<B> request, ExecutionContext ec) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> (CsrfStateItem)item.data().as(CsrfStateItem$.MODULE$.csrfFormat())));
    }

    public <B> Result publish(CsrfStateItem item, Result result, ExtractableRequest<B> request) {
        return result.withCookies((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cookie[]{new Cookie(this.settings.cookieName(), this.signer.sign(item.token()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)((int)this.settings.expirationTime().toSeconds()))), this.settings.cookiePath(), this.settings.cookieDomain(), this.settings.secureCookie(), this.settings.httpOnlyCookie(), this.settings.sameSite(), Cookie$.MODULE$.apply$default$9())}));
    }

    private Try<CsrfStateItem> clientState(RequestHeader request) {
        Option option = request.cookies().get(this.settings.cookieName());
        if (option instanceof Some) {
            Some some = (Some)option;
            Cookie cookie = (Cookie)some.value();
            return this.signer.extract(cookie.value()).map((Function1 & Serializable)token -> new CsrfStateItem((String)token));
        }
        if (None$.MODULE$.equals(option)) {
            return new Failure((Throwable)new OAuth2StateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CsrfStateItemHandler$.MODULE$.ClientStateDoesNotExists()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.settings.cookieName()})), OAuth2StateException$.MODULE$.$lessinit$greater$default$2()));
        }
        throw new MatchError((Object)option);
    }

    @Inject
    public CsrfStateItemHandler(CsrfStateSettings settings, IDGenerator idGenerator, Signer signer) {
        this.settings = settings;
        this.idGenerator = idGenerator;
        this.signer = signer;
        Logger.$init$(this);
        Statics.releaseFence();
    }
}

