/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.authenticators;

import java.io.Serializable;
import java.time.ZonedDateTime;
import play.api.Logger;
import play.api.MarkerContext$;
import play.api.libs.json.JsObject;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.silhouette.api.Authenticator$Implicits$;
import play.silhouette.api.LoginInfo;
import play.silhouette.api.crypto.AuthenticatorEncoder;
import play.silhouette.api.exceptions.AuthenticatorCreationException;
import play.silhouette.api.exceptions.AuthenticatorDiscardingException;
import play.silhouette.api.exceptions.AuthenticatorInitializationException;
import play.silhouette.api.exceptions.AuthenticatorRenewalException;
import play.silhouette.api.exceptions.AuthenticatorRetrievalException;
import play.silhouette.api.exceptions.AuthenticatorUpdateException;
import play.silhouette.api.repositories.AuthenticatorRepository;
import play.silhouette.api.services.AuthenticatorResult;
import play.silhouette.api.services.AuthenticatorResult$;
import play.silhouette.api.services.AuthenticatorService;
import play.silhouette.api.services.AuthenticatorService$;
import play.silhouette.api.util.Clock;
import play.silhouette.api.util.ExtractableRequest;
import play.silhouette.api.util.IDGenerator;
import play.silhouette.impl.authenticators.JWTAuthenticator;
import play.silhouette.impl.authenticators.JWTAuthenticator$;
import play.silhouette.impl.authenticators.JWTAuthenticatorService$;
import play.silhouette.impl.authenticators.JWTAuthenticatorSettings;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tEa\u0001\u0002\u0012$\u00011B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011!y\u0006A!A!\u0002\u0013\u0001\u0007\u0002C2\u0001\u0005\u000b\u0007I1\u00013\t\u0011-\u0004!\u0011!Q\u0001\n\u0015DQ\u0001\u001c\u0001\u0005\u00025DQA\u001e\u0001\u0005B]Dq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d!9\u0011\u0011\r\u0001\u0005B\u0005}\u0004bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003;\u0003A\u0011IAP\u0011\u001d\tI\u000b\u0001C!\u0003WCq!!+\u0001\t\u0003\ni\rC\u0004\u0002X\u0002!\t%!7\b\u000f\u0005\r8\u0005#\u0001\u0002f\u001a1!e\tE\u0001\u0003ODa\u0001\u001c\u000b\u0005\u0002\u0005%\b\"CAv)\t\u0007I\u0011AAw\u0011!\t\u0019\u0010\u0006Q\u0001\n\u0005=\b\"CA{)\t\u0007I\u0011AAw\u0011!\t9\u0010\u0006Q\u0001\n\u0005=\b\"CA})\t\u0007I\u0011AAw\u0011!\tY\u0010\u0006Q\u0001\n\u0005=\b\"CA\u007f)\t\u0007I\u0011AAw\u0011!\ty\u0010\u0006Q\u0001\n\u0005=\b\"\u0003B\u0001)\t\u0007I\u0011AAw\u0011!\u0011\u0019\u0001\u0006Q\u0001\n\u0005=\b\"\u0003B\u0003)\t\u0007I\u0011\u0001B\u0004\u0011!\u0011y\u0001\u0006Q\u0001\n\t%!a\u0006&X)\u0006+H\u000f[3oi&\u001c\u0017\r^8s'\u0016\u0014h/[2f\u0015\t!S%\u0001\bbkRDWM\u001c;jG\u0006$xN]:\u000b\u0005\u0019:\u0013\u0001B5na2T!\u0001K\u0015\u0002\u0015MLG\u000e[8vKR$XMC\u0001+\u0003\u0011\u0001H.Y=\u0004\u0001M!\u0001!L\u001a@!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0019A'O\u001e\u000e\u0003UR!AN\u001c\u0002\u0011M,'O^5dKNT!\u0001O\u0014\u0002\u0007\u0005\u0004\u0018.\u0003\u0002;k\t!\u0012)\u001e;iK:$\u0018nY1u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001P\u001f\u000e\u0003\rJ!AP\u0012\u0003!);F+Q;uQ\u0016tG/[2bi>\u0014\bC\u0001!B\u001b\u00059\u0014B\u0001\"8\u0005\u0019aunZ4fe\u0006A1/\u001a;uS:<7\u000f\u0005\u0002=\u000b&\u0011ai\t\u0002\u0019\u0015^#\u0016)\u001e;iK:$\u0018nY1u_J\u001cV\r\u001e;j]\u001e\u001c\u0018A\u0003:fa>\u001c\u0018\u000e^8ssB\u0019a&S&\n\u0005){#AB(qi&|g\u000eE\u0002M\u001fnj\u0011!\u0014\u0006\u0003\u001d^\nAB]3q_NLGo\u001c:jKNL!\u0001U'\u0003/\u0005+H\u000f[3oi&\u001c\u0017\r^8s%\u0016\u0004xn]5u_JL\u0018\u0001F1vi\",g\u000e^5dCR|'/\u00128d_\u0012,'\u000f\u0005\u0002T-6\tAK\u0003\u0002Vo\u000511M]=qi>L!a\u0016+\u0003)\u0005+H\u000f[3oi&\u001c\u0017\r^8s\u000b:\u001cw\u000eZ3s\u0003-IGmR3oKJ\fGo\u001c:\u0011\u0005ikV\"A.\u000b\u0005q;\u0014\u0001B;uS2L!AX.\u0003\u0017%#u)\u001a8fe\u0006$xN]\u0001\u0006G2|7m\u001b\t\u00035\u0006L!AY.\u0003\u000b\rcwnY6\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#A3\u0011\u0005\u0019LW\"A4\u000b\u0005!|\u0013AC2p]\u000e,(O]3oi&\u0011!n\u001a\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0003\u0019a\u0014N\\5u}Q1a.\u001d:tiV$\"a\u001c9\u0011\u0005q\u0002\u0001\"B2\t\u0001\b)\u0007\"B\"\t\u0001\u0004!\u0005\"B$\t\u0001\u0004A\u0005\"B)\t\u0001\u0004\u0011\u0006\"\u0002-\t\u0001\u0004I\u0006\"B0\t\u0001\u0004\u0001\u0017AB2sK\u0006$X\rF\u0002y\u0003\u0017!\"!\u001f?\u0011\u0007\u0019T8(\u0003\u0002|O\n1a)\u001e;ve\u0016DQ!`\u0005A\u0004y\fqA]3rk\u0016\u001cH\u000fE\u0002\u0000\u0003\u000fi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0004[Z\u001c'B\u0001\u001d*\u0013\u0011\tI!!\u0001\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u001d\ti!\u0003a\u0001\u0003\u001f\t\u0011\u0002\\8hS:LeNZ8\u0011\u0007\u0001\u000b\t\"C\u0002\u0002\u0014]\u0012\u0011\u0002T8hS:LeNZ8\u0002\u0011I,GO]5fm\u0016,B!!\u0007\u0002,Q!\u00111DA\u0010!\u00111'0!\b\u0011\u00079J5\b\u0003\u0004~\u0015\u0001\u000f\u0011\u0011\u0005\t\u00065\u0006\r\u0012qE\u0005\u0004\u0003KY&AE#yiJ\f7\r^1cY\u0016\u0014V-];fgR\u0004B!!\u000b\u0002,1\u0001AaBA\u0017\u0015\t\u0007\u0011q\u0006\u0002\u0002\u0005F!\u0011\u0011GA\u001c!\rq\u00131G\u0005\u0004\u0003ky#a\u0002(pi\"Lgn\u001a\t\u0004]\u0005e\u0012bAA\u001e_\t\u0019\u0011I\\=\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u0003\u0003\ni\u0006\u0006\u0003\u0002D\u0005m\u0003\u0003\u00024{\u0003\u000b\u0002B!a\u0012\u0002V9!\u0011\u0011JA)!\r\tYeL\u0007\u0003\u0003\u001bR1!a\u0014,\u0003\u0019a$o\\8u}%\u0019\u00111K\u0018\u0002\rA\u0013X\rZ3g\u0013\u0011\t9&!\u0017\u0003\rM#(/\u001b8h\u0015\r\t\u0019f\f\u0005\u0006{.\u0001\u001dA \u0005\u0007\u0003?Z\u0001\u0019A\u001e\u0002\u001b\u0005,H\u000f[3oi&\u001c\u0017\r^8s\u0003\u0015)WNY3e)\u0019\t)'!\u001d\u0002vQ!\u0011qMA8!\u00111'0!\u001b\u0011\u0007Q\nY'C\u0002\u0002nU\u00121#Q;uQ\u0016tG/[2bi>\u0014(+Z:vYRDQ! \u0007A\u0004yDq!a\u001d\r\u0001\u0004\t)%A\u0003u_.,g\u000eC\u0004\u0002x1\u0001\r!!\u001f\u0002\rI,7/\u001e7u!\ry\u00181P\u0005\u0005\u0003{\n\tA\u0001\u0004SKN,H\u000e\u001e\u000b\u0006}\u0006\u0005\u00151\u0011\u0005\b\u0003gj\u0001\u0019AA#\u0011\u0015iX\u00021\u0001\u007f\u0003\u0015!x.^2i)\u0011\tI)a'\u0011\r\u0005-\u0015QS\u001e<\u001d\u0011\ti)!%\u000f\t\u0005-\u0013qR\u0005\u0002a%\u0019\u00111S\u0018\u0002\u000fA\f7m[1hK&!\u0011qSAM\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u00111S\u0018\t\r\u0005}c\u00021\u0001<\u0003\u0019)\b\u000fZ1uKR1\u0011\u0011UAS\u0003O#B!a\u001a\u0002$\")Qp\u0004a\u0002}\"1\u0011qL\bA\u0002mBq!a\u001e\u0010\u0001\u0004\tI(A\u0003sK:,w\u000f\u0006\u0003\u0002.\u0006EF\u0003BA\"\u0003_CQ! \tA\u0004yDa!a\u0018\u0011\u0001\u0004Y\u0004f\u0002\t\u00026\u0006\u0015\u0017q\u0019\t\u0005\u0003o\u000b\t-\u0004\u0002\u0002:*!\u00111XA_\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0016\u0001\u00026bm\u0006LA!a1\u0002:\n\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u0013\f#!a3\u0002#Y\u000b'/[1cY\u0016\u001c\u0006.\u00193po&tw\r\u0006\u0004\u0002P\u0006M\u0017Q\u001b\u000b\u0005\u0003O\n\t\u000eC\u0003~#\u0001\u000fa\u0010\u0003\u0004\u0002`E\u0001\ra\u000f\u0005\b\u0003o\n\u0002\u0019AA=\u0003\u001d!\u0017n]2be\u0012$b!a7\u0002`\u0006\u0005H\u0003BA4\u0003;DQ! \nA\u0004yDa!a\u0018\u0013\u0001\u0004Y\u0004bBA<%\u0001\u0007\u0011\u0011P\u0001\u0018\u0015^#\u0016)\u001e;iK:$\u0018nY1u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001\u0010\u000b\u0014\u0005QiCCAAs\u0003\tIE)\u0006\u0002\u0002pB!\u0011qWAy\u0013\u0011\t9&!/\u0002\u0007%#\u0005%A\bJ]Z\fG.\u001b3K/R#vn[3o\u0003AIeN^1mS\u0012Tu\u000b\u0016+pW\u0016t\u0007%\u0001\bKg>t\u0007+\u0019:tK\u0016\u0013(o\u001c:\u0002\u001f)\u001bxN\u001c)beN,WI\u001d:pe\u0002\n1#\u00168fqB,7\r^3e\u0015N|gNV1mk\u0016\fA#\u00168fqB,7\r^3e\u0015N|gNV1mk\u0016\u0004\u0013!F(wKJ\u0014\u0018\u000eZ3SKN,'O^3e\u00072\f\u0017.\\\u0001\u0017\u001fZ,'O]5eKJ+7/\u001a:wK\u0012\u001cE.Y5nA\u0005q!+Z:feZ,Gm\u00117bS6\u001cXC\u0001B\u0005!\u0019\tYIa\u0003\u0002F%!!QBAM\u0005\r\u0019V-]\u0001\u0010%\u0016\u001cXM\u001d<fI\u000ec\u0017-[7tA\u0001")
public class JWTAuthenticatorService
implements AuthenticatorService<JWTAuthenticator>,
play.silhouette.api.Logger {
    private final JWTAuthenticatorSettings settings;
    private final Option<AuthenticatorRepository<JWTAuthenticator>> repository;
    private final AuthenticatorEncoder authenticatorEncoder;
    private final IDGenerator idGenerator;
    private final Clock clock;
    private final ExecutionContext executionContext;
    private Logger logger;

    public static Seq<String> ReservedClaims() {
        return JWTAuthenticatorService$.MODULE$.ReservedClaims();
    }

    public static String OverrideReservedClaim() {
        return JWTAuthenticatorService$.MODULE$.OverrideReservedClaim();
    }

    public static String UnexpectedJsonValue() {
        return JWTAuthenticatorService$.MODULE$.UnexpectedJsonValue();
    }

    public static String JsonParseError() {
        return JWTAuthenticatorService$.MODULE$.JsonParseError();
    }

    public static String InvalidJWTToken() {
        return JWTAuthenticatorService$.MODULE$.InvalidJWTToken();
    }

    public static String ID() {
        return JWTAuthenticatorService$.MODULE$.ID();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void play$silhouette$api$Logger$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public Future<JWTAuthenticator> create(LoginInfo loginInfo, RequestHeader request) {
        return this.idGenerator.generate().map((Function1 & Serializable)id -> {
            ZonedDateTime now = $this.clock.now();
            return new JWTAuthenticator((String)id, loginInfo, now, Authenticator$Implicits$.MODULE$.RichDateTime(now).$plus($this.settings.authenticatorExpiry()), $this.settings.authenticatorIdleTimeout(), JWTAuthenticator$.MODULE$.apply$default$6());
        }, this.executionContext()).recover((PartialFunction)new Serializable(null, loginInfo){
            private static final long serialVersionUID = 0L;
            private final LoginInfo loginInfo$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorCreationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.CreateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.loginInfo$1})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.loginInfo$1 = loginInfo$1;
            }
        }, this.executionContext());
    }

    @Override
    public <B> Future<Option<JWTAuthenticator>> retrieve(ExtractableRequest<B> request) {
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> request.extractString($this.settings.fieldName(), $this.settings.requestParts()))).flatMap((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                String token = (String)some.value();
                Try<JWTAuthenticator> try_ = JWTAuthenticator$.MODULE$.unserialize(token, $this.authenticatorEncoder, $this.settings, (Option<Clock>)new Some((Object)$this.clock));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    JWTAuthenticator authenticator = (JWTAuthenticator)success.value();
                    return (Future)$this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)Option$.MODULE$.apply((Object)authenticator)), (Function1 & Serializable)x$1 -> x$1.find(authenticator.id()));
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.logger().info((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
                    return Future$.MODULE$.successful((Object)None$.MODULE$);
                }
                throw new MatchError(try_);
            }
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRetrievalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RetrieveError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID()})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, this.executionContext());
    }

    @Override
    public Future<String> init(JWTAuthenticator authenticator, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)authenticator), (Function1 & Serializable)x$2 -> x$2.add(authenticator))).map((Function1 & Serializable)a -> JWTAuthenticator$.MODULE$.serialize((JWTAuthenticator)a, $this.authenticatorEncoder, $this.settings), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorInitializationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.InitError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$2})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$2 = authenticator$2;
            }
        }, this.executionContext());
    }

    public Future<AuthenticatorResult> embed(String token, Result result, RequestHeader request) {
        return Future$.MODULE$.successful((Object)AuthenticatorResult$.MODULE$.apply(result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.settings.fieldName()), (Object)token)}))));
    }

    public RequestHeader embed(String token, RequestHeader request) {
        .colon.colon additional = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.settings.fieldName()), (Object)token), (List)Nil$.MODULE$);
        return request.withHeaders(request.headers().replace((Seq)additional));
    }

    @Override
    public Either<JWTAuthenticator, JWTAuthenticator> touch(JWTAuthenticator authenticator) {
        if (authenticator.idleTimeout().isDefined()) {
            ZonedDateTime x$1 = this.clock.now();
            String x$2 = authenticator.copy$default$1();
            LoginInfo x$3 = authenticator.copy$default$2();
            ZonedDateTime x$4 = authenticator.copy$default$4();
            Option<FiniteDuration> x$5 = authenticator.copy$default$5();
            Option<JsObject> x$6 = authenticator.copy$default$6();
            return new Left((Object)authenticator.copy(x$2, x$3, x$1, x$4, x$5, x$6));
        }
        return new Right((Object)authenticator);
    }

    @Override
    public Future<AuthenticatorResult> update(JWTAuthenticator authenticator, Result result, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)authenticator), (Function1 & Serializable)x$3 -> x$3.update(authenticator))).map((Function1 & Serializable)a -> AuthenticatorResult$.MODULE$.apply(result.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.settings.fieldName()), (Object)JWTAuthenticator$.MODULE$.serialize((JWTAuthenticator)a, $this.authenticatorEncoder, $this.settings))}))), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$3;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorUpdateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.UpdateError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$3})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$3 = authenticator$3;
            }
        }, this.executionContext());
    }

    @Override
    public Future<String> renew(JWTAuthenticator authenticator, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT), (Function1 & Serializable)x$4 -> x$4.remove(authenticator.id()))).flatMap((Function1 & Serializable)x$5 -> this.create(authenticator.loginInfo(), request).map((Function1 & Serializable)auth -> {
            Option<JsObject> x$1 = authenticator.customClaims();
            String x$2 = auth.copy$default$1();
            LoginInfo x$3 = auth.copy$default$2();
            ZonedDateTime x$4 = auth.copy$default$3();
            ZonedDateTime x$5 = auth.copy$default$4();
            Option<FiniteDuration> x$6 = auth.copy$default$5();
            return auth.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        }, this.executionContext()).flatMap((Function1 & Serializable)authenticator -> this.init((JWTAuthenticator)authenticator, request), this.executionContext()), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$4})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$4 = authenticator$4;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> renew(JWTAuthenticator authenticator, Result result, RequestHeader request) {
        return this.renew(authenticator, request).flatMap((Function1 & Serializable)v -> this.embed((String)v, result, request), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$5;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorRenewalException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.RenewError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$5})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$5 = authenticator$5;
            }
        }, this.executionContext());
    }

    @Override
    public Future<AuthenticatorResult> discard(JWTAuthenticator authenticator, Result result, RequestHeader request) {
        return ((Future)this.repository.fold((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BoxedUnit.UNIT), (Function1 & Serializable)x$6 -> x$6.remove(authenticator.id()))).map((Function1 & Serializable)x$7 -> AuthenticatorResult$.MODULE$.apply(result), this.executionContext()).recover((PartialFunction)new Serializable(null, authenticator){
            private static final long serialVersionUID = 0L;
            private final JWTAuthenticator authenticator$6;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                throw new AuthenticatorDiscardingException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(AuthenticatorService$.MODULE$.DiscardError()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{JWTAuthenticatorService$.MODULE$.ID(), this.authenticator$6})), (Option<Throwable>)new Some(A1));
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                this.authenticator$6 = authenticator$6;
            }
        }, this.executionContext());
    }

    public JWTAuthenticatorService(JWTAuthenticatorSettings settings, Option<AuthenticatorRepository<JWTAuthenticator>> repository, AuthenticatorEncoder authenticatorEncoder, IDGenerator idGenerator, Clock clock, ExecutionContext executionContext) {
        this.settings = settings;
        this.repository = repository;
        this.authenticatorEncoder = authenticatorEncoder;
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.executionContext = executionContext;
        play.silhouette.api.Logger.$init$(this);
        Statics.releaseFence();
    }
}

