/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.authenticators;

import java.io.Serializable;
import java.time.ZonedDateTime;
import play.api.Logger;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.Format;
import play.api.libs.json.Format$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonConfiguration;
import play.api.libs.json.JsonConfiguration$;
import play.api.libs.json.OFormat;
import play.api.libs.json.OFormat$;
import play.api.libs.json.OWrites$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.silhouette.api.LoginInfo;
import play.silhouette.api.LoginInfo$;
import play.silhouette.api.crypto.AuthenticatorEncoder;
import play.silhouette.api.crypto.Signer;
import play.silhouette.api.exceptions.AuthenticatorException;
import play.silhouette.api.exceptions.AuthenticatorException$;
import play.silhouette.api.util.JsonFormats$FiniteDurationFormat$;
import play.silhouette.impl.authenticators.CookieAuthenticator;
import play.silhouette.impl.authenticators.CookieAuthenticatorService$;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CookieAuthenticator$
implements play.silhouette.api.Logger,
Serializable {
    public static final CookieAuthenticator$ MODULE$ = new CookieAuthenticator$();
    private static final OFormat<CookieAuthenticator> jsonFormat;
    private static Logger logger;

    static {
        play.silhouette.api.Logger.$init$(MODULE$);
        JsonConfiguration config$macro$2 = JsonConfiguration$.MODULE$.default((Json.MacroOptions$.Default)Json.MacroOptions$.Default$.macroOptionsDefault$.MODULE$);
        OFormat underlying = (OFormat)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("id")).format(Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.StringReads(), (Writes)Writes$.MODULE$.StringWrites())), OFormat$.MODULE$.functionalCanBuildFormats(FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult())), OWrites$.MODULE$.functionalCanBuildOWrites())).and((Object)JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("loginInfo")).format(LoginInfo$.MODULE$.jsonFormat())).and((Object)JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("lastUsedDateTime")).format(Format$.MODULE$.GenericFormat(Reads$.MODULE$.DefaultZonedDateTimeReads(), Writes$.MODULE$.DefaultZonedDateTimeWrites()))).and((Object)JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("expirationDateTime")).format(Format$.MODULE$.GenericFormat(Reads$.MODULE$.DefaultZonedDateTimeReads(), Writes$.MODULE$.DefaultZonedDateTimeWrites()))).and((Object)config$macro$2.optionHandlers().formatHandler(JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("idleTimeout")), (Format)JsonFormats$FiniteDurationFormat$.MODULE$)).and((Object)config$macro$2.optionHandlers().formatHandler(JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("cookieMaxAge")), (Format)JsonFormats$FiniteDurationFormat$.MODULE$)).and((Object)config$macro$2.optionHandlers().formatHandler(JsPath$.MODULE$.$bslash(config$macro$2.naming().apply("fingerprint")), Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.StringReads(), (Writes)Writes$.MODULE$.StringWrites()))).apply((Function7 & Serializable)(id, loginInfo, lastUsedDateTime, expirationDateTime, idleTimeout, cookieMaxAge, fingerprint) -> new CookieAuthenticator((String)id, (LoginInfo)loginInfo, (ZonedDateTime)lastUsedDateTime, (ZonedDateTime)expirationDateTime, (Option<FiniteDuration>)idleTimeout, (Option<FiniteDuration>)cookieMaxAge, (Option<String>)fingerprint), package$.MODULE$.unlift((Function1 & Serializable)x$0 -> MODULE$.unapply((CookieAuthenticator)x$0)), OFormat$.MODULE$.invariantFunctorOFormat());
        Function1 & Serializable rfn = (Function1 & Serializable)x0$1 -> {
            JsValue jsValue = x0$1;
            if (jsValue instanceof JsObject) {
                JsObject jsObject = (JsObject)jsValue;
                return underlying.reads((JsValue)jsObject);
            }
            return JsError$.MODULE$.apply("error.expected.jsobject");
        };
        jsonFormat = OFormat$.MODULE$.apply((Function1)rfn, (Function1 & Serializable)o -> underlying.writes(o));
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void play$silhouette$api$Logger$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public OFormat<CookieAuthenticator> jsonFormat() {
        return jsonFormat;
    }

    public String serialize(CookieAuthenticator authenticator, Signer signer, AuthenticatorEncoder authenticatorEncoder) {
        return signer.sign(authenticatorEncoder.encode(Json$.MODULE$.toJson((Object)authenticator, this.jsonFormat()).toString()));
    }

    public Try<CookieAuthenticator> unserialize(String str, Signer signer, AuthenticatorEncoder authenticatorEncoder) {
        Try<String> try_ = signer.extract(str);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String data = (String)success.value();
            return this.buildAuthenticator(authenticatorEncoder.decode(data));
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            return new Failure((Throwable)new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieAuthenticatorService$.MODULE$.InvalidCookieSignature()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CookieAuthenticatorService$.MODULE$.ID()})), (Option<Throwable>)new Some((Object)e)));
        }
        throw new MatchError(try_);
    }

    private Try<CookieAuthenticator> buildAuthenticator(String str) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Json$.MODULE$.parse(str));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JsValue json = (JsValue)success.value();
            Either either = json.validate(this.jsonFormat()).asEither();
            if (either instanceof Left) {
                Left left = (Left)either;
                Seq error = (Seq)left.value();
                return new Failure((Throwable)new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieAuthenticatorService$.MODULE$.InvalidJsonFormat()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CookieAuthenticatorService$.MODULE$.ID(), error})), AuthenticatorException$.MODULE$.$lessinit$greater$default$2()));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                CookieAuthenticator authenticator = (CookieAuthenticator)right.value();
                return new Success((Object)authenticator);
            }
            throw new MatchError((Object)either);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            return new Failure((Throwable)new AuthenticatorException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieAuthenticatorService$.MODULE$.InvalidJson()), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CookieAuthenticatorService$.MODULE$.ID(), str})), (Option<Throwable>)new Some((Object)error)));
        }
        throw new MatchError((Object)try_);
    }

    public CookieAuthenticator apply(String id, LoginInfo loginInfo, ZonedDateTime lastUsedDateTime, ZonedDateTime expirationDateTime, Option<FiniteDuration> idleTimeout, Option<FiniteDuration> cookieMaxAge, Option<String> fingerprint) {
        return new CookieAuthenticator(id, loginInfo, lastUsedDateTime, expirationDateTime, idleTimeout, cookieMaxAge, fingerprint);
    }

    public Option<Tuple7<String, LoginInfo, ZonedDateTime, ZonedDateTime, Option<FiniteDuration>, Option<FiniteDuration>, Option<String>>> unapply(CookieAuthenticator x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.id(), (Object)x$0.loginInfo(), (Object)x$0.lastUsedDateTime(), (Object)x$0.expirationDateTime(), x$0.idleTimeout(), x$0.cookieMaxAge(), x$0.fingerprint()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CookieAuthenticator$.class);
    }

    private CookieAuthenticator$() {
    }
}

