/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.providers;

import java.io.Serializable;
import javax.inject.Inject;
import play.api.MarkerContext$;
import play.api.http.HeaderNames$;
import play.api.mvc.Request;
import play.api.mvc.RequestHeader;
import play.silhouette.api.Logger;
import play.silhouette.api.LoginInfo;
import play.silhouette.api.RequestProvider;
import play.silhouette.api.crypto.Base64$;
import play.silhouette.api.exceptions.ConfigurationException;
import play.silhouette.api.exceptions.ConfigurationException$;
import play.silhouette.api.repositories.AuthInfoRepository;
import play.silhouette.api.util.Credentials;
import play.silhouette.api.util.PasswordHasherRegistry;
import play.silhouette.impl.providers.BasicAuthProvider$;
import play.silhouette.impl.providers.PasswordProvider;
import play.silhouette.impl.providers.PasswordProvider$Authenticated$;
import play.silhouette.impl.providers.PasswordProvider$InvalidPassword$;
import play.silhouette.impl.providers.PasswordProvider$NotFound$;
import play.silhouette.impl.providers.PasswordProvider$UnsupportedHasher$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\t\u0012\u0001iA\u0001B\f\u0001\u0003\u0006\u0004%\tb\f\u0005\tm\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001BC\u0002\u0013E\u0001\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003:\u0011!\u0001\u0005A!b\u0001\n\u0007\t\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b%\u0003A\u0011\u0001&\t\u000be\u0003A\u0011\t.\t\u000b\r\u0004A\u0011\t3\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u001d9\u00111D\t\t\u0002\u0005uaA\u0002\t\u0012\u0011\u0003\ty\u0002\u0003\u0004J\u0019\u0011\u0005\u0011\u0011\u0005\u0005\t\u0003Ga!\u0019!C\u00015\"9\u0011Q\u0005\u0007!\u0002\u0013Y&!\u0005\"bg&\u001c\u0017)\u001e;i!J|g/\u001b3fe*\u0011!cE\u0001\naJ|g/\u001b3feNT!\u0001F\u000b\u0002\t%l\u0007\u000f\u001c\u0006\u0003-]\t!b]5mQ>,X\r\u001e;f\u0015\u0005A\u0012\u0001\u00029mCf\u001c\u0001aE\u0003\u00017\u0005:3\u0006\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u0015j\u0011a\t\u0006\u0003IU\t1!\u00199j\u0013\t13EA\bSKF,Xm\u001d;Qe>4\u0018\u000eZ3s!\tA\u0013&D\u0001\u0012\u0013\tQ\u0013C\u0001\tQCN\u001cxo\u001c:e!J|g/\u001b3feB\u0011!\u0005L\u0005\u0003[\r\u0012a\u0001T8hO\u0016\u0014\u0018AE1vi\"LeNZ8SKB|7/\u001b;pef,\u0012\u0001\r\t\u0003cQj\u0011A\r\u0006\u0003g\r\nAB]3q_NLGo\u001c:jKNL!!\u000e\u001a\u0003%\u0005+H\u000f[%oM>\u0014V\r]8tSR|'/_\u0001\u0014CV$\b.\u00138g_J+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u0017a\u0006\u001c8o^8sI\"\u000b7\u000f[3s%\u0016<\u0017n\u001d;ssV\t\u0011\b\u0005\u0002;{5\t1H\u0003\u0002=G\u0005!Q\u000f^5m\u0013\tq4H\u0001\fQCN\u001cxo\u001c:e\u0011\u0006\u001c\b.\u001a:SK\u001eL7\u000f\u001e:z\u0003]\u0001\u0018m]:x_J$\u0007*Y:iKJ\u0014VmZ5tiJL\b%\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\t!\t\u0005\u0002D\r6\tAI\u0003\u0002F;\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u001d#%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003E)\u00070Z2vi&|gnQ8oi\u0016DH\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007-su\n\u0006\u0002M\u001bB\u0011\u0001\u0006\u0001\u0005\u0006\u0001\u001e\u0001\u001dA\u0011\u0005\u0006]\u001d\u0001\r\u0001\r\u0005\u0006o\u001d\u0001\r!\u000f\u0015\u0003\u000fE\u0003\"AU,\u000e\u0003MS!\u0001V+\u0002\r%t'.Z2u\u0015\u00051\u0016!\u00026bm\u0006D\u0018B\u0001-T\u0005\u0019IeN[3di\u0006\u0011\u0011\u000eZ\u000b\u00027B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0005Y\u0006twMC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\tl&AB*ue&tw-\u0001\u0007bkRDWM\u001c;jG\u0006$X-\u0006\u0002fuR\u0011am\u001c\t\u0004\u0007\u001eL\u0017B\u00015E\u0005\u00191U\u000f^;sKB\u0019AD\u001b7\n\u0005-l\"AB(qi&|g\u000e\u0005\u0002#[&\u0011an\t\u0002\n\u0019><\u0017N\\%oM>DQ\u0001]\u0005A\u0002E\fqA]3rk\u0016\u001cH\u000fE\u0002smbl\u0011a\u001d\u0006\u0003iV\f1!\u001c<d\u0015\t!s#\u0003\u0002xg\n9!+Z9vKN$\bCA={\u0019\u0001!Qa_\u0005C\u0002q\u0014\u0011AQ\t\u0004{\u0006\u0005\u0001C\u0001\u000f\u007f\u0013\tyXDA\u0004O_RD\u0017N\\4\u0011\u0007q\t\u0019!C\u0002\u0002\u0006u\u00111!\u00118z\u000399W\r^\"sK\u0012,g\u000e^5bYN$B!a\u0003\u0002\u0014A!AD[A\u0007!\rQ\u0014qB\u0005\u0004\u0003#Y$aC\"sK\u0012,g\u000e^5bYNDa\u0001\u001d\u0006A\u0002\u0005U\u0001c\u0001:\u0002\u0018%\u0019\u0011\u0011D:\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0003E\u0011\u0015m]5d\u0003V$\b\u000e\u0015:pm&$WM\u001d\t\u0003Q1\u0019\"\u0001D\u000e\u0015\u0005\u0005u\u0011AA%E\u0003\rIE\t\t")
public class BasicAuthProvider
implements RequestProvider,
PasswordProvider,
Logger {
    private final AuthInfoRepository authInfoRepository;
    private final PasswordHasherRegistry passwordHasherRegistry;
    private final ExecutionContext executionContext;
    private play.api.Logger logger;
    private volatile PasswordProvider$Authenticated$ Authenticated$module;
    private volatile PasswordProvider$InvalidPassword$ InvalidPassword$module;
    private volatile PasswordProvider$UnsupportedHasher$ UnsupportedHasher$module;
    private volatile PasswordProvider$NotFound$ NotFound$module;

    public static String ID() {
        return BasicAuthProvider$.MODULE$.ID();
    }

    @Override
    public Future<PasswordProvider.State> authenticate(LoginInfo loginInfo, String password) {
        return PasswordProvider.authenticate$(this, loginInfo, password);
    }

    @Override
    public play.api.Logger logger() {
        return this.logger;
    }

    @Override
    public void play$silhouette$api$Logger$_setter_$logger_$eq(play.api.Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public PasswordProvider$Authenticated$ Authenticated() {
        if (this.Authenticated$module == null) {
            this.Authenticated$lzycompute$1();
        }
        return this.Authenticated$module;
    }

    @Override
    public PasswordProvider$InvalidPassword$ InvalidPassword() {
        if (this.InvalidPassword$module == null) {
            this.InvalidPassword$lzycompute$1();
        }
        return this.InvalidPassword$module;
    }

    @Override
    public PasswordProvider$UnsupportedHasher$ UnsupportedHasher() {
        if (this.UnsupportedHasher$module == null) {
            this.UnsupportedHasher$lzycompute$1();
        }
        return this.UnsupportedHasher$module;
    }

    @Override
    public PasswordProvider$NotFound$ NotFound() {
        if (this.NotFound$module == null) {
            this.NotFound$lzycompute$1();
        }
        return this.NotFound$module;
    }

    @Override
    public AuthInfoRepository authInfoRepository() {
        return this.authInfoRepository;
    }

    @Override
    public PasswordHasherRegistry passwordHasherRegistry() {
        return this.passwordHasherRegistry;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String id() {
        return BasicAuthProvider$.MODULE$.ID();
    }

    @Override
    public <B> Future<Option<LoginInfo>> authenticate(Request<B> request) {
        Option<Credentials> option = this.getCredentials((RequestHeader)request);
        if (option instanceof Some) {
            Some some = (Some)option;
            Credentials credentials = (Credentials)some.value();
            LoginInfo loginInfo = new LoginInfo(this.id(), credentials.identifier());
            return this.authenticate(loginInfo, credentials.password()).map((Function1 & Serializable)x0$1 -> {
                PasswordProvider.State state = x0$1;
                if (this.Authenticated().equals(state)) {
                    return new Some((Object)loginInfo);
                }
                if (state instanceof PasswordProvider.InvalidPassword) {
                    PasswordProvider.InvalidPassword invalidPassword = (PasswordProvider.InvalidPassword)state;
                    String error = invalidPassword.error();
                    this.logger().debug((Function0 & Serializable)() -> error, MarkerContext$.MODULE$.NoMarker());
                    return None$.MODULE$;
                }
                if (state instanceof PasswordProvider.UnsupportedHasher) {
                    PasswordProvider.UnsupportedHasher unsupportedHasher = (PasswordProvider.UnsupportedHasher)state;
                    String error = unsupportedHasher.error();
                    throw new ConfigurationException(error, ConfigurationException$.MODULE$.$lessinit$greater$default$2());
                }
                if (state instanceof PasswordProvider.NotFound) {
                    PasswordProvider.NotFound notFound = (PasswordProvider.NotFound)state;
                    String error = notFound.error();
                    this.logger().debug((Function0 & Serializable)() -> error, MarkerContext$.MODULE$.NoMarker());
                    return None$.MODULE$;
                }
                throw new MatchError((Object)state);
            }, this.executionContext());
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Option<Credentials> getCredentials(RequestHeader request) {
        Some some;
        String header;
        Option option = request.headers().get(HeaderNames$.MODULE$.AUTHORIZATION());
        if (option instanceof Some && (header = (String)(some = (Some)option).value()).startsWith("Basic ")) {
            String[] stringArray = Base64$.MODULE$.decode(header.replace("Basic ", "")).split(":", 2);
            if (stringArray.length == 2) {
                return new Some((Object)new Credentials(stringArray[0], stringArray[1]));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private final void Authenticated$lzycompute$1() {
        BasicAuthProvider basicAuthProvider = this;
        synchronized (basicAuthProvider) {
            if (this.Authenticated$module == null) {
                this.Authenticated$module = new PasswordProvider$Authenticated$(this);
            }
        }
    }

    private final void InvalidPassword$lzycompute$1() {
        BasicAuthProvider basicAuthProvider = this;
        synchronized (basicAuthProvider) {
            if (this.InvalidPassword$module == null) {
                this.InvalidPassword$module = new PasswordProvider$InvalidPassword$(this);
            }
        }
    }

    private final void UnsupportedHasher$lzycompute$1() {
        BasicAuthProvider basicAuthProvider = this;
        synchronized (basicAuthProvider) {
            if (this.UnsupportedHasher$module == null) {
                this.UnsupportedHasher$module = new PasswordProvider$UnsupportedHasher$(this);
            }
        }
    }

    private final void NotFound$lzycompute$1() {
        BasicAuthProvider basicAuthProvider = this;
        synchronized (basicAuthProvider) {
            if (this.NotFound$module == null) {
                this.NotFound$module = new PasswordProvider$NotFound$(this);
            }
        }
    }

    @Inject
    public BasicAuthProvider(AuthInfoRepository authInfoRepository, PasswordHasherRegistry passwordHasherRegistry, ExecutionContext executionContext) {
        this.authInfoRepository = authInfoRepository;
        this.passwordHasherRegistry = passwordHasherRegistry;
        this.executionContext = executionContext;
        PasswordProvider.$init$(this);
        Logger.$init$(this);
        Statics.releaseFence();
    }
}

