/*
 * Decompiled with CFR 0.152.
 */
package play.silhouette.impl.providers.oauth1.secrets;

import javax.inject.Inject;
import play.api.mvc.Cookie;
import play.api.mvc.Result;
import play.silhouette.api.crypto.Crypter;
import play.silhouette.api.crypto.Signer;
import play.silhouette.api.util.Clock;
import play.silhouette.api.util.ExtractableRequest;
import play.silhouette.impl.exceptions.OAuth1TokenSecretException;
import play.silhouette.impl.exceptions.OAuth1TokenSecretException$;
import play.silhouette.impl.providers.OAuth1Info;
import play.silhouette.impl.providers.OAuth1TokenSecretProvider;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecret;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecret$;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecretProvider$;
import play.silhouette.impl.providers.oauth1.secrets.CookieSecretSettings;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\f\u0019\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u000b\u0011I\u0006\u0001\t.\t\u000bu\u0003A\u0011\t0\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\u0004\u0001\u0005B\u0005mqaBA 1!\u0005\u0011\u0011\t\u0004\u0007/aA\t!a\u0011\t\r%[A\u0011AA#\u0011%\t9e\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002\\-\u0001\u000b\u0011BA&\u0011%\tif\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002`-\u0001\u000b\u0011BA&\u0011%\t\tg\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002d-\u0001\u000b\u0011BA&\u0011%\t)g\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002h-\u0001\u000b\u0011BA&\u0011%\tIg\u0003b\u0001\n\u0003\tI\u0005\u0003\u0005\u0002l-\u0001\u000b\u0011BA&\u0005Q\u0019un\\6jKN+7M]3u!J|g/\u001b3fe*\u0011\u0011DG\u0001\bg\u0016\u001c'/\u001a;t\u0015\tYB$\u0001\u0004pCV$\b.\r\u0006\u0003;y\t\u0011\u0002\u001d:pm&$WM]:\u000b\u0005}\u0001\u0013\u0001B5na2T!!\t\u0012\u0002\u0015MLG\u000e[8vKR$XMC\u0001$\u0003\u0011\u0001H.Y=\u0004\u0001M\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\tic&D\u0001\u001d\u0013\tyCDA\rP\u0003V$\b.\r+pW\u0016t7+Z2sKR\u0004&o\u001c<jI\u0016\u0014\u0018\u0001C:fiRLgnZ:\u0011\u0005I\u001aT\"\u0001\r\n\u0005QB\"\u0001F\"p_.LWmU3de\u0016$8+\u001a;uS:<7/\u0001\u0004tS\u001etWM\u001d\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\naa\u0019:zaR|'BA\u001e!\u0003\r\t\u0007/[\u0005\u0003{a\u0012aaU5h]\u0016\u0014\u0018aB2ssB$XM\u001d\t\u0003o\u0001K!!\u0011\u001d\u0003\u000f\r\u0013\u0018\u0010\u001d;fe\u0006)1\r\\8dWB\u0011AiR\u0007\u0002\u000b*\u0011aIO\u0001\u0005kRLG.\u0003\u0002I\u000b\n)1\t\\8dW\u00061A(\u001b8jiz\"Ra\u0013'N\u001d>\u0003\"A\r\u0001\t\u000bA*\u0001\u0019A\u0019\t\u000bU*\u0001\u0019\u0001\u001c\t\u000by*\u0001\u0019A \t\u000b\t+\u0001\u0019A\")\u0005\u0015\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0019IgN[3di*\ta+A\u0003kCZ\f\u00070\u0003\u0002Y'\n1\u0011J\u001c6fGR\u0014aaU3de\u0016$\bC\u0001\u001a\\\u0013\ta\u0006D\u0001\u0007D_>\\\u0017.Z*fGJ,G/A\u0003ck&dG-\u0006\u0002`]R\u0011\u0001\r \u000b\u0004C\u001e<\bc\u00012f56\t1M\u0003\u0002eQ\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0019\u001c'A\u0002$viV\u0014X\rC\u0003i\u000f\u0001\u000f\u0011.A\u0004sKF,Xm\u001d;\u0011\u0007\u0011SG.\u0003\u0002l\u000b\n\u0011R\t\u001f;sC\u000e$\u0018M\u00197f%\u0016\fX/Z:u!\tig\u000e\u0004\u0001\u0005\u000b=<!\u0019\u00019\u0003\u0003\t\u000b\"!\u001d;\u0011\u0005\u001d\u0012\u0018BA:)\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aJ;\n\u0005YD#aA!os\")\u0001p\u0002a\u0002s\u0006\u0011Qm\u0019\t\u0003EjL!a_2\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B?\b\u0001\u0004q\u0018\u0001B5oM>\u0004\"!L@\n\u0007\u0005\u0005AD\u0001\u0006P\u0003V$\b.M%oM>\f\u0001B]3ue&,g/Z\u000b\u0005\u0003\u000f\t)\u0002\u0006\u0004\u0002\n\u0005=\u0011q\u0003\t\u0005E\u0016\fY\u0001E\u0002\u0002\u000e\u0019i\u0011\u0001\u0001\u0005\u0007Q\"\u0001\u001d!!\u0005\u0011\t\u0011S\u00171\u0003\t\u0004[\u0006UA!B8\t\u0005\u0004\u0001\b\"\u0002=\t\u0001\bI\u0018a\u00029vE2L7\u000f[\u000b\u0005\u0003;\t)\u0004\u0006\u0004\u0002 \u0005]\u00121\b\u000b\u0005\u0003C\ty\u0003\u0005\u0003\u0002$\u0005-RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0007548M\u0003\u0002<E%!\u0011QFA\u0013\u0005\u0019\u0011Vm];mi\"1\u0001.\u0003a\u0002\u0003c\u0001B\u0001\u00126\u00024A\u0019Q.!\u000e\u0005\u000b=L!\u0019\u00019\t\u000f\u0005e\u0012\u00021\u0001\u0002\"\u00051!/Z:vYRDa!!\u0010\n\u0001\u0004Q\u0016AB:fGJ,G/\u0001\u000bD_>\\\u0017.Z*fGJ,G\u000f\u0015:pm&$WM\u001d\t\u0003e-\u0019\"a\u0003\u0014\u0015\u0005\u0005\u0005\u0013!G\"mS\u0016tGoU3de\u0016$Hi\\3t\u001d>$X\t_5tiN,\"!a\u0013\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005!A.\u00198h\u0015\t\t)&\u0001\u0003kCZ\f\u0017\u0002BA-\u0003\u001f\u0012aa\u0015;sS:<\u0017AG\"mS\u0016tGoU3de\u0016$Hi\\3t\u001d>$X\t_5tiN\u0004\u0013aD*fGJ,G/S:FqBL'/\u001a3\u0002!M+7M]3u\u0013N,\u0005\u0010]5sK\u0012\u0004\u0013aC%om\u0006d\u0017\u000e\u001a&t_:\fA\"\u00138wC2LGMS:p]\u0002\n1#\u00138wC2LGmU3de\u0016$hi\u001c:nCR\fA#\u00138wC2LGmU3de\u0016$hi\u001c:nCR\u0004\u0013AF%om\u0006d\u0017\u000eZ\"p_.LWmU5h]\u0006$XO]3\u0002/%sg/\u00197jI\u000e{wn[5f'&<g.\u0019;ve\u0016\u0004\u0003")
public class CookieSecretProvider
implements OAuth1TokenSecretProvider {
    private final CookieSecretSettings settings;
    private final Signer signer;
    private final Crypter crypter;
    private final Clock clock;

    public static String InvalidCookieSignature() {
        return CookieSecretProvider$.MODULE$.InvalidCookieSignature();
    }

    public static String InvalidSecretFormat() {
        return CookieSecretProvider$.MODULE$.InvalidSecretFormat();
    }

    public static String InvalidJson() {
        return CookieSecretProvider$.MODULE$.InvalidJson();
    }

    public static String SecretIsExpired() {
        return CookieSecretProvider$.MODULE$.SecretIsExpired();
    }

    public static String ClientSecretDoesNotExists() {
        return CookieSecretProvider$.MODULE$.ClientSecretDoesNotExists();
    }

    public <B> Future<CookieSecret> build(OAuth1Info info, ExtractableRequest<B> request, ExecutionContext ec) {
        return Future$.MODULE$.successful((Object)new CookieSecret(info.secret(), this.clock.now().plusSeconds((int)this.settings.expirationTime().toSeconds())));
    }

    public <B> Future<CookieSecret> retrieve(ExtractableRequest<B> request, ExecutionContext ec) {
        Option option = request.cookies().get(this.settings.cookieName());
        if (option instanceof Some) {
            Some some = (Some)option;
            Cookie cookie = (Cookie)some.value();
            boolean bl = false;
            Success success = null;
            Try<CookieSecret> try_ = CookieSecret$.MODULE$.unserialize(cookie.value(), this.signer, this.crypter);
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                CookieSecret secret = (CookieSecret)success.value();
                if (secret.isExpired()) {
                    return Future$.MODULE$.failed((Throwable)new OAuth1TokenSecretException(CookieSecretProvider$.MODULE$.SecretIsExpired(), OAuth1TokenSecretException$.MODULE$.$lessinit$greater$default$2()));
                }
            }
            if (bl) {
                CookieSecret secret = (CookieSecret)success.value();
                return Future$.MODULE$.successful((Object)secret);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                return Future$.MODULE$.failed(error);
            }
            throw new MatchError(try_);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.failed((Throwable)new OAuth1TokenSecretException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(CookieSecretProvider$.MODULE$.ClientSecretDoesNotExists()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.settings.cookieName()})), OAuth1TokenSecretException$.MODULE$.$lessinit$greater$default$2()));
        }
        throw new MatchError((Object)option);
    }

    public <B> Result publish(Result result, CookieSecret secret, ExtractableRequest<B> request) {
        return result.withCookies((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Cookie[]{new Cookie(this.settings.cookieName(), CookieSecret$.MODULE$.serialize(secret, this.signer, this.crypter), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)((int)this.settings.expirationTime().toSeconds()))), this.settings.cookiePath(), this.settings.cookieDomain(), this.settings.secureCookie(), this.settings.httpOnlyCookie(), this.settings.sameSite())}));
    }

    @Inject
    public CookieSecretProvider(CookieSecretSettings settings, Signer signer, Crypter crypter, Clock clock) {
        this.settings = settings;
        this.signer = signer;
        this.crypter = crypter;
        this.clock = clock;
    }
}

