/**
 * Copyright [2008] [PLOIN GmbH -> http://www.ploin.de]
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package org.ploin.web.faces.phaselistener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpSession;
import java.io.Serializable;

/**
 * * PhaseListener for Phase 2. 
 * <p/>
 * $LastChangedBy: r.reiz $<br>
 * $Revision: 91 $<br>
 * $Date: 2010-01-18 22:26:53 +0100 (Mon, 18 Jan 2010) $<br>
 */
public class JsfPhaseListener02 implements PhaseListener, Serializable{


	private static final long serialVersionUID = -6971159838919531022L;
	private Log log = LogFactory.getLog(JsfPhaseListener02.class);
	private FacesContext facesContextTest = null;


	public void beforePhase(PhaseEvent arg0) {
		log.info("beforePhase " + getPhaseId());
		FacesContext facesContext = null;
		if (facesContextTest != null){
			facesContext = facesContextTest;
		} else {
			facesContext = FacesContext.getCurrentInstance();
		}
		HttpSession session = (HttpSession)facesContext.getExternalContext().getSession(true);
		session.setAttribute("jsfPhase", 2);
	}

	public void afterPhase(PhaseEvent event) {
		log.info("afterPhase " + getPhaseId());
	}

	public PhaseId getPhaseId() {
		return PhaseId.APPLY_REQUEST_VALUES;
	}

	public FacesContext getFacesContextTest() {
		return facesContextTest;
	}

	public void setFacesContextTest(FacesContext facesContextTest) {
		this.facesContextTest = facesContextTest;
	}

}