/*
 * Decompiled with CFR 0.152.
 */
package org.ploin.web.faces.validator;

import java.io.Serializable;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ploin.web.faces.validator.PloinJsfValidator;

public class HtmlKicker
extends PloinJsfValidator
implements Serializable {
    private static final long serialVersionUID = -4691129792307259008L;
    private Log log = LogFactory.getLog(HtmlKicker.class);

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String val = (String)value;
        if (val.matches(".*<.*") || val.matches(".*href.*") || val.matches(".*>.*") || val.matches(".*\\&.*")) {
            String message = null;
            try {
                String bundleName = context.getApplication().getMessageBundle();
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, this.getLocale());
                message = bundle.getString("ploin.htmlKicker");
            }
            catch (Exception e) {
                this.log.error((Object)"ERROR in HtmlKicker ", (Throwable)e);
            }
            if (message == null || message.equals("")) {
                message = "Validationerror. Please dont`t type in HTML-Tags or special signs like (&).";
            }
            throw new ValidatorException(new FacesMessage(message));
        }
    }
}

