/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex;

import java.lang.reflect.Method;
import java.util.StringJoiner;
import org.plyct.plyex.Endpoint;
import org.plyct.plyex.annotation.Ply;
import org.plyct.plyex.docgen.DocGenException;

public class PlyMethod {
    private String packageName;
    private String className;
    private String name;
    private String signature;
    private String request;
    private String[] responses;
    private String docComment;
    private Method method;
    private Endpoint endpoint;

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String[] getResponses() {
        return this.responses;
    }

    public void setResponses(String[] responses) {
        this.responses = responses;
    }

    public String getDocComment() {
        return this.docComment;
    }

    public void setDocComment(String docComment) {
        this.docComment = docComment;
    }

    public Method getMethod() {
        return this.method;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public PlyMethod(String packageName, String className, String name, String signature) throws DocGenException {
        this.packageName = packageName;
        this.className = className;
        this.name = name;
        this.signature = signature;
        try {
            this.method = this.findMethod();
        }
        catch (ReflectiveOperationException ex) {
            throw new DocGenException("Cannot reflect method: " + this, ex);
        }
        if (this.method == null) {
            throw new DocGenException("Cannot determine method: " + this);
        }
        if (this.method.getAnnotation(Ply.class) == null) {
            throw new DocGenException("Method missing @Ply annotation: " + this.method);
        }
    }

    private Method findMethod() throws ReflectiveOperationException {
        Class<?> clazz = Class.forName(this.packageName + "." + this.className);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(this.name)) continue;
            StringJoiner sj = new StringJoiner(",", method.getName() + "(", ")");
            for (Class<?> parameterType : method.getParameterTypes()) {
                sj.add(parameterType.getTypeName());
            }
            this.signature = sj.toString();
            if (!this.signature.equals(this.signature)) continue;
            return method;
        }
        return null;
    }

    public String toString() {
        return this.packageName + "." + this.className + "." + this.signature;
    }
}

