/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex;

import com.beust.jcommander.JCommander;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import org.plyct.plyex.PlyConfig;
import org.plyct.plyex.PlyexOptions;
import org.plyct.plyex.docgen.DocGen;
import org.plyct.plyex.util.Json;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class Plyex {
    private final PlyexOptions options;

    public Plyex(PlyexOptions options) {
        this.options = options;
    }

    public PlyConfig loadPlyConfig() throws IOException {
        File plyConfigFile = new File(this.options.getPlyConfigPath());
        if (!plyConfigFile.exists() && this.options.getPlyConfigPath().equals("plyconfig.json")) {
            File plyConfigYaml = new File("plyconfig.yaml");
            if (!plyConfigYaml.exists()) {
                plyConfigYaml = new File("plyconfig.yml");
            }
            if (plyConfigYaml.exists()) {
                plyConfigFile = plyConfigYaml;
            }
        }
        PlyConfig plyConfig = new PlyConfig();
        if (plyConfigFile.exists()) {
            String configContents = new String(Files.readAllBytes(plyConfigFile.toPath()));
            plyConfig = Json.isJson(plyConfigFile.toPath(), configContents) ? (PlyConfig)new Gson().fromJson(configContents, PlyConfig.class) : (PlyConfig)new Yaml((BaseConstructor)new Constructor(PlyConfig.class)).load(configContents);
            if (!plyConfig.verbose) {
                plyConfig.verbose = this.options.isDebug();
            }
            if (plyConfig.prettyIndent == 2 && this.options.getIndent() != 2) {
                plyConfig.prettyIndent = this.options.getIndent();
            }
            if (plyConfig.testsLocation.endsWith("/")) {
                plyConfig.testsLocation = plyConfig.testsLocation.substring(0, plyConfig.testsLocation.length() - 1);
            }
        }
        if (plyConfig.expectedLocation == null) {
            plyConfig.expectedLocation = plyConfig.testsLocation + "/results/expected";
        }
        if (plyConfig.actualLocation == null) {
            plyConfig.actualLocation = plyConfig.testsLocation + "/results/actual";
        }
        plyConfig.file = plyConfigFile;
        return plyConfig;
    }

    public static void main(String[] args) throws ArgsException {
        boolean debug;
        List<String> argsList = Arrays.asList(args);
        int debugIdx = argsList.indexOf("--debug");
        boolean bl = debug = debugIdx >= 0 && (argsList.size() == debugIdx + 1 || !"false".equals(argsList.get(debugIdx)));
        if (debug) {
            System.out.println("Java version: " + System.getProperty("java.version"));
        }
        try {
            PlyexOptions options = new PlyexOptions();
            DocGen docGen = new DocGen(options);
            JCommander jc = new JCommander((Object)options);
            jc.addCommand("docgen", (Object)docGen);
            jc.parse(args);
            if (options.isHelp()) {
                jc.usage();
            } else {
                Plyex plyex = new Plyex(options);
                options.setPlyConfig(plyex.loadPlyConfig());
                docGen.run();
            }
        }
        catch (Exception ex) {
            if (debug) {
                ex.printStackTrace();
            }
            throw new ArgsException(ex.getMessage());
        }
    }

    public static class ArgsException
    extends Exception {
        public ArgsException(String message) {
            super(message);
        }
    }
}

