/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex.code;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.plyct.plyex.Endpoint;
import org.plyct.plyex.code.TemplateContext;

public class CodeSamples {
    public static final String[] LANGUAGES = new String[]{"Java", "Python", "TypeScript"};
    private final Map<String, Template> templates = new LinkedHashMap<String, Template>();

    public CodeSamples(Endpoint.Method method) throws IOException {
        if (method == Endpoint.Method.get || method == Endpoint.Method.post || method == Endpoint.Method.put) {
            this.readTemplates(method);
        }
    }

    public void readTemplates(Endpoint.Method method) throws IOException {
        ClassPathTemplateLoader loader = new ClassPathTemplateLoader("/templates/" + (Object)((Object)method), ".handlebars");
        Handlebars handlebars = new Handlebars((TemplateLoader)loader);
        handlebars.prettyPrint(true);
        handlebars.registerHelper("capitalize", (lower, options) -> {
            if (lower != null && !lower.isEmpty()) {
                return String.valueOf(lower.charAt(0)).toUpperCase() + lower.substring(1);
            }
            return lower;
        });
        handlebars.registerHelper("expression", (str, options) -> "{" + str + "}");
        for (String language : LANGUAGES) {
            Template template = handlebars.compile(language);
            this.templates.put(language, template);
        }
    }

    public Map<String, String> getSamples(TemplateContext context) throws IOException {
        LinkedHashMap<String, String> samples = new LinkedHashMap<String, String>();
        for (String lang : this.templates.keySet()) {
            Template template = this.templates.get(lang);
            samples.put(lang, template.apply((Object)context));
        }
        return samples;
    }
}

