/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex.docgen;

import com.google.testing.compile.Compilation;
import com.google.testing.compile.Compiler;
import com.google.testing.compile.JavaFileObjects;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.plyct.plyex.PlyMethod;
import org.plyct.plyex.docgen.DocGenException;
import org.plyct.plyex.docgen.PlyProcessor;
import org.plyct.plyex.util.FileGlob;

public class DocGenCompiler {
    private final boolean debug;
    private final List<JavaFileObject> sourceFiles = new ArrayList<JavaFileObject>();

    public DocGenCompiler(Path root, List<String> sources) throws DocGenException {
        this(root, sources, false);
    }

    public DocGenCompiler(Path root, List<String> sources, boolean debug) throws DocGenException {
        this.debug = debug;
        if (debug) {
            System.out.println("Pseudo-compiling sources from root: " + root);
        }
        try {
            for (String source : sources) {
                for (Path match : new FileGlob(root, source).getMatches()) {
                    if (debug) {
                        System.out.println("  - " + match);
                    }
                    this.sourceFiles.add(JavaFileObjects.forResource((URL)match.toUri().toURL()));
                }
            }
        }
        catch (IOException ex) {
            if (debug) {
                ex.printStackTrace();
            }
            System.err.println("Error finding sources: " + ex);
        }
    }

    public List<PlyMethod> process() {
        PlyProcessor processor = new PlyProcessor(this.debug);
        Compiler compiler = Compiler.javac().withProcessors(new Processor[]{processor});
        Compilation compilation = compiler.compile(this.sourceFiles);
        for (Diagnostic error : compilation.errors()) {
            System.err.println("\nJava Compilation " + (Object)((Object)error.getKind()) + ":" + error.getSource() + "(" + error.getLineNumber() + "," + error.getColumnNumber() + ")\n   " + error.getMessage(null) + "\n");
        }
        return processor.getPlyMethods();
    }
}

