/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex.docgen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.plyct.plyex.PlyConfig;
import org.plyct.plyex.PlyMethod;
import org.plyct.plyex.PlyResult;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;

public class ExamplesMeta {
    private static final Map<File, Map<String, PlyResult>> expectedResults = new HashMap<File, Map<String, PlyResult>>();
    private static final Map<File, Map<String, PlyResult>> actualResults = new HashMap<File, Map<String, PlyResult>>();
    private final PlyConfig plyConfig;
    private String request;
    private Map<Integer, String> responses;

    public String getRequest() {
        return this.request;
    }

    public Map<Integer, String> getResponses() {
        return this.responses;
    }

    public ExamplesMeta(PlyConfig plyConfig, PlyMethod plyMethod, boolean isExamplesFromActual) throws IOException {
        PlyResult result;
        this.plyConfig = plyConfig;
        if (plyMethod.getRequest() != null && !plyMethod.getRequest().isEmpty() && (result = this.getResult(plyMethod.getRequest(), isExamplesFromActual)) != null && result.request != null) {
            this.request = result.request.body;
        }
        if (plyMethod.getResponses() != null && plyMethod.getResponses().length > 0) {
            for (String response : plyMethod.getResponses()) {
                PlyResult result2;
                if (response.isEmpty() || (result2 = this.getResult(response, isExamplesFromActual)) == null || result2.response == null || result2.response.status == null || result2.response.status.code <= 0) continue;
                if (this.responses == null) {
                    this.responses = new HashMap<Integer, String>();
                }
                this.responses.put(result2.response.status.code, result2.response.body);
            }
        }
    }

    private PlyResult getResult(String requestPath, boolean isActual) throws IOException {
        String requestName;
        PlyResult result;
        Map<String, PlyResult> results;
        int hash = requestPath.lastIndexOf(35);
        if (hash == -1 || hash > requestPath.length() - 1) {
            throw new Error("Ply example path must include '#<requestName>': " + requestPath);
        }
        Path testsPath = new File(this.plyConfig.testsLocation).toPath();
        Path plyConfigDir = new File(".").toPath();
        if (this.plyConfig.file != null && this.plyConfig.file.getParentFile() != null) {
            plyConfigDir = this.plyConfig.file.getParentFile().toPath();
        }
        boolean plyConfigInCwd = Files.isSameFile(plyConfigDir, new File(".").toPath());
        if (!testsPath.isAbsolute() && !plyConfigInCwd) {
            testsPath = new File(plyConfigDir + File.separator + testsPath).toPath().normalize();
        }
        File suiteFile = new File(requestPath.substring(0, hash));
        Map<String, PlyResult> map = results = isActual ? actualResults.get(suiteFile) : expectedResults.get(suiteFile);
        if (results == null) {
            Path resultsPath;
            String suiteBaseName = suiteFile.getName().substring(0, suiteFile.getName().lastIndexOf("."));
            Path relPath = testsPath.relativize(suiteFile.toPath()).getParent();
            String resultsBase = (isActual ? this.plyConfig.actualLocation : this.plyConfig.expectedLocation) + File.separator + (relPath == null ? "" : relPath) + File.separator + suiteBaseName;
            if (resultsBase.endsWith(".ply")) {
                resultsBase = resultsBase.substring(0, resultsBase.length() - 4);
            }
            if (!(resultsPath = new File(resultsBase + ".yml").toPath()).isAbsolute() && !plyConfigInCwd) {
                resultsPath = new File(plyConfigDir + File.separator + resultsPath).toPath().normalize();
            }
            if (!resultsPath.toFile().exists()) {
                String exp = resultsPath.toString();
                resultsPath = new File(exp.substring(0, exp.lastIndexOf(".")) + ".yaml").toPath();
            }
            if (!resultsPath.toFile().exists()) {
                throw new IOException("Expected result file not found: " + resultsPath.normalize() + " (or .yml)");
            }
            results = this.parseResults(resultsPath.toFile());
            if (isActual) {
                actualResults.put(suiteFile, results);
            } else {
                expectedResults.put(suiteFile, results);
            }
        }
        if ((result = results.get(requestName = requestPath.substring(hash + 1))) == null) {
            throw new IOException((isActual ? "Actual" : "Expected") + " result for " + requestName + " not found");
        }
        return result;
    }

    private Map<String, PlyResult> parseResults(File resultFile) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(resultFile));){
            String line;
            StringBuilder builder = new StringBuilder("results:\n");
            while ((line = br.readLine()) != null) {
                for (int i = 0; i < this.plyConfig.prettyIndent; ++i) {
                    builder.append(" ");
                }
                builder.append(line).append("\n");
            }
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(PlyResults.class));
            try {
                PlyResults plyResults = (PlyResults)yaml.load(builder.toString());
                Map<String, PlyResult> map = plyResults.results;
                return map;
            }
            catch (YAMLException ex) {
                throw new IOException("Failed to parse " + resultFile + ": " + ex.getMessage(), ex);
            }
        }
    }

    static class PlyResults {
        public Map<String, PlyResult> results;

        PlyResults() {
        }
    }
}

