/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex.openapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.plyct.plyex.openapi.ApiDoc;
import org.plyct.plyex.openapi.OpenApi;

public class JsonDoc
implements ApiDoc {
    private Gson gson;

    public JsonDoc() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Double.class, (src, typeOfSrc, context) -> {
            if (src % 1.0 == 0.0) {
                return new JsonPrimitive((Number)src.longValue());
            }
            return new JsonPrimitive((Number)src);
        });
        this.gson = builder.create();
    }

    @Override
    public OpenApi load(String json) {
        return (OpenApi)this.gson.fromJson(json, OpenApi.class);
    }

    @Override
    public String dump(OpenApi openApi, int indent) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        StringBuilder pad = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            pad.append(' ');
        }
        jsonWriter.setIndent(pad.toString());
        this.gson.toJson((Object)openApi, OpenApi.class, jsonWriter);
        return stringWriter.toString();
    }
}

