/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class FileGlob
extends SimpleFileVisitor<Path> {
    private final Path root;
    private final PathMatcher matcher;
    private List<Path> matches = new ArrayList<Path>();

    public FileGlob(Path root, String pattern) {
        this.root = root;
        this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
    }

    public List<Path> getMatches() throws IOException {
        Files.walkFileTree(this.root, this);
        return this.matches;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        if (this.matcher.matches(this.root.relativize(path))) {
            this.matches.add(path);
        }
        return FileVisitResult.CONTINUE;
    }
}

