/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex.openapi;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.plyct.plyex.openapi.ApiDoc;
import org.plyct.plyex.openapi.OpenApi;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;

public class YamlDoc
implements ApiDoc {
    private final Yaml yaml;
    private final Constructor constructor;
    private final Representer representer;
    private final DumperOptions dumperOptions;

    public YamlDoc() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setMaxAliasesForCollections(100);
        this.constructor = new Constructor(OpenApi.class, loaderOptions);
        this.dumperOptions = new DumperOptions();
        this.dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.dumperOptions.setPrettyFlow(true);
        this.dumperOptions.setSplitLines(false);
        this.dumperOptions.setIndentWithIndicator(true);
        this.representer = new Representer(this.dumperOptions);
        this.addCustomTypeDescription(OpenApi.BodyContent.class);
        this.addCustomTypeDescription(OpenApi.Schema.class);
        this.addCustomTypeDescription(OpenApi.Items.class);
        this.addCustomTypeDescription(OpenApi.Operation.class);
        this.yaml = new Yaml((BaseConstructor)this.constructor, (org.yaml.snakeyaml.representer.Representer)this.representer, this.dumperOptions);
    }

    private void addCustomTypeDescription(Class<? extends Object> clazz) {
        TypeDescription typeDescription = new TypeDescription(clazz);
        typeDescription.substituteProperty("application/json", clazz, "getApplicationJson", "setApplicationJson", new Class[0]);
        typeDescription.substituteProperty("application/xml", clazz, "getApplicationXml", "setApplicationXml", new Class[0]);
        typeDescription.substituteProperty("*/*", clazz, "getStarStar", "setStarStar", new Class[0]);
        typeDescription.substituteProperty("$ref", clazz, "getRef", "setRef", new Class[0]);
        typeDescription.substituteProperty("x-codeSamples", clazz, "getCodeSamples", "setCodeSamples", new Class[0]);
        typeDescription.setExcludes(new String[]{"applicationJson", "applicationXml", "starStar", "ref", "codeSamples"});
        this.constructor.addTypeDescription((org.yaml.snakeyaml.TypeDescription)typeDescription);
        this.representer.addTypeDescription(typeDescription);
    }

    @Override
    public OpenApi load(String yaml) {
        return (OpenApi)this.yaml.load(yaml);
    }

    @Override
    public String dump(OpenApi openApi, int indent) {
        this.dumperOptions.setIndent(indent);
        this.dumperOptions.setIndicatorIndent(indent);
        String yaml = this.yaml.dump((Object)openApi);
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : yaml.split("\\r?\\n")) {
            int bangBang = line.indexOf("!!");
            if (bangBang == -1) {
                lines.add(line);
                continue;
            }
            if (bangBang <= 0) continue;
            lines.add(line.substring(0, bangBang).replaceAll("\\s+$", ""));
        }
        return String.join((CharSequence)System.lineSeparator(), lines) + System.lineSeparator();
    }

    class TypeDescription
    extends org.yaml.snakeyaml.TypeDescription {
        public TypeDescription(Class<? extends Object> clazz) {
            super(clazz);
        }

        public Property getProperty(String name) {
            if (name.equals("application/json")) {
                return super.getProperty("applicationJson");
            }
            if (name.equals("application/xml")) {
                return super.getProperty("applicationXml");
            }
            if (name.equals("*/*")) {
                return super.getProperty("starStar");
            }
            if (name.equals("$ref")) {
                return super.getProperty("ref");
            }
            if (name.equals("x-codeSamples")) {
                return super.getProperty("codeSamples");
            }
            return super.getProperty(name);
        }
    }

    class Representer
    extends org.yaml.snakeyaml.representer.Representer {
        public Representer(DumperOptions dumperOptions) {
            super(dumperOptions);
            this.setPropertyUtils(new PropertyUtils(){

                protected Set<Property> createPropertySet(Class<? extends Object> type, BeanAccess bAccess) {
                    return ((Stream)this.getPropertiesMap(type, bAccess).values().stream().sequential()).filter(prop -> prop.isReadable() && (this.isAllowReadOnlyProperties() || prop.isWritable())).collect(Collectors.toCollection(LinkedHashSet::new));
                }
            });
        }

        protected Set<Property> getProperties(Class<? extends Object> type) {
            Set propSet = super.getProperties(type);
            if (type == OpenApi.Operation.class) {
                LinkedHashSet<Property> opPropSet = new LinkedHashSet<Property>();
                Property codeSamplesProp = null;
                for (Property prop : propSet) {
                    if (prop.getName().equals("x-codeSamples")) {
                        codeSamplesProp = prop;
                        continue;
                    }
                    opPropSet.add(prop);
                }
                if (codeSamplesProp != null) {
                    opPropSet.add(codeSamplesProp);
                }
                return opPropSet;
            }
            return propSet;
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (propertyValue == null) {
                return null;
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }
    }
}

