/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex.docgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.plyct.plyex.PlyMethod;
import org.plyct.plyex.annotation.Ply;

public class PlyProcessor
extends AbstractProcessor {
    private final boolean debug;
    private final List<PlyMethod> plyMethods = new ArrayList<PlyMethod>();

    public List<PlyMethod> getPlyMethods() {
        return this.plyMethods;
    }

    PlyProcessor(boolean debug) {
        this.debug = debug;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        if (this.debug) {
            System.out.println("Initializing PlyProcessor with source version: " + (Object)((Object)processingEnv.getSourceVersion()));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.debug && !roundEnv.getRootElements().isEmpty()) {
            System.out.println("Scanning for PlyMethods in " + roundEnv.getRootElements() + ":");
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                String signature;
                block7: {
                    if (element.getKind() != ElementKind.METHOD) continue;
                    signature = element.toString();
                    ExecutableElement execElem = (ExecutableElement)element;
                    List<? extends VariableElement> params = execElem.getParameters();
                    try {
                        if (!params.isEmpty()) {
                            List argTypes = params.stream().map(p -> this.processingEnv.getTypeUtils().asElement(p.asType()).toString()).collect(Collectors.toList());
                            signature = element.getSimpleName().toString() + "(" + String.join((CharSequence)",", argTypes) + ")";
                        }
                    }
                    catch (Error err) {
                        System.err.println(err.getMessage());
                        if (!this.debug) break block7;
                        err.printStackTrace();
                    }
                }
                PlyMethod plyMethod = new PlyMethod(this.processingEnv.getElementUtils().getPackageOf(element).toString(), element.getEnclosingElement().getSimpleName().toString(), element.getSimpleName().toString(), signature);
                if (this.debug) {
                    System.out.println("  - " + plyMethod);
                }
                Ply ply = element.getAnnotation(Ply.class);
                plyMethod.setRequest(ply.request());
                plyMethod.setResponses(ply.responses());
                plyMethod.setDocComment(this.processingEnv.getElementUtils().getDocComment(element));
                this.plyMethods.add(plyMethod);
            }
        }
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(Ply.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

