/*
 * Decompiled with CFR 0.152.
 */
package org.plyct.plyex.spring;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.plyct.plyex.Endpoint;
import org.plyct.plyex.plugin.PlyexPlugin;
import org.plyct.plyex.spring.ClassMapping;
import org.plyct.plyex.spring.MethodMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class PlyexSpring
implements PlyexPlugin {
    @Override
    public Endpoint[] getEndpoints(Method method) {
        ClassMapping classMapping = new ClassMapping(method.getDeclaringClass());
        MethodMapping methodMapping = new MethodMapping(method);
        ArrayList<String> paths = new ArrayList<String>();
        if (classMapping.getPaths().size() > 0) {
            for (String classRequestPath : classMapping.getPaths()) {
                if (methodMapping.getPaths().size() > 0) {
                    for (String path : methodMapping.getPaths()) {
                        paths.add(classRequestPath + path);
                    }
                    continue;
                }
                paths.add(classRequestPath);
            }
        } else {
            paths.addAll(methodMapping.getPaths());
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        if (methodMapping.isAnnotated()) {
            List<RequestMethod> classMethods = classMapping.getMethods();
            for (RequestMethod classMethod : classMethods) {
                endpoints.addAll(this.getEndpoints(classMethod, classMethods, paths));
            }
        }
        endpoints.addAll(this.getEndpoints(null, methodMapping.getMethods(), paths));
        return endpoints.toArray(new Endpoint[0]);
    }

    List<Endpoint> getEndpoints(RequestMethod classMethod, List<RequestMethod> requestMethods, List<String> paths) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (RequestMethod methodMethod : requestMethods) {
            Endpoint.Method httpMethod = this.getHttpMethod(methodMethod);
            for (String path : paths) {
                endpoints.add(new Endpoint(httpMethod, path));
                if (classMethod == null || requestMethods.contains(classMethod)) continue;
                endpoints.add(new Endpoint(this.getHttpMethod(classMethod), path));
            }
        }
        return endpoints;
    }

    private Endpoint.Method getHttpMethod(RequestMethod requestMethod) {
        return Endpoint.Method.valueOf(requestMethod.toString().toLowerCase());
    }
}

