/*
 * Copyright (c) 2017-2019 AutoDeploy AI
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org

/**
 * Core PMML4S functionality. A PMML (Predictive Model Markup Language) scoring library in Scala. PMML is the leading
 * standard for statistical and data mining models and supported by over 20 vendors and organizations. With PMML, it is
 * easy to develop a model on one system using one application and deploy the model on another system using another
 * application, simply by transmitting an XML configuration file.
 *
 * @see [[http://dmg.org/]] for details about PMML
 */
package object pmml4s {

  val PMML4S_VERSION = "0.9.5"

}
