/*
 * Decompiled with CFR 0.152.
 */
package org.pointyware.disco.training.data;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.pointyware.disco.entities.tensors.Tensor;
import org.pointyware.disco.entities.tensors.TensorKt;
import org.pointyware.disco.training.data.ExerciseGenerator;
import org.pointyware.disco.training.data.Problem;
import org.pointyware.disco.training.entities.Exercise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/pointyware/disco/training/data/SpiralExerciseGenerator;", "Lorg/pointyware/disco/training/data/ExerciseGenerator;", "problem", "Lorg/pointyware/disco/training/data/Problem$SpiralClassificationProblem;", "batchSize", "", "<init>", "(Lorg/pointyware/disco/training/data/Problem$SpiralClassificationProblem;I)V", "getProblem", "()Lorg/pointyware/disco/training/data/Problem$SpiralClassificationProblem;", "getBatchSize", "()I", "generate", "", "Lorg/pointyware/disco/training/entities/Exercise;", "feature-training"})
@StabilityInferred(parameters=1)
public final class SpiralExerciseGenerator
implements ExerciseGenerator {
    @NotNull
    private final Problem.SpiralClassificationProblem problem;
    private final int batchSize;
    public static final int $stable;

    public SpiralExerciseGenerator(@NotNull Problem.SpiralClassificationProblem problem, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        this.problem = problem;
        this.batchSize = batchSize;
    }

    public /* synthetic */ SpiralExerciseGenerator(Problem.SpiralClassificationProblem spiralClassificationProblem, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        this(spiralClassificationProblem, n);
    }

    @NotNull
    public final Problem.SpiralClassificationProblem getProblem() {
        return this.problem;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Exercise> generate() {
        int n = this.batchSize;
        ArrayList<Exercise> arrayList = new ArrayList<Exercise>(n);
        for (int i = 0; i < n; ++i) {
            void index;
            int n2;
            int n3 = n2 = i;
            ArrayList<Exercise> arrayList2 = arrayList;
            boolean bl = false;
            void classId = index % 2;
            double phaseOffset = classId == false ? 0.0 : Math.PI;
            float t = Random.Default.nextFloat();
            double theta = Math.PI * 2 * (double)t * (double)this.problem.getSpiralCount() + phaseOffset;
            double x = (double)t * Math.cos(theta) * (double)this.problem.getXMagnitude();
            double y = (double)t * Math.sin(theta) * (double)this.problem.getYMagnitude();
            float[] fArray = new float[]{(float)x, (float)y};
            Tensor tensor = TensorKt.columnVector((float[])fArray);
            fArray = new float[]{(float)classId};
            arrayList2.add(new Exercise(tensor, TensorKt.columnVector((float[])fArray)));
        }
        return arrayList;
    }
}

