/*
 * Decompiled with CFR 0.152.
 */
package org.pointyware.disco.training.entities.optimizers;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pointyware.disco.entities.DataList;
import org.pointyware.disco.entities.layers.Layer;
import org.pointyware.disco.entities.tensors.Tensor;
import org.pointyware.disco.training.entities.Exercise;
import org.pointyware.disco.training.entities.Measurement;
import org.pointyware.disco.training.entities.Snapshot;
import org.pointyware.disco.training.entities.Statistics;
import org.pointyware.disco.training.entities.optimizers.MultiPassOptimizer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020!H\u0016J\t\u0010\"\u001a\u00020\u0004H\u00c6\u0003J\t\u0010#\u001a\u00020\u0004H\u00c6\u0003J\t\u0010$\u001a\u00020\u0004H\u00c6\u0003J\t\u0010%\u001a\u00020\u0004H\u00c6\u0003J\t\u0010&\u001a\u00020\u0002H\u00c6\u0003J;\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0002H\u00c6\u0001J\t\u0010(\u001a\u00020)H\u0096\u0001J#\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,0+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.H\u0096\u0001J\u0013\u0010/\u001a\u00020!2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u00020\u0019H\u00d6\u0001J\u0017\u00103\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.H\u0096\u0001J\t\u00104\u001a\u000205H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u00106\u001a\u00020\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001c\u00109\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030.0\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0012\u0010<\u001a\u00020,X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lorg/pointyware/disco/training/entities/optimizers/Adam;", "Lorg/pointyware/disco/training/entities/optimizers/MultiPassOptimizer;", "Lorg/pointyware/disco/training/entities/Statistics;", "alpha", "", "beta1", "beta2", "epsilon", "statistics", "<init>", "(DDDDLorg/pointyware/disco/training/entities/Statistics;)V", "getAlpha", "()D", "getBeta1", "getBeta2", "getEpsilon", "getStatistics", "()Lorg/pointyware/disco/training/entities/Statistics;", "batch", "", "Lorg/pointyware/disco/training/entities/Exercise;", "cases", "update", "", "step", "", "epoch", "layer", "Lorg/pointyware/disco/entities/layers/Layer;", "weightGradients", "Lorg/pointyware/disco/entities/tensors/Tensor;", "biasGradients", "passAgain", "", "component1", "component2", "component3", "component4", "component5", "copy", "createSnapshot", "Lorg/pointyware/disco/training/entities/Snapshot;", "data", "Lorg/pointyware/disco/entities/DataList;", "", "key", "Lorg/pointyware/disco/training/entities/Measurement;", "equals", "other", "", "hashCode", "measurementMaximum", "toString", "", "epochCount", "getEpochCount", "()I", "measurements", "getMeasurements", "()Ljava/util/List;", "measurementsMax", "getMeasurementsMax", "()F", "feature-training"})
@StabilityInferred(parameters=0)
public final class Adam
implements MultiPassOptimizer,
Statistics {
    private final double alpha;
    private final double beta1;
    private final double beta2;
    private final double epsilon;
    @NotNull
    private final Statistics statistics;
    public static final int $stable = 8;

    public Adam(double alpha, double beta1, double beta2, double epsilon, @NotNull Statistics statistics) {
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        this.alpha = alpha;
        this.beta1 = beta1;
        this.beta2 = beta2;
        this.epsilon = epsilon;
        this.statistics = statistics;
    }

    public /* synthetic */ Adam(double d, double d2, double d3, double d4, Statistics statistics, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.001;
        }
        if ((n & 2) != 0) {
            d2 = 0.9;
        }
        if ((n & 4) != 0) {
            d3 = 0.999;
        }
        if ((n & 8) != 0) {
            d4 = 1.0E-8;
        }
        this(d, d2, d3, d4, statistics);
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public final double getBeta1() {
        return this.beta1;
    }

    public final double getBeta2() {
        return this.beta2;
    }

    public final double getEpsilon() {
        return this.epsilon;
    }

    @NotNull
    public final Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    @NotNull
    public List<List<Exercise>> batch(@NotNull List<Exercise> cases) {
        Intrinsics.checkNotNullParameter(cases, (String)"cases");
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    public void update(int step, int epoch, @NotNull Layer layer, @NotNull Tensor weightGradients, @NotNull Tensor biasGradients) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)weightGradients, (String)"weightGradients");
        Intrinsics.checkNotNullParameter((Object)biasGradients, (String)"biasGradients");
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    public boolean passAgain() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    public final double component1() {
        return this.alpha;
    }

    public final double component2() {
        return this.beta1;
    }

    public final double component3() {
        return this.beta2;
    }

    public final double component4() {
        return this.epsilon;
    }

    @NotNull
    public final Statistics component5() {
        return this.statistics;
    }

    @NotNull
    public final Adam copy(double alpha, double beta1, double beta2, double epsilon, @NotNull Statistics statistics) {
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"statistics");
        return new Adam(alpha, beta1, beta2, epsilon, statistics);
    }

    public static /* synthetic */ Adam copy$default(Adam adam, double d, double d2, double d3, double d4, Statistics statistics, int n, Object object) {
        if ((n & 1) != 0) {
            d = adam.alpha;
        }
        if ((n & 2) != 0) {
            d2 = adam.beta1;
        }
        if ((n & 4) != 0) {
            d3 = adam.beta2;
        }
        if ((n & 8) != 0) {
            d4 = adam.epsilon;
        }
        if ((n & 0x10) != 0) {
            statistics = adam.statistics;
        }
        return adam.copy(d, d2, d3, d4, statistics);
    }

    @NotNull
    public String toString() {
        return "Adam(alpha=" + this.alpha + ", beta1=" + this.beta1 + ", beta2=" + this.beta2 + ", epsilon=" + this.epsilon + ", statistics=" + this.statistics + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.alpha);
        result = result * 31 + Double.hashCode(this.beta1);
        result = result * 31 + Double.hashCode(this.beta2);
        result = result * 31 + Double.hashCode(this.epsilon);
        result = result * 31 + this.statistics.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Adam)) {
            return false;
        }
        Adam adam = (Adam)other;
        if (Double.compare(this.alpha, adam.alpha) != 0) {
            return false;
        }
        if (Double.compare(this.beta1, adam.beta1) != 0) {
            return false;
        }
        if (Double.compare(this.beta2, adam.beta2) != 0) {
            return false;
        }
        if (Double.compare(this.epsilon, adam.epsilon) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.statistics, (Object)adam.statistics);
    }

    @Override
    @NotNull
    public List<Measurement<?>> getMeasurements() {
        return this.statistics.getMeasurements();
    }

    @Override
    public float measurementMaximum(@NotNull Measurement<Float> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.statistics.measurementMaximum(key);
    }

    @Override
    public float getMeasurementsMax() {
        return this.statistics.getMeasurementsMax();
    }

    @Override
    public int getEpochCount() {
        return this.statistics.getEpochCount();
    }

    @Override
    @NotNull
    public DataList<Float, Float> data(@NotNull Measurement<Float> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.statistics.data(key);
    }

    @Override
    @NotNull
    public Snapshot createSnapshot() {
        return this.statistics.createSnapshot();
    }
}

