/*
 * Decompiled with CFR 0.152.
 */
package org.pointyware.disco.training.entities.optimizers;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pointyware.disco.training.entities.optimizers.LearningRateSchedule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/pointyware/disco/training/entities/optimizers/WarmRestartExponentialLearningRate;", "Lorg/pointyware/disco/training/entities/optimizers/LearningRateSchedule;", "initialLearningRate", "", "decayMax", "decayPeriod", "", "<init>", "(FFI)V", "getInitialLearningRate", "()F", "getDecayMax", "getDecayPeriod", "()I", "learningRate", "epoch", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "feature-training"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nLearningRateSchedule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LearningRateSchedule.kt\norg/pointyware/disco/training/entities/optimizers/WarmRestartExponentialLearningRate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class WarmRestartExponentialLearningRate
implements LearningRateSchedule {
    private final float initialLearningRate;
    private final float decayMax;
    private final int decayPeriod;
    public static final int $stable;

    public WarmRestartExponentialLearningRate(float initialLearningRate, float decayMax, int decayPeriod) {
        this.initialLearningRate = initialLearningRate;
        this.decayMax = decayMax;
        this.decayPeriod = decayPeriod;
        if (!(this.initialLearningRate > 0.0f)) {
            boolean $i$a$-require-WarmRestartExponentialLearningRate$42 = false;
            String $i$a$-require-WarmRestartExponentialLearningRate$42 = "Learning rate must be positive.";
            throw new IllegalArgumentException($i$a$-require-WarmRestartExponentialLearningRate$42.toString());
        }
        if (!(this.decayPeriod > 0)) {
            boolean $i$a$-require-WarmRestartExponentialLearningRate$52 = false;
            String $i$a$-require-WarmRestartExponentialLearningRate$52 = "Decay period must be greater than 0";
            throw new IllegalArgumentException($i$a$-require-WarmRestartExponentialLearningRate$52.toString());
        }
        if (!(this.decayMax > 0.0f)) {
            boolean bl = false;
            String string2 = "Decay max must be greater than 0";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ WarmRestartExponentialLearningRate(float f, float f2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            f2 = 100.0f;
        }
        if ((n2 & 4) != 0) {
            n = 10000;
        }
        this(f, f2, n);
    }

    public final float getInitialLearningRate() {
        return this.initialLearningRate;
    }

    public final float getDecayMax() {
        return this.decayMax;
    }

    public final int getDecayPeriod() {
        return this.decayPeriod;
    }

    @Override
    public float learningRate(int epoch) {
        int cyclePhase = epoch % this.decayPeriod;
        return this.initialLearningRate / (float)Math.pow(this.decayMax, (float)cyclePhase / (float)this.decayPeriod);
    }

    public final float component1() {
        return this.initialLearningRate;
    }

    public final float component2() {
        return this.decayMax;
    }

    public final int component3() {
        return this.decayPeriod;
    }

    @NotNull
    public final WarmRestartExponentialLearningRate copy(float initialLearningRate, float decayMax, int decayPeriod) {
        return new WarmRestartExponentialLearningRate(initialLearningRate, decayMax, decayPeriod);
    }

    public static /* synthetic */ WarmRestartExponentialLearningRate copy$default(WarmRestartExponentialLearningRate warmRestartExponentialLearningRate, float f, float f2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            f = warmRestartExponentialLearningRate.initialLearningRate;
        }
        if ((n2 & 2) != 0) {
            f2 = warmRestartExponentialLearningRate.decayMax;
        }
        if ((n2 & 4) != 0) {
            n = warmRestartExponentialLearningRate.decayPeriod;
        }
        return warmRestartExponentialLearningRate.copy(f, f2, n);
    }

    @NotNull
    public String toString() {
        return "WarmRestartExponentialLearningRate(initialLearningRate=" + this.initialLearningRate + ", decayMax=" + this.decayMax + ", decayPeriod=" + this.decayPeriod + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.initialLearningRate);
        result = result * 31 + Float.hashCode(this.decayMax);
        result = result * 31 + Integer.hashCode(this.decayPeriod);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WarmRestartExponentialLearningRate)) {
            return false;
        }
        WarmRestartExponentialLearningRate warmRestartExponentialLearningRate = (WarmRestartExponentialLearningRate)other;
        if (Float.compare(this.initialLearningRate, warmRestartExponentialLearningRate.initialLearningRate) != 0) {
            return false;
        }
        if (Float.compare(this.decayMax, warmRestartExponentialLearningRate.decayMax) != 0) {
            return false;
        }
        return this.decayPeriod == warmRestartExponentialLearningRate.decayPeriod;
    }
}

